/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.LeftInheritanceTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.DefaultMailbox;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MonotonicityAwareMailbox;
import org.eclipse.viatra.query.runtime.rete.network.MonotonicityAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;
import org.eclipse.viatra.query.runtime.rete.tuple.Clearable;

public class ColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends SingleInputNode
implements Clearable,
IAggregatorNode,
RederivableNode,
MonotonicityAwareReceiver {
    protected final IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator;
    protected final TupleMask groupMask;
    protected final TupleMask columnMask;
    protected final IPosetComparator posetComparator;
    protected final int sourceWidth;
    protected final IQueryRuntimeContext runtimeContext;
    protected final boolean deleteRederiveEvaluation;
    protected final Map<Tuple, Accumulator> memory;
    protected final Map<Tuple, Accumulator> rederivableMemory;
    private final AggregateResult NEUTRAL;
    AggregatorOuterIndexer aggregatorOuterIndexer = null;
    AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers = null;

    public ColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, boolean deleteRederiveEvaluation, TupleMask groupMask, TupleMask columnMask, IPosetComparator posetComparator) {
        super(reteContainer);
        this.operator = operator;
        this.groupMask = groupMask;
        this.columnMask = columnMask;
        this.memory = CollectionsFactory.getMap();
        this.rederivableMemory = CollectionsFactory.getMap();
        this.deleteRederiveEvaluation = deleteRederiveEvaluation;
        this.posetComparator = posetComparator;
        this.mailbox = this.instantiateMailbox();
        this.sourceWidth = groupMask.indices.length;
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
        this.NEUTRAL = operator.getAggregate(operator.createNeutral());
        reteContainer.registerClearable(this);
    }

    public ColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, int aggregatedColumn) {
        this(reteContainer, operator, false, groupMask, TupleMask.selectSingle((int)aggregatedColumn, (int)groupMask.sourceWidth), null);
    }

    @Override
    protected Mailbox instantiateMailbox() {
        if (this.groupMask != null && this.columnMask != null && this.posetComparator != null) {
            return new MonotonicityAwareMailbox(this, this.reteContainer);
        }
        return new DefaultMailbox(this, this.reteContainer);
    }

    @Override
    public TupleMask getCoreMask() {
        return this.groupMask;
    }

    @Override
    public TupleMask getPosetMask() {
        return this.columnMask;
    }

    @Override
    public IPosetComparator getPosetComparator() {
        return this.posetComparator;
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendChild(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
            this.reteContainer.getTracker().registerDependency(this, this.aggregatorOuterIndexer);
        }
        return this.aggregatorOuterIndexer;
    }

    @Override
    public Indexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.sourceWidth + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
            this.reteContainer.getTracker().registerDependency(this, this.aggregatorOuterIdentityIndexers[resultPositionInSignature]);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    @Override
    public void rederiveOne() {
        Map.Entry<Tuple, Accumulator> entry = this.rederivableMemory.entrySet().iterator().next();
        Tuple group = entry.getKey();
        Accumulator accumulator = entry.getValue();
        this.rederivableMemory.remove(group);
        this.memory.put(group, accumulator);
        if (this.rederivableMemory.isEmpty()) {
            this.reteContainer.getTracker().removeRederivable(this);
        }
        Object value = this.operator.getAggregate(accumulator);
        this.propagate(group, this.NEUTRAL, value);
    }

    @Override
    public void update(Direction direction, Tuple update, boolean monotone) {
        if (this.deleteRederiveEvaluation) {
            this.updateWithDeleteAndRederive(direction, update, monotone);
        } else {
            this.updateDefault(direction, update);
        }
    }

    @Override
    public void update(Direction direction, Tuple update) {
        this.update(direction, update, false);
    }

    protected void updateDefault(Direction direction, Tuple update) {
        Tuple key = this.groupMask.transform(update);
        Tuple value = this.columnMask.transform(update);
        Object aggregableValue = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Accumulator oldMainAccumulator = this.getMainAccumulator(key);
        Object oldValue = this.operator.getAggregate(oldMainAccumulator);
        Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
        this.storeIfNotNeutral(key, newMainAccumulator, this.memory);
        Object newValue = this.operator.getAggregate(newMainAccumulator);
        this.propagate(key, oldValue, newValue);
    }

    protected void updateWithDeleteAndRederive(Direction direction, Tuple update, boolean monotone) {
        Tuple group = this.groupMask.transform(update);
        Tuple value = this.columnMask.transform(update);
        Object aggregableValue = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Object oldMainAccumulator = this.memory.get(group);
        Accumulator oldRederivableAccumulator = this.rederivableMemory.get(group);
        if (direction == Direction.INSERT) {
            if (oldRederivableAccumulator != null) {
                Object newRederivableAccumulator = this.operator.update(oldRederivableAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newRederivableAccumulator, this.rederivableMemory);
                if (this.rederivableMemory.isEmpty()) {
                    this.reteContainer.getTracker().removeRederivable(this);
                }
            } else {
                if (oldMainAccumulator == null) {
                    oldMainAccumulator = this.operator.createNeutral();
                }
                Object oldValue = this.operator.getAggregate(oldMainAccumulator);
                Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newMainAccumulator, this.memory);
                Object newValue = this.operator.getAggregate(newMainAccumulator);
                this.propagate(group, oldValue, newValue);
            }
        } else if (oldRederivableAccumulator != null) {
            if (oldMainAccumulator != null) {
                this.issueError("[INTERNAL ERROR] Inconsistent state for " + update + " because it is present both in the main and re-derivable memory in the ColumnAggregatorNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
            }
            try {
                Object newRederivableAccumulator = this.operator.update(oldRederivableAccumulator, aggregableValue, isInsertion);
                this.storeIfNotNeutral(group, newRederivableAccumulator, this.rederivableMemory);
                if (this.rederivableMemory.isEmpty()) {
                    this.reteContainer.getTracker().removeRederivable(this);
                }
            }
            catch (NullPointerException ex) {
                this.issueError("[INTERNAL ERROR] Deleting a domain element in " + update + " which did not exist before in ColumnAggregatorNode " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), ex);
            }
        } else {
            if (oldMainAccumulator == null) {
                oldMainAccumulator = this.operator.createNeutral();
            }
            Object oldValue = this.operator.getAggregate(oldMainAccumulator);
            Object newMainAccumulator = this.operator.update(oldMainAccumulator, aggregableValue, isInsertion);
            Object newValue = this.operator.getAggregate(newMainAccumulator);
            if (monotone) {
                this.storeIfNotNeutral(group, newMainAccumulator, this.memory);
                this.propagate(group, oldValue, newValue);
            } else {
                boolean wasEmpty = this.rederivableMemory.isEmpty();
                if (this.storeIfNotNeutral(group, newMainAccumulator, this.rederivableMemory) && wasEmpty) {
                    this.reteContainer.getTracker().addRederivable(this);
                }
                this.memory.remove(group);
                this.propagate(group, oldValue, this.NEUTRAL);
            }
        }
    }

    public void propagate(Tuple group, AggregateResult oldValue, AggregateResult newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            Tuple oldResultTuple = this.tupleFromAggregateResult(group, oldValue);
            Tuple newResultTuple = this.tupleFromAggregateResult(group, newValue);
            if (this.aggregatorOuterIndexer != null) {
                this.aggregatorOuterIndexer.propagate(group, oldResultTuple, newResultTuple);
            }
            if (this.aggregatorOuterIdentityIndexers != null) {
                AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
                int n = this.aggregatorOuterIdentityIndexers.length;
                int n2 = 0;
                while (n2 < n) {
                    AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                    if (aggregatorOuterIdentityIndexer != null) {
                        aggregatorOuterIdentityIndexer.propagate(group, oldResultTuple, newResultTuple);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void clear() {
        this.memory.clear();
        this.rederivableMemory.clear();
    }

    protected boolean storeIfNotNeutral(Tuple key, Accumulator accumulator, Map<Tuple, Accumulator> memory) {
        if (this.operator.isNeutral(accumulator)) {
            memory.remove(key);
            return false;
        }
        memory.put(key, accumulator);
        return true;
    }

    public Tuple getAggregateTuple(Tuple key) {
        Accumulator accumulator = this.getMainAccumulator(key);
        Object aggregateResult = this.operator.getAggregate(accumulator);
        return this.tupleFromAggregateResult(key, aggregateResult);
    }

    public AggregateResult getAggregateResult(Tuple key) {
        Accumulator accumulator = this.getMainAccumulator(key);
        return (AggregateResult)this.operator.getAggregate(accumulator);
    }

    protected Accumulator getMainAccumulator(Tuple key) {
        return this.getAccumulator(key, this.memory);
    }

    protected Accumulator getRederivableAccumulator(Tuple key) {
        return this.getAccumulator(key, this.rederivableMemory);
    }

    protected Accumulator getAccumulator(Tuple key, Map<Tuple, Accumulator> memory) {
        Object accumulator = memory.get(key);
        if (accumulator == null) {
            accumulator = this.operator.createNeutral();
        }
        return accumulator;
    }

    protected Tuple tupleFromAggregateResult(Tuple groupTuple, AggregateResult aggregateResult) {
        if (aggregateResult == null) {
            return null;
        }
        Object[] resultArray = new Object[]{this.runtimeContext.wrapElement(aggregateResult)};
        return new LeftInheritanceTuple(groupTuple, resultArray);
    }

    class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        int resultPositionInSignature;
        TupleMask pruneResult;
        TupleMask reorderMask;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(ColumnAggregatorNode.this.reteContainer, TupleMask.displace((int)ColumnAggregatorNode.this.sourceWidth, (int)resultPositionInSignature, (int)(ColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = ColumnAggregatorNode.this;
            this.resultPositionInSignature = resultPositionInSignature;
            this.pruneResult = TupleMask.omit((int)resultPositionInSignature, (int)(ColumnAggregatorNode.this.sourceWidth + 1));
            this.reorderMask = resultPositionInSignature == ColumnAggregatorNode.this.sourceWidth ? null : this.mask;
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            Tuple prunedSignature = this.pruneResult.transform(signatureWithResult);
            Object result = ColumnAggregatorNode.this.getAggregateResult(prunedSignature);
            if (result != null && Objects.equals(signatureWithResult.get(this.resultPositionInSignature), result)) {
                return Collections.singleton(signatureWithResult);
            }
            return null;
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, this.reorder(oldTuple), signature, true);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, this.reorder(newTuple), signature, true);
            }
        }

        private Tuple reorder(Tuple signatureWithResult) {
            Tuple transformed = this.reorderMask == null ? signatureWithResult : this.reorderMask.transform(signatureWithResult);
            return transformed;
        }

        @Override
        public Node getActiveNode() {
            return ColumnAggregatorNode.this;
        }
    }

    class AggregatorOuterIndexer
    extends StandardIndexer {
        public AggregatorOuterIndexer() {
            super(ColumnAggregatorNode.this.reteContainer, TupleMask.omit((int)ColumnAggregatorNode.this.sourceWidth, (int)(ColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = ColumnAggregatorNode.this;
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            Tuple aggregateTuple = ColumnAggregatorNode.this.getAggregateTuple(signature);
            return aggregateTuple == null ? null : Collections.singleton(aggregateTuple);
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, oldTuple, signature, true);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, newTuple, signature, true);
            }
        }

        @Override
        public Node getActiveNode() {
            return ColumnAggregatorNode.this;
        }
    }
}

