/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.base64.Base64Utils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyManager {
    private static final String P_CATEGORIES = "org.eclipse.wb.core.model.property.PropertyManager";
    private static final Map<ToolkitDescription, Map<String, PropertyCategory>> m_toolkitCategories = Maps.newHashMap();

    public static PropertyCategory getCategory(Property property) {
        PropertyCategory category = PropertyManager.getCategoryForced(property);
        if (category != null) {
            return category;
        }
        return property.getCategory();
    }

    public static PropertyCategory getCategoryForced(Property property) {
        ToolkitDescription toolkit = PropertyManager.getToolkit(property);
        if (toolkit != null) {
            String title = property.getTitle();
            return PropertyManager.getCategories(toolkit).get(title);
        }
        return null;
    }

    public static void setCategory(Property property, PropertyCategory category) {
        ToolkitDescription toolkit = PropertyManager.getToolkit(property);
        if (toolkit != null) {
            String title = property.getTitle();
            Map<String, PropertyCategory> categories = PropertyManager.getCategories(toolkit);
            categories.put(title, category);
            PropertyManager.saveCategories(toolkit, categories);
        }
    }

    public static void setCategory(ToolkitDescription toolkit, String title, PropertyCategory category) {
        if (toolkit != null) {
            Map<String, PropertyCategory> categories = PropertyManager.getCategories(toolkit);
            categories.put(title, category);
            PropertyManager.saveCategories(toolkit, categories);
        }
    }

    private static ToolkitDescription getToolkit(Property property) {
        return GlobalState.getToolkit();
    }

    public static void flushCache() {
        m_toolkitCategories.clear();
    }

    private static Map<String, PropertyCategory> getCategories(ToolkitDescription toolkit) {
        Map<String, PropertyCategory> categories = m_toolkitCategories.get(toolkit);
        if (categories == null) {
            categories = PropertyManager.loadCategories(toolkit);
            m_toolkitCategories.put(toolkit, categories);
        }
        return categories;
    }

    private static Map<String, PropertyCategory> loadCategories(final ToolkitDescription toolkit) {
        return ExecutionUtils.runObjectIgnore(new RunnableObjectEx<Map<String, PropertyCategory>>(){

            @Override
            public Map<String, PropertyCategory> runObject() throws Exception {
                return PropertyManager.loadCategories0(toolkit);
            }
        }, Maps.newTreeMap());
    }

    private static void saveCategories(final ToolkitDescription toolkit, final Map<String, PropertyCategory> categories) {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                PropertyManager.saveCategories0(toolkit, categories);
            }
        });
    }

    private static Map<String, PropertyCategory> loadCategories0(ToolkitDescription toolkit) throws Exception {
        String encoded = toolkit.getPreferences().getString(P_CATEGORIES);
        byte[] bytes = Base64Utils.decodeToBytes(encoded);
        ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Map categoriesIndex = (Map)stream.readObject();
        return PropertyManager.toCategoriesObject(categoriesIndex);
    }

    private static void saveCategories0(ToolkitDescription toolkit, Map<String, PropertyCategory> categories) throws Exception {
        Map<String, Integer> categoriesIndex = PropertyManager.toCategoriesIndex(categories);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(baos);
        stream.writeObject(categoriesIndex);
        stream.close();
        byte[] bytes = baos.toByteArray();
        String encoded = Base64Utils.encode(bytes);
        toolkit.getPreferences().setValue(P_CATEGORIES, encoded);
    }

    private static Map<String, Integer> toCategoriesIndex(Map<String, PropertyCategory> source) {
        TreeMap target = Maps.newTreeMap();
        for (Map.Entry<String, PropertyCategory> entry : source.entrySet()) {
            target.put(entry.getKey(), PropertyManager.getCategoryIndex(entry.getValue()));
        }
        return target;
    }

    private static Map<String, PropertyCategory> toCategoriesObject(Map<String, Integer> source) {
        TreeMap target = Maps.newTreeMap();
        for (Map.Entry<String, Integer> entry : source.entrySet()) {
            target.put(entry.getKey(), PropertyManager.getCategoryByIndex(entry.getValue()));
        }
        return target;
    }

    private static int getCategoryIndex(PropertyCategory category) {
        if (category == PropertyCategory.PREFERRED) {
            return 0;
        }
        if (category == PropertyCategory.NORMAL) {
            return 1;
        }
        return 2;
    }

    private static PropertyCategory getCategoryByIndex(int index) {
        if (index == 0) {
            return PropertyCategory.PREFERRED;
        }
        if (index == 1) {
            return PropertyCategory.NORMAL;
        }
        return PropertyCategory.ADVANCED;
    }
}

