/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.ExceptionData;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RemoteValueMapping;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.v8native.CallFrameImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.JsEvaluateContextImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FrameObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;

public class ContextBuilder {
    private final DebugSession debugSession;
    private Object currentStep = null;

    ContextBuilder(DebugSession debugSession) {
        this.debugSession = debugSession;
    }

    public ExpectingBreakEventStep buildNewContext() {
        this.assertStep(null);
        final PreContext preContext = new PreContext();
        final DebugContextData contextData = new DebugContextData();
        return new ExpectingBreakEventStep(){
            {
                ContextBuilder.this.currentStep = this;
            }

            @Override
            public InternalContext getInternalContext() {
                return preContext;
            }

            @Override
            public ExpectingBacktraceStep setContextState(Collection<Breakpoint> breakpointsHit, ExceptionData exceptionData) {
                ContextBuilder.this.assertStep(this);
                DebugContext.State state = exceptionData == null ? DebugContext.State.NORMAL : DebugContext.State.EXCEPTION;
                contextData.contextState = state;
                contextData.breakpointsHit = Collections.unmodifiableCollection(breakpointsHit);
                contextData.exceptionData = exceptionData;
                return new ExpectingBacktraceStep(){
                    {
                        ContextBuilder.this.currentStep = this;
                    }

                    @Override
                    public InternalContext getInternalContext() {
                        return preContext;
                    }

                    @Override
                    public DebugContext setFrames(List<FrameObject> jsonFrames) {
                        ContextBuilder.this.assertStep(this);
                        contextData.frames = new Frames(jsonFrames, preContext);
                        preContext.createContext(contextData);
                        PreContext.UserContextImpl userContext = preContext.getContext();
                        ContextBuilder.this.currentStep = userContext;
                        return userContext;
                    }
                };
            }
        };
    }

    public ExpectingBreakEventStep buildNewContextWhenIdle() {
        if (this.currentStep == null) {
            return this.buildNewContext();
        }
        return null;
    }

    public void forceCancelContext() {
    }

    public void buildSequenceFailure() {
        throw new RuntimeException();
    }

    private void contextDismissed(DebugContext userContext) {
        this.assertStep(userContext);
        this.currentStep = null;
    }

    private void assertStep(Object step) {
        if (this.currentStep != step) {
            throw new IllegalStateException("Expected " + step + ", but was " + this.currentStep);
        }
    }

    private PreContext.UserContextImpl getCurrentUserContext() {
        if (!(this.currentStep instanceof PreContext.UserContextImpl)) {
            return null;
        }
        PreContext.UserContextImpl userContext = (PreContext.UserContextImpl)this.currentStep;
        return userContext;
    }

    PreContext.UserContextImpl getCurrentDebugContext() {
        return this.getCurrentUserContext();
    }

    ExpectingBacktraceStep startRebuildCurrentContext() {
        PreContext.UserContextImpl userContext = this.getCurrentUserContext();
        if (userContext == null) {
            return null;
        }
        if (!userContext.continueLocally()) {
            return null;
        }
        return this.buildNewContext().setContextState(userContext.getBreakpointsHitSafe(), userContext.getExceptionDataSafe());
    }

    public static InternalContext getInternalContextForTests(DebugContext debugContext) {
        PreContext.UserContextImpl userContext = (PreContext.UserContextImpl)debugContext;
        return userContext.getInternalContextForTests();
    }

    private static class DebugContextData {
        private Frames frames;
        private volatile Collection<Breakpoint> breakpointsHit;
        DebugContext.State contextState;
        private ExceptionData exceptionData;

        private DebugContextData() {
        }
    }

    public static interface ExpectingBacktraceStep {
        public InternalContext getInternalContext();

        public DebugContext setFrames(List<FrameObject> var1);
    }

    public static interface ExpectingBreakEventStep {
        public InternalContext getInternalContext();

        public ExpectingBacktraceStep setContextState(Collection<Breakpoint> var1, ExceptionData var2);
    }

    private class Frames {
        private final List<CallFrameImpl> unmodifableFrames;
        private boolean scriptsLinkedToFrames;

        Frames(List<FrameObject> jsonFrames, InternalContext internalContext) {
            CallFrameImpl[] callFrames = new CallFrameImpl[jsonFrames.size()];
            for (FrameObject frameObject : jsonFrames) {
                CallFrameImpl callFrameImpl;
                callFrames[callFrameImpl.getIdentifier()] = callFrameImpl = new CallFrameImpl(frameObject, internalContext);
            }
            this.scriptsLinkedToFrames = false;
            this.unmodifableFrames = Collections.unmodifiableList(Arrays.asList(callFrames));
        }

        synchronized List<CallFrameImpl> getCallFrames() {
            if (!this.scriptsLinkedToFrames) {
                for (CallFrameImpl frame : this.unmodifableFrames) {
                    frame.hookUpScript(ContextBuilder.this.debugSession.getScriptManager());
                }
                this.scriptsLinkedToFrames = true;
            }
            return this.unmodifableFrames;
        }
    }

    private class PreContext
    implements InternalContext {
        private final ValueLoaderImpl valueLoader = new ValueLoaderImpl(this);
        private final Object sendContextCommandsMonitor = new Object();
        private volatile boolean isValid = true;
        private UserContextImpl context = null;

        private PreContext() {
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public DebugSession getDebugSession() {
            return ContextBuilder.this.debugSession;
        }

        @Override
        public ContextBuilder getContextBuilder() {
            return ContextBuilder.this;
        }

        @Override
        public InternalContext.UserContext getUserContext() {
            return this.context;
        }

        void assertValid() {
            if (!this.isValid) {
                throw new IllegalStateException("This instance of DebugContext cannot be used anymore");
            }
        }

        void assertValidForUser() {
            if (!this.isValid) {
                ContextBuilder.this.debugSession.maybeRethrowContextException(null);
            }
        }

        public UserContextImpl getContext() {
            if (this.context == null) {
                throw new IllegalStateException();
            }
            return this.context;
        }

        @Override
        public CallFrameImpl getTopFrameImpl() {
            this.assertValid();
            return this.getContext().data.frames.getCallFrames().get(0);
        }

        @Override
        public ValueLoaderImpl getValueLoader() {
            return this.valueLoader;
        }

        void createContext(DebugContextData contextData) {
            if (this.context != null) {
                throw new IllegalStateException();
            }
            this.context = new UserContextImpl(contextData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RelayOk sendV8CommandAsync(DebuggerMessage message, boolean isImmediate, V8CommandProcessor.V8HandlerCallback commandCallback, SyncCallback syncCallback) throws InternalContext.ContextDismissedCheckedException {
            Object object = this.sendContextCommandsMonitor;
            synchronized (object) {
                if (!this.isValid) {
                    throw new InternalContext.ContextDismissedCheckedException();
                }
                return ContextBuilder.this.debugSession.getV8CommandProcessor().sendV8CommandAsync(message, isImmediate, commandCallback, syncCallback);
            }
        }

        @Override
        public void checkContextIsCompatible(InternalContext hostInternalContext) {
            if (this != hostInternalContext) {
                throw new IllegalArgumentException("Value is from the incompatible (probably obsolete) context");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RelayOk sendMessageAsyncAndInvalidate(DebuggerMessage message, V8CommandProcessor.V8HandlerCallback commandCallback, boolean isImmediate, SyncCallback syncCallback) {
            Object object = this.sendContextCommandsMonitor;
            synchronized (object) {
                this.assertValid();
                RelayOk relayOk = ContextBuilder.this.debugSession.getV8CommandProcessor().sendV8CommandAsync(message, isImmediate, commandCallback, syncCallback);
                this.isValid = false;
                return relayOk;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sendNoMessageAndInvalidate() {
            Object object = this.sendContextCommandsMonitor;
            synchronized (object) {
                block4: {
                    if (this.isValid) break block4;
                    return false;
                }
                this.isValid = false;
                return true;
            }
        }

        private class UserContextImpl
        implements InternalContext.UserContext {
            private final DebugContextData data;
            private final JsEvaluateContextImpl evaluateContext = new JsEvaluateContextImpl(){

                @Override
                protected Integer getFrameIdentifier() {
                    return null;
                }

                @Override
                public InternalContext getInternalContext() {
                    return PreContext.this;
                }
            };

            public UserContextImpl(DebugContextData contextData) {
                this.data = contextData;
            }

            @Override
            public DebugContext.State getState() {
                PreContext.this.assertValidForUser();
                return this.data.contextState;
            }

            @Override
            public List<? extends CallFrame> getCallFrames() {
                PreContext.this.assertValidForUser();
                return this.data.frames.getCallFrames();
            }

            public Collection<Breakpoint> getBreakpointsHit() {
                PreContext.this.assertValidForUser();
                if (this.data.breakpointsHit == null) {
                    throw new RuntimeException();
                }
                return this.data.breakpointsHit;
            }

            @Override
            public ExceptionData getExceptionData() {
                PreContext.this.assertValidForUser();
                return this.data.exceptionData;
            }

            Collection<Breakpoint> getBreakpointsHitSafe() {
                return this.data.breakpointsHit;
            }

            ExceptionData getExceptionDataSafe() {
                return this.data.exceptionData;
            }

            @Override
            public JsEvaluateContextImpl getGlobalEvaluateContext() {
                return this.evaluateContext;
            }

            @Override
            public void continueVm(DebugContext.StepAction stepAction, int stepCount, DebugContext.ContinueCallback callback) {
                this.continueVm(stepAction, stepCount, callback, null);
            }

            @Override
            public RelayOk continueVm(DebugContext.StepAction stepAction, int stepCount, final DebugContext.ContinueCallback callback, SyncCallback syncCallback) {
                if (stepAction == null) {
                    throw new NullPointerException();
                }
                DebuggerMessage message = DebuggerMessageFactory.goOn(stepAction, stepCount);
                V8CommandCallbackBase commandCallback = new V8CommandCallbackBase(){

                    @Override
                    public void success(SuccessCommandResponse successResponse) {
                        ContextBuilder.this.contextDismissed(UserContextImpl.this);
                        if (callback != null) {
                            callback.success();
                        }
                        PreContext.this.getDebugSession().getDebugEventListener().resumed();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                        Object object = PreContext.this.sendContextCommandsMonitor;
                        synchronized (object) {
                            PreContext.this.isValid = true;
                        }
                        if (callback != null) {
                            callback.failure(message);
                        }
                    }
                };
                return PreContext.this.sendMessageAsyncAndInvalidate(message, commandCallback, true, syncCallback);
            }

            @Override
            public JavascriptVm getJavascriptVm() {
                return ContextBuilder.this.debugSession.getJavascriptVm();
            }

            @Override
            public RemoteValueMapping getDefaultRemoteValueMapping() {
                return PreContext.this.valueLoader;
            }

            boolean continueLocally() {
                if (!PreContext.this.sendNoMessageAndInvalidate()) {
                    return false;
                }
                ContextBuilder.this.contextDismissed(this);
                PreContext.this.getDebugSession().getDebugEventListener().resumed();
                return true;
            }

            @Override
            public InternalContext getInternalContext() {
                return PreContext.this;
            }

            InternalContext getInternalContextForTests() {
                return PreContext.this;
            }

            @Override
            public ExpectingBacktraceStep createReloadBacktraceStep() {
                return new ExpectingBacktraceStep(){

                    @Override
                    public InternalContext getInternalContext() {
                        return PreContext.this;
                    }

                    @Override
                    public DebugContext setFrames(List<FrameObject> jsonFrames) {
                        UserContextImpl.this.data.frames = new Frames(jsonFrames, PreContext.this);
                        return UserContextImpl.this;
                    }
                };
            }
        }
    }
}

