/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectionLoggerImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConsolePseudoProcess;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IPredefinedSourceWrapProvider;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedderFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.core.model.NamedConnectionLoggerFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VProjectWorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.ui.listeners.JavaScriptChangeListener;
import org.eclipse.wst.jsdt.chromium.debug.ui.listeners.LaunchTerminateListener;
import org.eclipse.wst.jsdt.chromium.util.Destructable;
import org.eclipse.wst.jsdt.chromium.util.DestructingGuard;
import org.eclipse.wst.jsdt.js.node.NodePlugin;

public final class NodeDebugConnector {
    private static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private final ILaunchConfiguration configuration;
    private final ILaunch launch;
    private static final NamedConnectionLoggerFactory NO_CONNECTION_LOGGER_FACTORY = new NamedConnectionLoggerFactory(){

        public ConnectionLogger createLogger(String title) {
            return null;
        }
    };
    private static final Runnable OPENING_VIEW_ATTACH_CALLBACK = new Runnable(){

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window == null && workbench.getWorkbenchWindowCount() == 1) {
                        window = workbench.getWorkbenchWindows()[0];
                    }
                    if (window != null) {
                        try {
                            window.getActivePage().showView(NodeDebugConnector.PROJECT_EXPLORER_ID);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    };

    public NodeDebugConnector(ILaunchConfiguration configuration, ILaunch launch) {
        this.configuration = configuration;
        this.launch = launch;
    }

    boolean attach() throws CoreException {
        String host = this.configuration.getAttribute("attr_host_field", "localhost");
        int port = Integer.parseInt(this.configuration.getAttribute("attr_port_field", String.valueOf(5858)));
        NamedConnectionLoggerFactory consoleFactory = NO_CONNECTION_LOGGER_FACTORY;
        if (this.configuration.getAttribute("attr_add_network_console_field", false)) {
            consoleFactory = new NamedConnectionLoggerFactory(){

                public ConnectionLogger createLogger(String title) {
                    return NodeDebugConnector.createConsoleAndLogger(NodeDebugConnector.this.launch, true, title);
                }
            };
        }
        SourceWrapSupport sourceWrapSupport = NodeDebugConnector.createSourceWrapSupportFromConfig(this.configuration);
        JavascriptVmEmbedder.ConnectionToRemote remoteServer = JavascriptVmEmbedderFactory.connectToStandalone((String)host, (int)port, (NamedConnectionLoggerFactory)consoleFactory);
        remoteServer.selectVm();
        DestructingGuard destructingGuard = new DestructingGuard();
        Destructable lauchDestructor = new Destructable(){

            public void destruct() {
                if (!NodeDebugConnector.this.launch.hasChildren()) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(NodeDebugConnector.this.launch);
                }
            }
        };
        try {
            destructingGuard.addValue(lauchDestructor);
            VProjectWorkspaceBridge.FactoryImpl bridgeFactory = new VProjectWorkspaceBridge.FactoryImpl(this.configuration.getName());
            final DebugTargetImpl target = new DebugTargetImpl(this.launch, (WorkspaceBridge.Factory)bridgeFactory, sourceWrapSupport, BreakpointSynchronizer.Direction.MERGE);
            Destructable targetDestructor = new Destructable(){

                public void destruct() {
                    try {
                        target.terminate();
                    }
                    catch (DebugException e) {
                        NodePlugin.logError(e);
                    }
                }
            };
            destructingGuard.addValue(targetDestructor);
            boolean attached = DebugTargetImpl.attach((DebugTargetImpl)target, (JavascriptVmEmbedder.ConnectionToRemote)remoteServer, (DestructingGuard)destructingGuard, (Runnable)OPENING_VIEW_ATTACH_CALLBACK, (IProgressMonitor)new NullProgressMonitor());
            if (!attached) {
                return false;
            }
            this.launch.addDebugTarget((IDebugTarget)target);
            destructingGuard.discharge();
            this.addListeners(this.launch);
            return true;
        }
        finally {
            destructingGuard.doFinally();
        }
    }

    private void addListeners(ILaunch launch) {
        JavaScriptChangeListener listener = new JavaScriptChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new LaunchTerminateListener(launch, new IResourceChangeListener[]{listener}));
    }

    private static ConnectionLogger createConsoleAndLogger(final ILaunch launch, final boolean addLaunchToManager, final String title) {
        final ConsolePseudoProcess.Retransmitter consoleRetransmitter = new ConsolePseudoProcess.Retransmitter();
        ConnectionLoggerImpl.LogLifecycleListener consoleController = new ConnectionLoggerImpl.LogLifecycleListener(){
            private final AtomicBoolean alreadyStarted = new AtomicBoolean(false);

            public void logClosed() {
                consoleRetransmitter.processClosed();
            }

            public void logStarted(ConnectionLoggerImpl connectionLogger) {
                boolean res = this.alreadyStarted.compareAndSet(false, true);
                if (!res) {
                    throw new IllegalStateException();
                }
                new ConsolePseudoProcess(launch, title, consoleRetransmitter, connectionLogger.getConnectionTerminate());
                consoleRetransmitter.startFlushing();
                if (addLaunchToManager) {
                    DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
                }
            }
        };
        return new ConnectionLoggerImpl((Writer)consoleRetransmitter, consoleController);
    }

    private static SourceWrapSupport createSourceWrapSupportFromConfig(ILaunchConfiguration config) throws CoreException {
        List entries = LaunchParams.PredefinedSourceWrapperIds.resolveEntries((ILaunchConfiguration)config);
        ArrayList<SourceWrapSupport.Wrapper> wrappers = new ArrayList<SourceWrapSupport.Wrapper>(entries.size());
        for (IPredefinedSourceWrapProvider.Entry en : entries) {
            wrappers.add(en.getWrapper());
        }
        return new SourceWrapSupport(wrappers);
    }
}

