/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
            this.agent = this.session.getFactoryManager().getAgentFactory().createClient(this.session);
            this.client = new AgentClient();
            f.setOpened();
        }
        catch (Exception e) {
            f.setException(e);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
    }

    public CloseFuture close(boolean immediately) {
        return (CloseFuture)super.close(immediately).addListener(new SshFutureListener(){

            public void operationComplete(SshFuture sshFuture) {
                ChannelAgentForwarding.this.closeImmediately0();
            }
        });
    }

    public void handleEof() throws IOException {
        super.handleEof();
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.client.messageReceived(new Buffer(data, off, len));
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    public void handleRequest(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_REQUEST on channel {}", (Object)this.id);
        String type = buffer.getString();
        this.log.info("Received channel request: {}", (Object)type);
        buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
        buffer.putInt(this.recipient);
        this.session.writePacket(buffer);
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "auth-agent@openssh.com";
        }

        @Override
        public Channel create() {
            return new ChannelAgentForwarding();
        }
    }
}

