/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JarsSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String JAR_EXT = ".jar";
    private static final String ZIP_EXT = ".zip";
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private File topDir;
    private Button importButton;

    public JarsSelectionDialog(Shell parent, File topDir) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider());
        assert (topDir != null);
        this.setValidator(new SelectionValidator());
        this.setInput(topDir.getAbsolutePath());
        this.setTitle(Messages.getString("DataSet.JarsSelectDlg.Title"));
        this.topDir = topDir;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.createImportFileArea((Composite)c);
        this.getTreeViewer().expandToLevel(2);
        return c;
    }

    private void createImportFileArea(Composite parent) {
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages.getString("JarsSelectionDialog.button.importFile"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JarsSelectionDialog.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    File srcFile;
                    File targetFolder = JarsSelectionDialog.this.getSelectedFolder();
                    File targetFile = new File(targetFolder, (srcFile = new File(selectedLocation)).getName());
                    if (targetFile.exists() && !MessageDialog.openConfirm((Shell)JarsSelectionDialog.this.getShell(), (String)Messages.getString("JarsSelectionDialog.title.overwrite"), (String)Messages.getString("JarsSelectionDialog.overwrite.msg"))) {
                        return;
                    }
                    JarsSelectionDialog.this.importFile(targetFile, srcFile);
                    IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                    if (synchronizer != null) {
                        synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new ReportResourceChangeEvent((Object)this, (Object)Path.fromOSString((String)targetFile.getAbsolutePath()), 1));
                    }
                    JarsSelectionDialog.this.getTreeViewer().refresh((Object)targetFolder);
                    JarsSelectionDialog.this.getTreeViewer().expandToLevel((Object)targetFolder, 1);
                }
            }
        });
    }

    private File getSelectedFolder() {
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0 && selection[0] instanceof File) {
            File f = (File)selection[0];
            if (f.isFile()) {
                return f.getParentFile();
            }
            return f;
        }
        return null;
    }

    private void importFile(final File target, final File src) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("JarsSelectionDialog.import.msg"), 1);
                    try {
                        try {
                            JarsSelectionDialog.this.doImport(target, src);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JarsSelectionDialog.title.error"), (String)e.getLocalizedMessage());
        }
    }

    private void doImport(File target, File src) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(target);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fcin != null) {
                fcin.close();
            }
            if (fcout != null) {
                fcout.close();
            }
        }
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        this.importButton.setEnabled(this.getSelectedFolder() != null);
    }

    private static File[] getChildren(File f) {
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] result = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                if (child.isDirectory()) {
                    return true;
                }
                String name = child.getName().toLowerCase();
                return name.endsWith(JarsSelectionDialog.JAR_EXT) || name.endsWith(JarsSelectionDialog.ZIP_EXT);
            }
        });
        if (result != null) {
            Arrays.sort(result, new Utils.FileComparator());
        }
        return result == null ? new File[]{} : result;
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            if (f.isFile()) {
                URI relative = this.topDir.toURI().relativize(f.toURI());
                result.add(relative.getPath());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return JarsSelectionDialog.getChildren(f);
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return JarsSelectionDialog.getChildren(f).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{new File((String)arg0)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.isFile()) {
                    return IMG_FILE;
                }
                return IMG_FOLDER;
            }
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().equals("")) {
                    return f.getPath();
                }
                return f.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof File && ((File)o).isFile()) {
                        return new Status(0, "org.eclipse.birt.data.oda.pojo.ui", 0, "", null);
                    }
                    ++n2;
                }
            }
            return new Status(4, "org.eclipse.birt.data.oda.pojo.ui", 4, "", null);
        }
    }
}

