/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Objects;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.io.File;
import java.util.Collections;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.GradleArguments;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.configuration.internal.DefaultBuildConfigurationProperties;

class DefaultBuildConfiguration
implements BuildConfiguration {
    private final DefaultBuildConfigurationProperties properties;
    private final WorkspaceConfiguration workspaceConfiguration;

    public DefaultBuildConfiguration(DefaultBuildConfigurationProperties persistentProperties, WorkspaceConfiguration workspaceConfiguration) {
        this.properties = persistentProperties;
        this.workspaceConfiguration = workspaceConfiguration;
    }

    @Override
    public WorkspaceConfiguration getWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    @Override
    public File getRootProjectDirectory() {
        return this.properties.getRootProjectDirectory();
    }

    @Override
    public boolean isOverrideWorkspaceSettings() {
        return this.properties.isOverrideWorkspaceSettings();
    }

    @Override
    public File getGradleUserHome() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.getGradleUserHome();
        }
        return this.workspaceConfiguration.getGradleUserHome();
    }

    @Override
    public GradleDistribution getGradleDistribution() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.getGradleDistribution();
        }
        return this.workspaceConfiguration.getGradleDistribution();
    }

    @Override
    public boolean isBuildScansEnabled() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.isBuildScansEnabled();
        }
        return this.workspaceConfiguration.isBuildScansEnabled();
    }

    @Override
    public boolean isOfflineMode() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.isOfflineMode();
        }
        return this.workspaceConfiguration.isOffline();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultBuildConfiguration) {
            DefaultBuildConfiguration other = (DefaultBuildConfiguration)obj;
            return Objects.equal((Object)this.properties, (Object)other.properties) && Objects.equal((Object)this.workspaceConfiguration, (Object)other.workspaceConfiguration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.properties, this.workspaceConfiguration});
    }

    public DefaultBuildConfigurationProperties getProperties() {
        return this.properties;
    }

    @Override
    public GradleArguments toGradleArguments() {
        return GradleArguments.from(this.getRootProjectDirectory(), this.getGradleDistribution(), this.getGradleUserHome(), null, this.isBuildScansEnabled(), this.isOfflineMode(), Collections.emptyList(), Collections.emptyList());
    }
}

