/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnaryTypeTransformation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class TypeTraits {
    private static final ICPPBasicType[] SIGNED_UNDERLYING_ENUM_TYPES = new ICPPBasicType[]{CPPBasicType.INT, CPPBasicType.LONG, CPPBasicType.LONG_LONG, CPPBasicType.INT128};
    private static final ICPPBasicType[] UNSIGNED_UNDERLYING_ENUM_TYPES = new ICPPBasicType[]{CPPBasicType.UNSIGNED_INT, CPPBasicType.UNSIGNED_LONG, CPPBasicType.UNSIGNED_LONG_LONG, CPPBasicType.UNSIGNED_INT128};

    private TypeTraits() {
    }

    public static boolean isDefaultedMethod(ICPPMethod method) {
        ICPPInternalFunction internalFunc;
        IASTNode definition;
        ICPPASTFunctionDefinition functionDefinition;
        if (method instanceof ICPPInternalFunction && (functionDefinition = CPPFunction.getFunctionDefinition(definition = (internalFunc = (ICPPInternalFunction)((Object)method)).getDefinition())) != null) {
            return functionDefinition.isDefaulted();
        }
        return false;
    }

    public static boolean isLiteralClass(ICPPClassType classType) {
        ICPPConstructor[] ctors;
        if (!TypeTraits.hasTrivialDestructor(classType)) {
            return false;
        }
        if (TypeTraits.isAggregateClass(classType)) {
            return true;
        }
        ICPPConstructor[] iCPPConstructorArray = ctors = classType.getConstructors();
        int n = ctors.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            ClassTypeHelper.MethodKind methodKind = ClassTypeHelper.getMethodKind(classType, ctor);
            if (methodKind != ClassTypeHelper.MethodKind.COPY_CTOR && methodKind != ClassTypeHelper.MethodKind.MOVE_CTOR && (ctor instanceof CPPImplicitConstructor || ctor.isConstexpr())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTrivial(ICPPClassType classType) {
        return TypeTraits.isTrivialImpl(classType, true);
    }

    private static boolean isTrivialImpl(ICPPClassType classType, boolean checkDefaultConstructors) {
        ICPPClassType[] baseClasses;
        ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isVirtual()) {
                return false;
            }
            switch (ClassTypeHelper.getMethodKind(classType, method)) {
                case DEFAULT_CTOR: {
                    if (!checkDefaultConstructors) break;
                    return false;
                }
                case COPY_CTOR: 
                case MOVE_CTOR: 
                case COPY_ASSIGNMENT_OP: 
                case MOVE_ASSIGNMENT_OP: 
                case DTOR: {
                    return false;
                }
            }
            ++n2;
        }
        ICPPField[] fields = classType.getDeclaredFields();
        Object[] objectArray = fields;
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            IType fieldType;
            ICPPField field = objectArray[n];
            if (!field.isStatic() && (fieldType = SemanticUtil.getNestedType(field.getType(), 1)) instanceof ICPPClassType && !TypeTraits.isTrivial((ICPPClassType)fieldType)) {
                return false;
            }
            ++n;
        }
        objectArray = classType.getBases();
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object base = objectArray[n];
            if (base.isVirtual()) {
                return false;
            }
            ++n;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(classType);
        int n4 = baseClasses.length;
        n3 = 0;
        while (n3 < n4) {
            ICPPClassType baseClass = iCPPClassTypeArray[n3];
            if (!TypeTraits.isTrivial(baseClass)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isStandardLayout(IType type) {
        ICPPClassType[] baseClasses;
        if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPReferenceType) {
            return false;
        }
        if (!(type instanceof ICPPClassType)) {
            return true;
        }
        ICPPClassType classType = (ICPPClassType)type;
        int visibility = 0;
        ICPPField firstNonStaticField = null;
        ICPPField[] fields = classType.getDeclaredFields();
        Object[] objectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPField field = objectArray[n2];
            if (!field.isStatic()) {
                if (!TypeTraits.isStandardLayout(field.getType())) {
                    return false;
                }
                int vis = field.getVisibility();
                if (visibility == 0) {
                    visibility = vis;
                } else if (vis != visibility) {
                    return false;
                }
                if (firstNonStaticField == null) {
                    firstNonStaticField = field;
                }
            }
            ++n2;
        }
        if (TypeTraits.hasDeclaredVirtualMethod(classType)) {
            return false;
        }
        objectArray = classType.getBases();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object base = objectArray[n2];
            if (base.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(classType);
        int n3 = baseClasses.length;
        n = 0;
        while (n < n3) {
            ICPPClassType baseClass = iCPPClassTypeArray[n];
            if (!TypeTraits.isStandardLayout(baseClass)) {
                return false;
            }
            if (firstNonStaticField != null) {
                if (TypeTraits.hasNonStaticFields(baseClass)) {
                    return false;
                }
                if (firstNonStaticField.getType().isSameType(baseClass)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean isPOD(IType type) {
        if (!TypeTraits.isStandardLayout(type)) {
            return false;
        }
        if (!((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType)) {
            return true;
        }
        return TypeTraits.isTrivial((ICPPClassType)type);
    }

    public static boolean isEmpty(IType type) {
        ICPPClassType[] baseClasses;
        if (!((type = SemanticUtil.getNestedType(type, 9)) instanceof ICPPClassType)) {
            return false;
        }
        ICPPClassType classType = (ICPPClassType)type;
        if (!TypeTraits.isItselfEmpty(classType)) {
            return false;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(classType);
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass = iCPPClassTypeArray[n2];
            if (!TypeTraits.isItselfEmpty(baseClass)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isItselfEmpty(ICPPClassType classType) {
        ICPPBase[] bases;
        ICPPMethod[] methods;
        ICPPField[] fields;
        ICPPField[] iCPPFieldArray = fields = classType.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPField field = iCPPFieldArray[n2];
            if (!field.isStatic()) {
                return false;
            }
            ++n2;
        }
        ICPPMethod[] iCPPMethodArray = methods = classType.getDeclaredMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            ICPPMethod method = iCPPMethodArray[n];
            if (method.isVirtual()) {
                return false;
            }
            ++n;
        }
        ICPPBase[] iCPPBaseArray = bases = classType.getBases();
        int n4 = bases.length;
        n3 = 0;
        while (n3 < n4) {
            ICPPBase base = iCPPBaseArray[n3];
            if (base.isVirtual()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isAggregateClass(ICPPClassType classType) {
        ICPPField[] fields;
        ICPPMethod[] methods;
        if (classType.getBases().length > 0) {
            return false;
        }
        ICPPMethod[] iCPPMethodArray = methods = classType.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod m = iCPPMethodArray[n2];
            if (m instanceof ICPPConstructor) {
                return false;
            }
            if (m.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPField[] iCPPFieldArray = fields = classType.getDeclaredFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            ICPPField field = iCPPFieldArray[n];
            if (field.getVisibility() != 1 && !field.isStatic()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean hasTrivialCopyCtor(ICPPClassType classType) {
        if (TypeTraits.getImplicitCopyCtor(classType) == null) {
            return false;
        }
        if (TypeTraits.isPolymorphic(classType)) {
            return false;
        }
        Object[] objectArray = classType.getBases();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = objectArray[n2];
            if (base.isVirtual()) {
                return false;
            }
            ++n2;
        }
        objectArray = ClassTypeHelper.getAllBases(classType);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Cloneable baseClass = objectArray[n2];
            if (!classType.isSameType((IType)baseClass) && !TypeTraits.hasTrivialCopyCtor((ICPPClassType)baseClass)) {
                return false;
            }
            ++n2;
        }
        objectArray = classType.getDeclaredFields();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !classType.isSameType(type) && !TypeTraits.hasTrivialCopyCtor((ICPPClassType)type)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean hasTrivialDefaultConstructor(ICPPClassType classType, int maxdepth) {
        if (maxdepth <= 0) {
            return false;
        }
        ICPPBinding[] iCPPBindingArray = classType.getConstructors();
        int n = iCPPBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPBindingArray[n2];
            if (!ctor.isImplicit() && ctor.getParameters().length == 0) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getAllBases(classType);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding baseClass = iCPPBindingArray[n2];
            if (!classType.isSameType((IType)((Object)baseClass)) && !TypeTraits.hasTrivialDefaultConstructor((ICPPClassType)baseClass, maxdepth - 1)) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = classType.getDeclaredFields();
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding field = iCPPBindingArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !classType.isSameType(type) && !TypeTraits.hasTrivialDefaultConstructor((ICPPClassType)type, maxdepth - 1)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean hasTrivialDestructor(ICPPClassType classType) {
        return TypeTraits.hasTrivialDestructor(classType, new HashSet<ICPPClassType>());
    }

    private static boolean hasTrivialDestructor(ICPPClassType classType, Set<ICPPClassType> checkedClasses) {
        if (!checkedClasses.add(classType)) {
            return true;
        }
        ICPPBinding[] iCPPBindingArray = classType.getDeclaredMethods();
        int n = iCPPBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPBindingArray[n2];
            if (method.isDestructor() && !TypeTraits.isDefaultedMethod(method)) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getAllBases(classType);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding baseClass = iCPPBindingArray[n2];
            if (!TypeTraits.hasTrivialDestructor((ICPPClassType)baseClass, checkedClasses)) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = classType.getDeclaredFields();
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding field = iCPPBindingArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !TypeTraits.hasTrivialDestructor((ICPPClassType)type, checkedClasses)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isPolymorphic(ICPPClassType classType) {
        if (TypeTraits.hasDeclaredVirtualMethod(classType)) {
            return true;
        }
        ICPPClassType[] iCPPClassTypeArray = ClassTypeHelper.getAllBases(classType);
        int n = iCPPClassTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass = iCPPClassTypeArray[n2];
            if (TypeTraits.hasDeclaredVirtualMethod(baseClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasNonStaticFields(ICPPClassType classType) {
        ICPPField[] fields;
        ICPPField[] iCPPFieldArray = fields = classType.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPField field = iCPPFieldArray[n2];
            if (!field.isStatic()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAbstract(ICPPClassType classType) {
        return SemanticQueries.getPureVirtualMethods(classType).length != 0;
    }

    private static ICPPConstructor getImplicitCopyCtor(ICPPClassType classType) {
        ICPPConstructor[] iCPPConstructorArray = classType.getConstructors();
        int n = iCPPConstructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.isImplicit() && ClassTypeHelper.getMethodKind(classType, ctor) == ClassTypeHelper.MethodKind.COPY_CTOR) {
                return ctor;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasDeclaredVirtualMethod(ICPPClassType classType) {
        ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isVirtual()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IType underlyingType(IType type) {
        if (CPPTemplates.isDependentType(type)) {
            return new CPPUnaryTypeTransformation(ICPPUnaryTypeTransformation.Operator.underlying_type, type);
        }
        if (!(type instanceof ICPPEnumeration)) {
            return ProblemType.ENUMERATION_EXPECTED;
        }
        ICPPEnumeration enumeration = (ICPPEnumeration)type;
        IType fixedType = enumeration.getFixedType();
        if (fixedType != null) {
            return fixedType;
        }
        if (enumeration.getEnumerators().length == 0) {
            return CPPBasicType.INT;
        }
        long minValue = enumeration.getMinValue();
        long maxValue = enumeration.getMaxValue();
        if (minValue < 0L || maxValue < 0L) {
            return TypeTraits.smallestFittingType(minValue, maxValue, SIGNED_UNDERLYING_ENUM_TYPES);
        }
        return TypeTraits.smallestFittingType(minValue, maxValue, UNSIGNED_UNDERLYING_ENUM_TYPES);
    }

    private static IBasicType smallestFittingType(long minValue, long maxValue, ICPPBasicType[] types) {
        ICPPBasicType[] iCPPBasicTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBasicType type = iCPPBasicTypeArray[n2];
            if (ArithmeticConversion.fitsIntoType((IBasicType)type, minValue) && ArithmeticConversion.fitsIntoType((IBasicType)type, maxValue)) {
                return type;
            }
            ++n2;
        }
        return types[types.length - 1];
    }

    private static boolean isScalar(IType type) {
        return (type = SemanticUtil.getNestedType(type, 16)) instanceof IBasicType || type instanceof IEnumeration || type instanceof IPointerType;
    }

    private static boolean isTriviallyCopyableClass(ICPPClassType type) {
        return TypeTraits.isTrivialImpl(type, false);
    }

    public static boolean isTriviallyCopyable(IType type) {
        CVQualifier qualifier = SemanticUtil.getCVQualifier(type = SemanticUtil.getSimplifiedType(type));
        if (qualifier.isVolatile()) {
            return false;
        }
        if (qualifier.isConst()) {
            return TypeTraits.isTriviallyCopyable(SemanticUtil.getNestedType(type, 16));
        }
        if (type instanceof IArrayType) {
            return TypeTraits.isTriviallyCopyable(((IArrayType)type).getType());
        }
        if (type instanceof ICPPClassType) {
            return TypeTraits.isTriviallyCopyableClass((ICPPClassType)type);
        }
        return TypeTraits.isScalar(type);
    }
}

