/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.ScriptModelHelper;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class ScriptLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private final String fMode;
    private Button breakOnFirstLine;
    private Button enableLogging;
    private Button fProjButton;
    private Text fProjText;
    private WidgetListener fListener = new WidgetListener();
    private boolean initializing = false;
    protected static final String FIELD_PROJECT = "project";

    public ScriptLaunchConfigurationTab(String mode) {
        this.fMode = mode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.doCreateControl(comp);
        this.createVerticalSpacer(comp, 1);
        this.createDebugOptionsGroup(comp);
        this.createCustomSections(comp);
        Dialog.applyDialogFont((Control)comp);
    }

    protected void createCustomSections(Composite comp) {
    }

    protected void createDebugOptionsGroup(Composite parent) {
        if ("debug".equals(this.fMode)) {
            String text = DLTKLaunchConfigurationsMessages.ScriptLaunchConfigurationTab_debugOptions;
            Group group = new Group(parent, 0);
            group.setText(text);
            GridData gd = new GridData(768);
            if (parent.getLayout() instanceof GridLayout) {
                gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
            }
            group.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            this.createDebugOptions((Composite)group);
        }
    }

    protected void createDebugOptions(Composite group) {
        this.addBreakOnFirstLineButton(group);
        this.addDbgpLoggingButton(group);
    }

    public final void initializeFrom(ILaunchConfiguration config) {
        this.initializing = true;
        try {
            this.updateProjectFromConfig(config);
            this.doInitializeForm(config);
        }
        finally {
            this.initializing = false;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.validatePage(false);
        return !this.isError();
    }

    protected final void validatePage() {
        this.validatePage(true);
    }

    private final void validatePage(boolean manual) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.validate();
    }

    protected boolean validate() {
        return this.validateProject();
    }

    protected boolean isError() {
        return this.getErrorMessage() != null;
    }

    public final void performApply(ILaunchConfigurationWorkingCopy config) {
        String project = this.fProjText.getText().trim();
        config.setAttribute(FIELD_PROJECT, project);
        if ("debug".equals(this.fMode)) {
            if (this.breakOnFirstLine != null) {
                config.setAttribute("enableBreakOnFirstLine", this.breakOnFirstLine.getSelection());
            }
            if (this.enableLogging != null) {
                config.setAttribute("enableDbgpLogging", this.enableLogging.getSelection());
            }
        }
        this.doPerformApply(config);
        try {
            this.mapResources(config);
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.logWarning((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            DLTKLaunchingPlugin.logWarning((Throwable)e);
        }
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) throws CoreException {
        IResource resource = this.getResource((ILaunchConfiguration)config);
        if (resource == null) {
            config.setMappedResources(null);
        } else {
            config.setMappedResources(new IResource[]{resource});
        }
    }

    protected IResource getResource(ILaunchConfiguration config) throws CoreException {
        IScriptProject project;
        String projName = config.getAttribute(FIELD_PROJECT, null);
        if (projName != null && Path.ROOT.isValidSegment(projName) && (project = this.getScriptModel().getScriptProject(projName)).exists()) {
            return project.getProject();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IModelElement element = this.getContextModelElement();
        this.setDefaults(configuration, element);
    }

    protected IModelElement ensureValid(IModelElement element) {
        if (element == null || !this.validateProject(element.getScriptProject())) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int cnt = 0;
            int max = projects.length;
            while (cnt < max) {
                IScriptProject scriptProject = DLTKCore.create((IProject)projects[cnt]);
                if (this.validateProject(scriptProject)) {
                    return scriptProject;
                }
                ++cnt;
            }
        }
        return element;
    }

    protected void setDefaults(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        if ((element = this.ensureValid(element)) != null) {
            configuration.setAttribute(FIELD_PROJECT, element.getScriptProject().getElementName());
        }
    }

    protected boolean breakOnFirstLinePrefEnabled(PreferencesLookupDelegate delegate) {
        return false;
    }

    protected boolean dbpgLoggingPrefEnabled(PreferencesLookupDelegate delegate) {
        return false;
    }

    @Deprecated
    protected final boolean doCanSave() {
        return false;
    }

    protected abstract void doCreateControl(Composite var1);

    protected abstract void doInitializeForm(ILaunchConfiguration var1);

    protected abstract void doPerformApply(ILaunchConfigurationWorkingCopy var1);

    protected abstract String getNatureID();

    @Deprecated
    protected final boolean isValidToolkit(IDLTKLanguageToolkit toolkit) {
        return false;
    }

    private void addBreakOnFirstLineButton(Composite group) {
        this.breakOnFirstLine = this.createCheckButton(group, ScriptDebugPreferencesMessages.BreakOnFirstLineLabel);
        this.breakOnFirstLine.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    private void addDbgpLoggingButton(Composite group) {
        this.enableLogging = this.createCheckButton(group, ScriptDebugPreferencesMessages.EnableDbgpLoggingLabel);
        this.enableLogging.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    protected IScriptProject chooseProject() {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)this.getNatureID());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_message);
        try {
            Object[] projects = ScriptModelHelper.getOpenedScriptProjects((IScriptModel)DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()), (String)this.getNatureID());
            dialog.setElements(projects);
        }
        catch (ModelException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        IScriptProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    protected boolean needGroupForField(String fieldName) {
        return true;
    }

    protected Label createLabelForField(Composite parent, String fieldName, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected void setEnableProjectField(boolean enabled) {
        this.fProjText.setEnabled(enabled);
        this.fProjButton.setEnabled(enabled);
    }

    protected void createProjectEditor(Composite parent) {
        Composite editParent;
        if (this.needGroupForField(FIELD_PROJECT)) {
            Group group = new Group(parent, 0);
            group.setText(DLTKLaunchConfigurationsMessages.mainTab_projectGroup);
            GridData gd = new GridData(768);
            group.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            editParent = group;
        } else {
            this.createLabelForField(parent, FIELD_PROJECT, DLTKLaunchConfigurationsMessages.mainTab_projectGroup);
            editParent = parent;
        }
        this.fProjText = new Text(editParent, 2052);
        GridData gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton(editParent, DLTKLaunchConfigurationsMessages.mainTab_projectButton, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
    }

    protected String getLanguageName() {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getNatureID());
        if (toolkit != null) {
            return toolkit.getLanguageName();
        }
        return null;
    }

    protected IScriptProject getProject() {
        if (this.fProjText == null) {
            return null;
        }
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getScriptModel().getScriptProject(projectName);
    }

    @Deprecated
    protected final String[] getProjectAndScriptNames() {
        return null;
    }

    protected IModelElement getContextModelElement() {
        IEditorPart editor;
        IScriptProject project;
        ISourceModule me;
        IStructuredSelection ss;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IModelElement) {
                return (IModelElement)obj;
            }
            if (obj instanceof IResource) {
                me = DLTKCore.create((IResource)((IResource)obj));
                if (me == null) {
                    project = ((IResource)obj).getProject();
                    me = DLTKCore.create((IProject)project);
                }
                if (me != null) {
                    return me;
                }
            }
        }
        if ((editor = page.getActiveEditor()) == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        me = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editorInput);
        if (me != null && (project = me.getScriptProject()) != null && this.validateProject(project)) {
            IResource resource = me.getResource();
            if (resource != null) {
                return me;
            }
            return project;
        }
        return null;
    }

    protected final String getProjectName() {
        return this.fProjText.getText().trim();
    }

    protected IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected WidgetListener getWidgetListener() {
        return this.fListener;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Deprecated
    protected final String guessProjectName() {
        return EMPTY_STRING;
    }

    protected void handleProjectButtonSelected() {
        IScriptProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        if (!this.validateProject(project)) {
            String msg = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_notALangProject, (Object[])new String[]{this.getLanguageName()});
            String reason = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_reasonNotALangProject, (Object[])new String[]{this.getLanguageName()});
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_invalidProject, (String)msg, (IStatus)DLTKUIStatus.createError((int)4, (String)reason, null));
            return;
        }
        String projectName = project.getElementName();
        this.setProjectName(projectName);
    }

    protected final void setProjectName(String name) {
        this.setProjectName(name, new PreferencesLookupDelegate(this.getScriptModel().getScriptProject(name)));
    }

    private void setProjectName(String name, PreferencesLookupDelegate delegate) {
        this.fProjText.setText(name);
        if (delegate != null && "debug".equals(this.fMode)) {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(this.breakOnFirstLinePrefEnabled(delegate));
            }
            if (this.enableLogging != null) {
                this.enableLogging.setSelection(this.dbpgLoggingPrefEnabled(delegate));
            }
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = LaunchConfigurationUtils.getProjectName((ILaunchConfiguration)config);
        if (projectName != null) {
            IProject project;
            this.setProjectName(projectName, null);
            if ("debug".equals(this.fMode) && Path.EMPTY.isValidSegment(projectName) && (project = this.getWorkspaceRoot().getProject(projectName)).isAccessible()) {
                PreferencesLookupDelegate delegate = new PreferencesLookupDelegate(project);
                if (this.breakOnFirstLine != null) {
                    this.breakOnFirstLine.setSelection(LaunchConfigurationUtils.isBreakOnFirstLineEnabled((ILaunchConfiguration)config, (boolean)this.breakOnFirstLinePrefEnabled(delegate)));
                }
                if (this.enableLogging != null) {
                    this.enableLogging.setSelection(LaunchConfigurationUtils.isDbgpLoggingEnabled((ILaunchConfiguration)config, (boolean)this.dbpgLoggingPrefEnabled(delegate)));
                }
            }
        }
    }

    protected boolean validateProject() {
        String projectName = this.getProjectName();
        if (projectName.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectProject);
            return false;
        }
        IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
        if (proj == null || !this.validateProject(proj)) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
            return false;
        }
        return true;
    }

    protected boolean isValidProject() {
        String projectName = this.getProjectName();
        if (projectName.length() == 0) {
            return false;
        }
        IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
        return proj != null && this.validateProject(proj);
    }

    protected boolean validateProject(IScriptProject project) {
        block3: {
            if (project != null) {
                try {
                    return project.getProject().hasNature(this.getNatureID());
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    protected void projectChanged() {
    }

    class WidgetListener
    implements ModifyListener,
    SelectionListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ScriptLaunchConfigurationTab.this.initializing) {
                return;
            }
            if (e.getSource() == ScriptLaunchConfigurationTab.this.fProjText) {
                ScriptLaunchConfigurationTab.this.projectChanged();
            }
            ScriptLaunchConfigurationTab.this.validatePage();
            ScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

