/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table;

import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.model.ReviewersTableModel;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UIReviewersTable {
    public static final String REVIEWERS_TABLE = "reviewersTable";
    private static final int TABLE_STYLE = 66304;
    private TableViewer fViewer;

    public TableViewer createTableViewerSection(Composite aParent, String[] dynamicReviewersColumn) {
        this.fViewer = new TableViewer(aParent, 66304);
        this.fViewer = this.buildAndLayoutTable(this.fViewer, dynamicReviewersColumn);
        ReviewTableSorter.bind(this.fViewer);
        return this.fViewer;
    }

    private TableViewer buildAndLayoutTable(TableViewer aViewer, String[] dynamicReviewersColumn) {
        Table table = aViewer.getTable();
        ReviewersTableModel[] tableInfo = ReviewersTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        if (dynamicReviewersColumn != null) {
            String[] stringArray = dynamicReviewersColumn;
            int n = dynamicReviewersColumn.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.createTableViewerLabelColumn(element);
                ++n2;
            }
        }
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)REVIEWERS_TABLE);
        return aViewer;
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    private TableViewerColumn createTableViewerLabelColumn(String fullName) {
        String label = UIUtils.getAcronymLabel(fullName);
        int width = 28 + 5 * label.length();
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(label);
        column.setWidth(width);
        column.setAlignment(16384);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }
}

