/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class GerritToGitMapping {
    private final String gerritProject;
    private final URIish daemonURL;
    private Repository match;
    private String addressOfSearchedRepo;
    private boolean inPushRepos = false;

    public GerritToGitMapping(URIish daemonURL, String gerritProject) {
        if (gerritProject == null) {
            throw new IllegalArgumentException("gerritProject can't be null");
        }
        if (daemonURL == null) {
            throw new IllegalArgumentException("daemonURL can't be null");
        }
        this.daemonURL = daemonURL;
        this.gerritProject = gerritProject;
    }

    public Repository find() throws IOException {
        this.addressOfSearchedRepo = this.buildSearchedAddress(true);
        this.findMatchingRepository();
        if (this.match != null) {
            return this.match;
        }
        this.inPushRepos = true;
        this.addressOfSearchedRepo = this.buildSearchedAddress(false);
        this.findMatchingRepository();
        if (this.match != null) {
            return this.match;
        }
        this.findByName();
        return this.match;
    }

    private void findByName() throws IOException {
        RepositoryUtil repoUtil = GerritToGitMapping.getRepositoryUtil();
        RepositoryCache repoCache = GerritToGitMapping.getRepositoryCache();
        for (String dirs : repoUtil.getConfiguredRepositories()) {
            RemoteConfig remote;
            this.match = repoCache.lookupRepository(new File(dirs));
            if (!ResourcePropertyTester.hasGerritConfiguration((Repository)this.match) || (remote = this.findRemoteByName()) == null) continue;
            return;
        }
        this.match = null;
    }

    private RemoteConfig findRemoteByName() {
        ArrayList remotes;
        Assert.isNotNull((Object)this.match);
        try {
            remotes = RemoteConfig.getAllRemoteConfigs((Config)this.match.getConfig());
        }
        catch (URISyntaxException e) {
            remotes = new ArrayList(0);
        }
        for (RemoteConfig remote : remotes) {
            ArrayList remoteURIs = new ArrayList();
            remoteURIs.addAll(remote.getPushURIs());
            remoteURIs.addAll(remote.getURIs());
            for (URIish remoteURI : remoteURIs) {
                if (!this.getInterestingSegments(remoteURI).endsWith(this.gerritProject)) continue;
                return remote;
            }
        }
        return null;
    }

    private String buildSearchedAddress(boolean includePath) {
        if (includePath) {
            return String.valueOf(this.getInterestingSegments(this.daemonURL)) + '/' + this.gerritProject;
        }
        return String.valueOf(this.daemonURL.getHost()) + '/' + this.gerritProject;
    }

    private void findMatchingRepository() throws IOException {
        RepositoryUtil repoUtil = GerritToGitMapping.getRepositoryUtil();
        RepositoryCache repoCache = GerritToGitMapping.getRepositoryCache();
        for (String dirs : repoUtil.getConfiguredRepositories()) {
            RemoteConfig remote;
            this.match = repoCache.lookupRepository(new File(dirs));
            if (!ResourcePropertyTester.hasGerritConfiguration((Repository)this.match) || (remote = this.findMatchingRemote()) == null) continue;
            return;
        }
        this.match = null;
    }

    private RemoteConfig findMatchingRemote() throws IOException {
        ArrayList remotes;
        Assert.isNotNull((Object)this.match);
        try {
            remotes = RemoteConfig.getAllRemoteConfigs((Config)this.match.getConfig());
        }
        catch (URISyntaxException e) {
            remotes = new ArrayList(0);
        }
        for (RemoteConfig remote : remotes) {
            List remoteURIs = this.inPushRepos ? remote.getPushURIs() : remote.getURIs();
            for (URIish remoteURI : remoteURIs) {
                if (!this.getInterestingSegments(remoteURI).equals(this.addressOfSearchedRepo)) continue;
                return remote;
            }
        }
        return null;
    }

    private String getInterestingSegments(URIish uri) {
        return String.valueOf(uri.getHost()) + '/' + GerritToGitMapping.cleanTrailingDotGit(GerritToGitMapping.cleanLeadingSlash(uri.getPath()));
    }

    private static RepositoryCache getRepositoryCache() {
        Activator egit = Activator.getDefault();
        return egit.getRepositoryCache();
    }

    private static RepositoryUtil getRepositoryUtil() {
        Activator egit = Activator.getDefault();
        return egit.getRepositoryUtil();
    }

    private static String cleanLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private static String cleanTrailingDotGit(String path) {
        int dotGitIndex = path.lastIndexOf(".git");
        if (dotGitIndex >= 0) {
            return path.substring(0, dotGitIndex);
        }
        return path;
    }
}

