/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

@Deprecated
public class WatcherService
extends GitHubService {
    public WatcherService() {
    }

    public WatcherService(GitHubClient client) {
        super(client);
    }

    protected PagedRequest<User> createWatcherRequest(IRepositoryIdProvider repository, int start, int size) {
        String id = this.getId(repository);
        PagedRequest<User> request = this.createPagedRequest(start, size);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/watchers");
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return request;
    }

    public List<User> getWatchers(IRepositoryIdProvider repository) throws IOException {
        PagedRequest<User> request = this.createWatcherRequest(repository, 1, 100);
        return this.getAll(request);
    }

    public PageIterator<User> pageWatchers(IRepositoryIdProvider repository) {
        return this.pageWatchers(repository, 100);
    }

    public PageIterator<User> pageWatchers(IRepositoryIdProvider repository, int size) {
        return this.pageWatchers(repository, 1, size);
    }

    public PageIterator<User> pageWatchers(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<User> request = this.createWatcherRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    protected PagedRequest<Repository> createWatchedRequest(String user, int start, int size) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<Repository> request = this.createPagedRequest(start, size);
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/watched");
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return request;
    }

    protected PagedRequest<Repository> createWatchedRequest(int start, int size) {
        PagedRequest<Repository> request = this.createPagedRequest(start, size);
        request.setUri("/user/watched");
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return request;
    }

    public List<Repository> getWatched(String user) throws IOException {
        PagedRequest<Repository> request = this.createWatchedRequest(user, 1, 100);
        return this.getAll(request);
    }

    public PageIterator<Repository> pageWatched(String user) throws IOException {
        return this.pageWatched(user, 100);
    }

    public PageIterator<Repository> pageWatched(String user, int size) throws IOException {
        return this.pageWatched(user, 1, size);
    }

    public PageIterator<Repository> pageWatched(String user, int start, int size) throws IOException {
        PagedRequest<Repository> request = this.createWatchedRequest(user, start, size);
        return this.createPageIterator(request);
    }

    public List<Repository> getWatched() throws IOException {
        PagedRequest<Repository> request = this.createWatchedRequest(1, 100);
        return this.getAll(request);
    }

    public PageIterator<Repository> pageWatched() throws IOException {
        return this.pageWatched(100);
    }

    public PageIterator<Repository> pageWatched(int size) throws IOException {
        return this.pageWatched(1, size);
    }

    public PageIterator<Repository> pageWatched(int start, int size) throws IOException {
        PagedRequest<Repository> request = this.createWatchedRequest(start, size);
        return this.createPageIterator(request);
    }

    public boolean isWatching(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/watched");
        uri.append('/').append(id);
        return this.check(uri.toString());
    }

    public void watch(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/watched");
        uri.append('/').append(id);
        this.client.put(uri.toString());
    }

    public void unwatch(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/watched");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }
}

