/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.ocl.core.internal.evaluator;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.emf.facet.efacet.core.query.IQueryImplementationFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.query.ocl.core.internal.Activator;
import org.eclipse.emf.facet.query.ocl.core.internal.evaluator.OclQueryImplementation;
import org.eclipse.emf.facet.query.ocl.metamodel.oclquery.OclQuery;
import org.eclipse.emf.facet.query.ocl.metamodel.oclquery.OclQueryPackage;
import org.eclipse.emf.facet.util.core.Logger;
import org.osgi.framework.Bundle;

public class OclQueryImplementationFactory
implements IQueryImplementationFactory {
    public IQueryImplementation create(Query query, Bundle queryBundle, IDerivedTypedElementManager manager) throws DerivedTypedElementException {
        if (!(query instanceof OclQuery)) {
            throw new IllegalArgumentException("The given DerivedTypedElement does not have a OclQuery");
        }
        OclQuery oclQuery = (OclQuery)query;
        if (queryBundle == null) {
            throw new DerivedTypedElementException("Ocl query implementation class '" + oclQuery.getClass().getName() + "' should be created within a bundle.");
        }
        OclQueryImplementation oclQueryEvaluator = null;
        try {
            oclQueryEvaluator = new OclQueryImplementation();
        }
        catch (Exception e) {
            DerivedTypedElementException queryException = new DerivedTypedElementException("The bundle " + queryBundle.getSymbolicName() + " failed to load the ocl query: " + oclQuery.getClass().getSimpleName(), (Throwable)e);
            Logger.logError((Throwable)queryException, (Plugin)Activator.getDefault());
            throw queryException;
        }
        return oclQueryEvaluator;
    }

    public EClass getManagedQueryType() {
        return OclQueryPackage.eINSTANCE.getOclQuery();
    }
}

