/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.DelegatedTableEditorRegistry;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.IDelegatedTableEditorFactory;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.IPropertyChanger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TableEditor
extends EditorPart
implements ISelectionProvider,
IEditingDomainProvider,
IPropertyListener {
    private static final String EDITOR_ID = "org.eclipse.emf.facet.widgets.table.ui.workbench.editor.TableEditor";
    private EditorPart delegate;

    public Object getAdapter(Class adapter) {
        return this.delegate.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        boolean initialized = false;
        for (IDelegatedTableEditorFactory editorFactory : DelegatedTableEditorRegistry.INSTANCE.getFactories()) {
            if (!editorFactory.canHandle(input)) continue;
            this.delegate = editorFactory.createEditor();
            this.delegate.init(site, input);
            this.setSite(this.delegate.getSite());
            this.setInput(this.delegate.getEditorInput());
            this.setPartName(this.delegate.getPartName());
            if (this.delegate instanceof IPropertyChanger) {
                IPropertyChanger propertyChanger = (IPropertyChanger)this.delegate;
                propertyChanger.addPropertyChangeListener(this);
            }
            initialized = true;
            break;
        }
        if (!initialized) {
            throw new PartInitException("Cound not find an editor factory that handles the given input");
        }
    }

    public void createPartControl(Composite parent) {
        this.delegate.createPartControl(parent);
    }

    public void setFocus() {
        this.delegate.setFocus();
    }

    public boolean isDirty() {
        return this.delegate.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.delegate.isSaveAsAllowed();
    }

    public void doSave(IProgressMonitor monitor) {
        this.delegate.doSave(monitor);
    }

    public void doSaveAs() {
        this.delegate.doSaveAs();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.delegate instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.delegate;
            selectionProvider.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        ISelection result = null;
        if (this.delegate instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.delegate;
            result = selectionProvider.getSelection();
        }
        return result;
    }

    public EditingDomain getEditingDomain() {
        EditingDomain result = null;
        if (this.delegate instanceof IEditingDomainProvider) {
            IEditingDomainProvider edProvider = (IEditingDomainProvider)this.delegate;
            result = edProvider.getEditingDomain();
        }
        return result;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.delegate instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.delegate;
            selectionProvider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.delegate instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.delegate;
            selectionProvider.setSelection(selection);
        }
    }

    public IWorkbenchPartSite getSite() {
        IWorkbenchPartSite result = null;
        if (this.delegate != null) {
            result = this.delegate.getSite();
        }
        return result;
    }

    public IEditorSite getEditorSite() {
        return this.delegate.getEditorSite();
    }

    public IEditorInput getEditorInput() {
        return this.delegate.getEditorInput();
    }

    public String getTitle() {
        String result = "";
        if (this.delegate != null) {
            result = this.delegate.getTitle();
        }
        return result;
    }

    public static String getEditorId() {
        return EDITOR_ID;
    }

    public void propertyChanged(Object source, int propertyId) {
        this.firePropertyChange(propertyId);
    }

    public void dispose() {
        super.dispose();
        if (this.delegate instanceof IPropertyChanger) {
            IPropertyChanger propertyChanger = (IPropertyChanger)this.delegate;
            propertyChanger.removePropertyChangeListener(this);
        }
    }
}

