/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotColorProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DotColorProposalProvider
extends AbstractDotColorProposalProvider {
    public static String globalColorScheme = null;
    private final String defaultColorScheme = "x11";

    @Override
    public void completeStringColor_Scheme(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringColor_Scheme(model, assignment, context, acceptor);
        for (String colorScheme : DotColors.getColorSchemes()) {
            acceptor.accept(this.createCompletionProposal(colorScheme, context));
        }
    }

    @Override
    public void completeStringColor_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringColor_Name(model, assignment, context, acceptor);
        String colorScheme = "x11";
        if (model instanceof StringColor && ((StringColor)model).getScheme() != null) {
            colorScheme = ((StringColor)model).getScheme();
        } else if (globalColorScheme != null) {
            colorScheme = globalColorScheme;
        }
        for (String colorName : DotColors.getColorNames((String)colorScheme.toLowerCase())) {
            acceptor.accept(this.createCompletionProposal(colorName, context));
        }
    }
}

