/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class HyperlinkLabel
extends Canvas {
    Label label;
    boolean hasFocus;

    public HyperlinkLabel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 2;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, style);
        this.addPaintListener(e -> this.paint(e));
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    HyperlinkLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, e -> {
            switch (e.detail) {
                case 64: {
                    e.detail = 16;
                    break;
                }
                case 32: {
                    e.detail = 8;
                    break;
                }
                case 4: 
                case 256: 
                case 512: {
                    e.doit = false;
                    return;
                }
            }
            e.doit = true;
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!HyperlinkLabel.this.hasFocus) {
                    HyperlinkLabel.this.hasFocus = true;
                    HyperlinkLabel.this.notifyListeners(13);
                    HyperlinkLabel.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                if (HyperlinkLabel.this.hasFocus) {
                    HyperlinkLabel.this.hasFocus = false;
                    HyperlinkLabel.this.notifyListeners(13);
                    HyperlinkLabel.this.redraw();
                }
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.verticalAlignment = 2;
        this.label.setLayoutData((Object)data);
        this.initAccessibleLink();
        this.initAccessibleLabel();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    public Label getLabel() {
        return this.label;
    }

    void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    protected void paint(PaintEvent e) {
        if (this.hasFocus) {
            GC gc = e.gc;
            Point size = this.getSize();
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= 4;
        }
        Point textSize = this.label.computeSize(wHint, hHint, changed);
        int textWidth = textSize.x + 4;
        int textHeight = textSize.y + 6;
        return new Point(textWidth, textHeight);
    }

    public void addMouseListener(MouseListener l) {
        this.label.addMouseListener(l);
    }

    public void addMouseTrackListener(MouseTrackListener l) {
        this.label.addMouseTrackListener(l);
    }

    public void addPaintListener(PaintListener l) {
        super.addPaintListener(l);
        this.label.addPaintListener(l);
    }

    public void addListener(int e, Listener l) {
        super.addListener(e, l);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.label.setBackground(c);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.label.setForeground(c);
    }

    public void setCursor(Cursor c) {
        super.setCursor(c);
        this.label.setCursor(c);
    }

    private void initAccessibleLink() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = HyperlinkLabel.this.label.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = HyperlinkLabel.this.label.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = HyperlinkLabel.this.hasFocus ? 0x500004 : 0x500000;
            }
        });
    }

    private void initAccessibleLabel() {
        Accessible accessible = this.label.getAccessible();
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getState(AccessibleControlEvent e) {
                e.detail = HyperlinkLabel.this.hasFocus ? 0x700044 : 0x700040;
            }
        });
    }
}

