/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;

public class OTJavaElementDelta
implements IJavaElementDelta {
    private IJavaElementDelta delegate;
    private Map<IJavaElement, IOTJavaElement> otElemMapping;

    public OTJavaElementDelta(IJavaElementDelta delta) {
        this(new HashMap<IJavaElement, IOTJavaElement>(), delta);
    }

    public OTJavaElementDelta(Map<IJavaElement, IOTJavaElement> otElemMapping, IJavaElementDelta delta) {
        this.delegate = delta;
        this.otElemMapping = otElemMapping;
    }

    @Override
    public IJavaElement getElement() {
        return this.maybeTransformElement(this.delegate.getElement());
    }

    @Override
    public IJavaElementDelta[] getAddedChildren() {
        return this.wrapChildren(this.delegate.getAddedChildren());
    }

    @Override
    public IJavaElementDelta[] getAffectedChildren() {
        return this.wrapChildren(this.delegate.getAffectedChildren());
    }

    @Override
    public IJavaElementDelta[] getChangedChildren() {
        return this.wrapChildren(this.delegate.getChangedChildren());
    }

    @Override
    public IJavaElement getMovedFromElement() {
        return this.maybeTransformElement(this.delegate.getMovedFromElement());
    }

    @Override
    public IJavaElement getMovedToElement() {
        return this.maybeTransformElement(this.delegate.getMovedToElement());
    }

    @Override
    public IJavaElementDelta[] getRemovedChildren() {
        return this.wrapChildren(this.delegate.getRemovedChildren());
    }

    @Override
    public IJavaElementDelta[] getAnnotationDeltas() {
        return this.wrapChildren(this.delegate.getAnnotationDeltas());
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        return this.delegate.getResourceDeltas();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public int getFlags() {
        return this.delegate.getFlags();
    }

    @Override
    public int getKind() {
        return this.delegate.getKind();
    }

    @Override
    public CompilationUnit getCompilationUnitAST() {
        return this.delegate.getCompilationUnitAST();
    }

    private OTJavaElementDelta[] wrapChildren(IJavaElementDelta[] deltas) {
        return this.wrapDeltas(deltas);
    }

    private OTJavaElementDelta[] wrapDeltas(IJavaElementDelta[] deltas) {
        OTJavaElementDelta[] result = new OTJavaElementDelta[deltas.length];
        int idx = 0;
        while (idx < deltas.length) {
            result[idx] = new OTJavaElementDelta(this.otElemMapping, deltas[idx]);
            ++idx;
        }
        return result;
    }

    private IJavaElement maybeTransformElement(IJavaElement element) {
        if (element instanceof IType) {
            IOTType otElement = OTModelManager.getOTElement((IType)element);
            if (otElement != null) {
                return otElement;
            }
            IOTJavaElement otElem = this.otElemMapping.get(element);
            if (otElem != null) {
                return otElem;
            }
        }
        return element;
    }
}

