/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.Assert;

public class StartAutBP {
    private static StartAutBP instance = null;
    private IAUTMainPO m_lastUsedAut;
    private IAUTConfigPO m_lastUsedConf;
    private boolean m_isProjectLoaded = false;
    private boolean m_isServerConnected = false;
    private DataEventDispatcher.AutState m_autState = DataEventDispatcher.AutState.notRunning;
    private boolean m_atLeastOneAutAvailable = false;
    private boolean m_autStarted = false;
    private Map<String, String> m_hostNameCache = new HashMap<String, String>();
    private DataEventDispatcher.IProjectLoadedListener m_projLoadedListener = new DataEventDispatcher.IProjectLoadedListener(){

        public void handleProjectLoaded() {
            StartAutBP.this.m_isProjectLoaded = true;
            StartAutBP.this.m_lastUsedAut = null;
            StartAutBP.this.m_lastUsedConf = null;
            StartAutBP.this.m_autState = DataEventDispatcher.AutState.notRunning;
            StartAutBP.this.m_autStarted = false;
            StartAutBP.this.m_atLeastOneAutAvailable = false;
            StartAutBP.this.fireAUTButtonStateCouldBeChanged();
        }
    };
    private DataEventDispatcher.IDataChangedListener m_currentProjDeletedListener = new DataEventDispatcher.IDataChangedListener(){

        public void handleDataChanged(DataChangedEvent ... events) {
            DataChangedEvent[] dataChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
                ++n2;
            }
        }

        public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
            if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                return;
            }
            if (dataState == DataEventDispatcher.DataState.Deleted && po instanceof IProjectPO && GeneralStorage.getInstance().getProject() == null) {
                StartAutBP.this.m_isProjectLoaded = false;
                StartAutBP.this.m_lastUsedAut = null;
                StartAutBP.this.m_lastUsedConf = null;
                StartAutBP.this.m_autState = DataEventDispatcher.AutState.notRunning;
                StartAutBP.this.m_autStarted = false;
                StartAutBP.this.m_atLeastOneAutAvailable = false;
            }
        }
    };
    private DataEventDispatcher.IServerConnectionListener m_serverConnectListener = new DataEventDispatcher.IServerConnectionListener(){

        public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
            switch (state) {
                case Connected: {
                    StartAutBP.this.m_isServerConnected = true;
                    break;
                }
                case Disconnected: 
                case Connecting: {
                    StartAutBP.this.m_isServerConnected = false;
                    StartAutBP.this.m_autState = DataEventDispatcher.AutState.notRunning;
                    StartAutBP.this.m_autStarted = false;
                    break;
                }
                default: {
                    Assert.notReached((String)Messages.UnhandledConnectionStateForServer);
                }
            }
            StartAutBP.this.fireAUTButtonStateCouldBeChanged();
        }
    };
    private DataEventDispatcher.IAutStateListener m_autStateListener = new DataEventDispatcher.IAutStateListener(){

        public void handleAutStateChanged(DataEventDispatcher.AutState state) {
            switch (state) {
                case running: {
                    StartAutBP.this.m_autState = DataEventDispatcher.AutState.running;
                    break;
                }
                case notRunning: {
                    StartAutBP.this.m_autState = DataEventDispatcher.AutState.notRunning;
                    StartAutBP.this.m_autStarted = false;
                    break;
                }
                default: {
                    Assert.notReached((String)Messages.UnhandledAutState);
                }
            }
            StartAutBP.this.fireAUTButtonStateCouldBeChanged();
        }
    };
    private DataEventDispatcher.IProjectStateListener m_projPropModifyListener = new DataEventDispatcher.IProjectStateListener(){

        public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
            if (DataEventDispatcher.ProjectState.prop_modified.equals((Object)state)) {
                if (StartAutBP.this.getLastUsedAut() == null || StartAutBP.this.getLastUsedConf() == null) {
                    StartAutBP.this.fireAUTButtonStateCouldBeChanged();
                    return;
                }
                String autName = StartAutBP.this.getLastUsedAut().getName();
                String confName = StartAutBP.this.getLastUsedConf().getName();
                for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
                    if (!autName.equals(aut.getName())) continue;
                    for (IAUTConfigPO conf : aut.getAutConfigSet()) {
                        if (!confName.equals(conf.getName())) continue;
                        StartAutBP.this.setLastUsedAut(aut);
                        StartAutBP.this.setLastUsedAutConf(conf);
                        return;
                    }
                }
                StartAutBP.this.fireAUTButtonStateCouldBeChanged();
            }
        }
    };

    private StartAutBP() {
        this.init();
    }

    private void init() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener(this.m_projLoadedListener, true);
        ded.addDataChangedListener(this.m_currentProjDeletedListener, true);
        ded.addAutAgentConnectionListener(this.m_serverConnectListener, true);
        ded.addAutStateListener(this.m_autStateListener, true);
        ded.addProjectStateListener(this.m_projPropModifyListener);
    }

    public static StartAutBP getInstance() {
        if (instance == null) {
            instance = new StartAutBP();
        }
        return instance;
    }

    public SortedMap<IAUTMainPO, SortedSet<IAUTConfigPO>> getAllAUTs() {
        if (GeneralStorage.getInstance().getProject() != null) {
            Set<IAUTMainPO> autsForLang = this.getAUTs();
            return this.getAutsForAutAgent(autsForLang);
        }
        return new TreeMap<IAUTMainPO, SortedSet<IAUTConfigPO>>();
    }

    private SortedMap<IAUTMainPO, SortedSet<IAUTConfigPO>> getAutsForAutAgent(Set<IAUTMainPO> auts) {
        TreeMap<IAUTMainPO, SortedSet<IAUTConfigPO>> autMap = new TreeMap<IAUTMainPO, SortedSet<IAUTConfigPO>>();
        String agentHostname = this.resolveAUTAgentHostName();
        if (agentHostname != null) {
            agentHostname = agentHostname.toLowerCase();
            String agentIp = this.resolveIpUsingCache(agentHostname);
            HashSet<String> validHosts = new HashSet<String>();
            validHosts.add(agentIp);
            validHosts.add(agentHostname);
            InetAddress lh = EnvConstants.LOCALHOST;
            if (this.isConnectedToLocalhost(agentIp, agentHostname, lh)) {
                validHosts.add("localhost");
                validHosts.add("127.0.0.1");
                validHosts.add(lh.getHostAddress());
                validHosts.add(lh.getHostName().toLowerCase());
                validHosts.add(EnvConstants.LOCALHOST_FQDN.toLowerCase());
            }
            for (IAUTMainPO autForLang : auts) {
                Set confs = autForLang.getAutConfigSet();
                TreeSet<IAUTConfigPO> validConfs = new TreeSet<IAUTConfigPO>();
                for (IAUTConfigPO conf : confs) {
                    String confAgentName = conf.getConfiguredAUTAgentHostName().toLowerCase();
                    String confAgentIp = this.resolveIpUsingCache(confAgentName);
                    if (!validHosts.contains(confAgentIp) && !validHosts.contains(confAgentName)) continue;
                    validConfs.add(conf);
                }
                if (validConfs.isEmpty()) continue;
                autMap.put(autForLang, validConfs);
            }
        }
        return autMap;
    }

    private boolean isConnectedToLocalhost(String agentIp, String agentHostname, InetAddress localhost) {
        if (agentIp.equals("127.0.0.1") || agentHostname.equals("localhost")) {
            return true;
        }
        if (localhost == null) {
            return false;
        }
        String hostAddress = localhost.getHostAddress();
        String hostName = localhost.getHostName().toLowerCase();
        String fqHostName = localhost.getCanonicalHostName().toLowerCase();
        return hostAddress.equals(agentIp) || hostName.equals(agentHostname) || fqHostName.equals(agentHostname);
    }

    private String resolveAUTAgentHostName() {
        String serverHostName = null;
        try {
            AutAgentConnection serverConn = AutAgentConnection.getInstance();
            if (serverConn.isConnected() && serverConn.getCommunicator() != null) {
                serverHostName = serverConn.getCommunicator().getHostName();
            }
        }
        catch (ConnectionException connectionException) {}
        return serverHostName;
    }

    private String resolveIpUsingCache(String hostname) {
        String ip = null;
        if (!this.m_hostNameCache.containsKey(hostname)) {
            try {
                ip = InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
            this.m_hostNameCache.put(hostname, ip);
        } else {
            ip = this.m_hostNameCache.get(hostname);
        }
        return ip;
    }

    private Set<IAUTMainPO> getAUTs() {
        return GeneralStorage.getInstance().getProject().getAutMainList();
    }

    public IAUTMainPO getLastUsedAut() {
        return this.m_lastUsedAut;
    }

    public void setLastUsedAut(IAUTMainPO lastUsedAut) {
        this.m_lastUsedAut = lastUsedAut;
    }

    public void setLastUsedAutConf(IAUTConfigPO conf) {
        this.m_lastUsedConf = conf;
    }

    public IAUTConfigPO getLastUsedConf() {
        return this.m_lastUsedConf;
    }

    public boolean isEnabled() {
        return this.m_isProjectLoaded && this.m_isServerConnected && this.m_autState == DataEventDispatcher.AutState.notRunning && !this.m_autStarted && this.m_atLeastOneAutAvailable;
    }

    protected void validateNumberOfAuts() {
        SortedMap<IAUTMainPO, SortedSet<IAUTConfigPO>> allAUTs = this.getAllAUTs();
        if (allAUTs.size() < 1) {
            this.m_atLeastOneAutAvailable = false;
        } else {
            this.m_atLeastOneAutAvailable = true;
            if (this.m_lastUsedAut != null && this.m_lastUsedConf != null) {
                this.validateLastUsedAut(allAUTs);
            }
        }
    }

    private void validateLastUsedAut(SortedMap<IAUTMainPO, SortedSet<IAUTConfigPO>> allAUTs) {
        if (!allAUTs.containsKey(this.m_lastUsedAut) || !((SortedSet)allAUTs.get(this.m_lastUsedAut)).contains(this.m_lastUsedConf)) {
            this.m_lastUsedAut = null;
            this.m_lastUsedConf = null;
        }
    }

    private void fireAUTButtonStateCouldBeChanged() {
        final String jobName = Messages.UIJobUpdatingRecentlyUsedAuts;
        Job resolveStartableAUTs = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                StartAutBP.this.validateNumberOfAuts();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob((Job)resolveStartableAUTs, null);
    }

    public void fireAutStarted() {
        this.m_autStarted = true;
    }
}

