/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.EditPartAdapter;
import org.eclipse.jwt.we.parts.internal.EditPartAdapterSupport;
import org.osgi.framework.Bundle;

public class EditPartAdapterFactory
extends AdapterFactoryImpl {
    private static final Logger logger = Logger.getLogger(EditPartAdapterFactory.class);
    public static final String MODEL_VIEW_ROOT_PACKAGE = "org.eclipse.jwt.we.model";
    public static final String MODEL_JWT_ROOT_PACKAGE = "org.eclipse.jwt.meta.model";
    private String editPartPackage;
    private String modelPackage;
    private Bundle bundle;
    private static final String EDITPART_POSTFIX = "EditPart";

    public EditPartAdapterFactory(String editPartPackage, String modelPackage, EclipseUIPlugin plugin) {
        this.editPartPackage = editPartPackage;
        this.modelPackage = modelPackage;
        this.bundle = plugin == null ? Platform.getBundle((String)Plugin.getDefault().getBundle().getSymbolicName()) : Platform.getBundle((String)plugin.getBundle().getSymbolicName());
    }

    public boolean isFactoryForType(Object type) {
        return type == EditPartAdapter.class.getInterfaces() || type == IFigure.class;
    }

    public Object adapt(Object target, Object type) {
        logger.enter("Create a \"" + type + "\" for a \"" + target.getClass().getName() + "\".");
        Object adapter = null;
        if (type == IFigure.class) {
            if (target instanceof EClass) {
                adapter = this.findAdapterWithSubclasses((EClass)target, type);
            } else if (target instanceof Class) {
                adapter = this.findAdapterWithSubclasses((Class)target, type);
            }
        }
        if (adapter == null) {
            adapter = super.adapt(target, type);
        }
        return adapter;
    }

    protected Adapter createAdapter(Notifier target, Object type) {
        if (type == EditPartAdapter.class && target instanceof EObject) {
            return (Adapter)this.findAdapterWithSubclasses(((EObject)target).eClass(), type);
        }
        return super.createAdapter(target, type);
    }

    private Object findAdapterWithSubclasses(EClass targetClass, Object type) {
        Object adapter = this.findAdapter(targetClass.getInstanceClass(), type);
        if (adapter != null) {
            return adapter;
        }
        EList superTypes = targetClass.getEAllSuperTypes();
        int i = superTypes.size() - 1;
        while (i >= 0) {
            EClass testType = (EClass)superTypes.get(i);
            adapter = this.findAdapter(testType.getInstanceClass(), type);
            if (adapter != null) {
                return adapter;
            }
            --i;
        }
        return null;
    }

    private Object findAdapterWithSubclasses(Class targetClass, Object type) {
        Object adapter = this.findAdapter(targetClass, type);
        if (adapter != null) {
            return adapter;
        }
        adapter = this.findAdapterWithSubclasses(targetClass.getSuperclass(), type);
        if (adapter != null) {
            return adapter;
        }
        Class<?>[] classArray = targetClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> testType = classArray[n2];
            adapter = this.findAdapterWithSubclasses(testType, type);
            if (adapter != null) {
                return adapter;
            }
            ++n2;
        }
        return null;
    }

    private Object findAdapter(Class targetClass, Object type) {
        String target = targetClass.getName();
        Object editPart = null;
        if (target.startsWith(MODEL_JWT_ROOT_PACKAGE)) {
            target = target.replace(MODEL_JWT_ROOT_PACKAGE, this.modelPackage);
        }
        if (!target.startsWith(this.modelPackage)) {
            return null;
        }
        target = String.valueOf(this.editPartPackage) + target.substring(this.modelPackage.length()) + EDITPART_POSTFIX;
        try {
            editPart = this.bundle.loadClass(target).newInstance();
            logger.instanceCreation(target);
        }
        catch (ClassNotFoundException e) {
            logger.debug(e);
            return null;
        }
        catch (InstantiationException e) {
            logger.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.debug(e);
            return null;
        }
        if (type == EditPartAdapter.class) {
            Adapter adapter;
            if (editPart instanceof EditPartAdapterSupport && (adapter = ((EditPartAdapterSupport)editPart).getAdapter()).isAdapterForType((Object)targetClass)) {
                return adapter;
            }
        } else if (type == IFigure.class && editPart instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)editPart).getFigure();
        }
        return null;
    }
}

