/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.docker.editor.Messages;
import org.eclipse.linuxtools.internal.docker.editor.scanner.DockerPartitionScanner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class DockerDocumentProvider
extends FileDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            DockerPartitionScanner scanner = new DockerPartitionScanner();
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)scanner, DockerPartitionScanner.ALLOWED_CONTENT_TYPES);
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    public String getEncoding(Object element) {
        return Charset.defaultCharset().name();
    }

    public boolean isReadOnly(Object element) {
        if (element instanceof FileStoreEditorInput) {
            String path = ((FileStoreEditorInput)element).getURI().getPath();
            return !new File(path).canWrite();
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        if (element instanceof FileStoreEditorInput) {
            String path = ((FileStoreEditorInput)element).getURI().getPath();
            return new File(path).canWrite();
        }
        return super.isModifiable(element);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof FileStoreEditorInput) {
            FileInputStream in;
            String path = ((FileStoreEditorInput)editorInput).getURI().getPath();
            try {
                in = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            super.setDocumentContent(document, (InputStream)in, encoding);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        Throwable model;
        Object var12_24;
        ByteArrayInputStream stream;
        Charset charset;
        if (!(element instanceof FileStoreEditorInput)) {
            super.doSaveDocument(monitor, element, document, overwrite);
            return;
        }
        String encoding = null;
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
        Path filePath = Paths.get(((FileStoreEditorInput)element).getURI());
        encoding = this.getEncoding(element);
        try {
            charset = Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException ex) {
            String message = NLS.bind((String)Messages.DockerDocumentProvider_encoding_not_supported, (Object)encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        catch (IllegalCharsetNameException ex) {
            String message = NLS.bind((String)Messages.DockerDocumentProvider_encoding_not_legal, (Object)encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            byte[] bytes;
            ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(document.get()));
            if (byteBuffer.hasArray()) {
                bytes = byteBuffer.array();
            } else {
                bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
            }
            stream = new ByteArrayInputStream(bytes, 0, byteBuffer.limit());
        }
        catch (CharacterCodingException ex) {
            Assert.isTrue((boolean)(ex instanceof UnmappableCharacterException));
            String message = NLS.bind((String)(String.valueOf(Messages.DockerDocumentProvider_cannot_be_mapped) + Messages.DockerDocumentProvider_chars_not_supported), (Object)encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
            throw new CoreException((IStatus)s);
        }
        if (Files.exists(filePath, new LinkOption[0])) {
            block45: {
                this.fireElementStateChanging(element);
                try {
                    Throwable ex = null;
                    var12_24 = null;
                    try {
                        FileWriter fw = new FileWriter(filePath.toFile());
                        try {
                            try (InputStreamReader istream = new InputStreamReader(stream);){
                                char[] bb = new char[1024];
                                int nRead = istream.read(bb);
                                while (nRead > 0) {
                                    fw.write(bb, 0, nRead);
                                    nRead = istream.read(bb);
                                }
                            }
                            if (fw == null) break block45;
                        }
                        catch (Throwable throwable) {
                            if (ex == null) {
                                ex = throwable;
                            } else if (ex != throwable) {
                                ex.addSuppressed(throwable);
                            }
                            if (fw == null) throw ex;
                            fw.close();
                            throw ex;
                        }
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        if (ex == null) {
                            ex = throwable;
                            throw ex;
                        }
                        if (ex == throwable) throw ex;
                        ex.addSuppressed(throwable);
                        throw ex;
                    }
                }
                catch (IOException | RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.docker.editor", x.getMessage()));
                }
            }
            if (info == null) return;
            model = (ResourceMarkerAnnotationModel)info.fModel;
            if (model == null) return;
            model.updateMarkers(info.fDocument);
            return;
        }
        try {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
                model = null;
                var12_24 = null;
                try {
                    FileWriter fw = new FileWriter(filePath.toFile());
                    try {
                        try (InputStreamReader istream = new InputStreamReader(stream);){
                            char[] bb = new char[1024];
                            int nRead = istream.read(bb);
                            while (nRead > 0) {
                                fw.write(bb, 0, nRead);
                                nRead = istream.read(bb);
                            }
                        }
                        if (fw == null) return;
                    }
                    catch (Throwable throwable) {
                        if (model == null) {
                            model = throwable;
                        } else if (model != throwable) {
                            model.addSuppressed(throwable);
                        }
                        if (fw == null) throw model;
                        fw.close();
                        throw model;
                    }
                    fw.close();
                    return;
                }
                catch (Throwable throwable) {
                    if (model == null) {
                        model = throwable;
                        throw model;
                    }
                    if (model == throwable) throw model;
                    model.addSuppressed(throwable);
                    throw model;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.docker.editor", e.getMessage()));
            }
        }
        finally {
            monitor.done();
        }
    }
}

