/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.messages;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> forLeft(@NonNull L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> forRight(@NonNull R right) {
        return new Either<Object, R>(null, right);
    }

    protected Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Either [").append(System.lineSeparator());
        builder.append("  left = ").append(this.left).append(System.lineSeparator());
        builder.append("  right = ").append(this.right).append(System.lineSeparator());
        return builder.append("]").toString();
    }

    public static Type getLeftDisjointType(Type type) {
        if (Either.isEither(type)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return parameterizedType.getActualTypeArguments()[0];
            }
            if (type instanceof Class) {
                Class cls = (Class)type;
                return cls.getTypeParameters()[0];
            }
        }
        return null;
    }

    public static Type getRightDisjointType(Type type) {
        if (Either.isEither(type)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return parameterizedType.getActualTypeArguments()[1];
            }
            if (type instanceof Class) {
                Class cls = (Class)type;
                return cls.getTypeParameters()[1];
            }
        }
        return null;
    }

    public static Collection<Type> getAllDisjoinTypes(Type type) {
        return Either.collectDisjoinTypes(type, new ArrayList<Type>());
    }

    protected static Collection<Type> collectDisjoinTypes(Type type, Collection<Type> types) {
        if (Either.isEither(type)) {
            if (type instanceof ParameterizedType) {
                return Either.collectDisjoinTypes((ParameterizedType)type, types);
            }
            if (type instanceof Class) {
                return Either.collectDisjoinTypes((Class)type, types);
            }
        }
        types.add(type);
        return types;
    }

    protected static Collection<Type> collectDisjoinTypes(ParameterizedType type, Collection<Type> types) {
        for (Type typeArgument : type.getActualTypeArguments()) {
            Either.collectDisjoinTypes(typeArgument, types);
        }
        return types;
    }

    protected static Collection<Type> collectDisjoinTypes(Class<?> type, Collection<Type> types) {
        for (TypeVariable<Class<?>> typeParameter : type.getTypeParameters()) {
            Either.collectDisjoinTypes(typeParameter, types);
        }
        return types;
    }

    public static boolean isEither(Type type) {
        if (type instanceof ParameterizedType) {
            return Either.isEither((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return Either.isEither((Class)type);
        }
        return false;
    }

    public static boolean isEither(ParameterizedType type) {
        return Either.isEither(type.getRawType());
    }

    public static boolean isEither(Class<?> cls) {
        return Either.class.isAssignableFrom(cls);
    }
}

