/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.QvtLibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNativeLibSupport {
    public static final LegacyNativeLibSupport INSTANCE = LegacyNativeLibSupport.createInstance();

    private LegacyNativeLibSupport() {
    }

    public QvtOperationalModuleEnv defineLibrary(Library lib, Map<String, List<EOperation>> definedOperations) throws LibraryCreationException {
        org.eclipse.m2m.internal.qvt.oml.expressions.Library libModule = QvtOperationalStdLibrary.createLibrary((String)lib.getId());
        QvtOperationalModuleEnv libEnv = LegacyNativeLibSupport.initLibEnvironment(lib, (Module)libModule);
        URI libUri = URI.createHierarchicalURI((String)"qvto", (String)"blackbox", null, (String[])new String[]{lib.getId()}, null, null);
        libModule.eResource().setURI(libUri);
        org.eclipse.m2m.internal.qvt.oml.expressions.Library opModule = QvtOperationalStdLibrary.createLibrary((String)lib.getId());
        QvtOperationalModuleEnv opEnv = LegacyNativeLibSupport.initLibEnvironment(lib, (Module)opModule);
        for (LibraryOperation libOp : lib.getLibraryOperations()) {
            Helper helper = this.defineOperation(opModule, opEnv, libOp);
            libEnv.defineImperativeOperation((ImperativeOperation)helper, false, true);
            List<EOperation> listOp = definedOperations.get(helper.getName());
            if (listOp == null) {
                listOp = new LinkedList<EOperation>();
                definedOperations.put(helper.getName(), listOp);
            }
            listOp.add((EOperation)helper);
        }
        ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), (ASTNode)libEnv.getModuleContextType(), (Environment)libEnv);
        return libEnv;
    }

    private static QvtOperationalModuleEnv initLibEnvironment(Library lib, Module libModule) {
        EPackage ePackage;
        String mm;
        int n;
        int n2;
        String[] stringArray;
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        QvtOperationalModuleEnv libEnv = new QvtOperationalEnvFactory((EPackage.Registry)registry).createModuleEnvironment(libModule);
        EPackage.Registry libEnvRegistry = libEnv.getEPackageRegistry();
        EPackage oclStdlibPackage = ((EClassifier)libEnv.getOCLStandardLibrary().getOclAny()).getEPackage();
        libEnv.getEPackageRegistry().put((Object)oclStdlibPackage.getNsURI(), (Object)oclStdlibPackage);
        if (lib.getInMetamodels() != null) {
            stringArray = lib.getInMetamodels();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                mm = stringArray[n];
                ePackage = EPackage.Registry.INSTANCE.getEPackage(mm);
                if (ePackage != null) {
                    libEnvRegistry.put((Object)mm, (Object)ePackage);
                }
                ++n;
            }
        }
        if (lib.getOutMetamodels() != null) {
            stringArray = lib.getOutMetamodels();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                mm = stringArray[n];
                ePackage = EPackage.Registry.INSTANCE.getEPackage(mm);
                if (ePackage != null) {
                    libEnvRegistry.put((Object)mm, (Object)ePackage);
                }
                ++n;
            }
        }
        return libEnv;
    }

    private static Object callOperation(QvtOperationalEvaluationEnv evalEnv, LibraryOperation libOp, Object source, Object[] args, Class<?> returnClass) {
        Object result;
        if (source == null || source == CallHandlerAdapter.getInvalidResult((QvtOperationalEvaluationEnv)evalEnv)) {
            return CallHandlerAdapter.getInvalidResult((QvtOperationalEvaluationEnv)evalEnv);
        }
        Object[] callArgs = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (evalEnv.isOclInvalid(args[i])) {
                    if (callArgs == null) {
                        callArgs = new Object[args.length];
                        System.arraycopy(args, 0, callArgs, 0, args.length);
                    }
                    callArgs[i] = null;
                }
                ++i;
            }
            Object[] objectArray = callArgs = callArgs == null ? args : callArgs;
        }
        if ((result = libOp.run(source, callArgs, new Object[0], returnClass)) == null) {
            return QvtOperationalUtil.getInvalid((EvaluationEnvironment)evalEnv);
        }
        return result;
    }

    private Helper defineOperation(org.eclipse.m2m.internal.qvt.oml.expressions.Library opModule, QvtOperationalModuleEnv opEnv, LibraryOperation libOp) throws LibraryCreationException {
        QvtLibraryOperation qvtLibOp = new QvtLibraryOperation(opEnv, libOp);
        Helper helper = ExpressionsFactory.eINSTANCE.createHelper();
        helper.setName(libOp.getName());
        helper.setEType(qvtLibOp.getReturnType());
        int index = 1;
        EClassifier[] eClassifierArray = qvtLibOp.getParamTypes();
        int n = eClassifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier type = eClassifierArray[n2];
            VarParameter varParam = ExpressionsFactory.eINSTANCE.createVarParameter();
            varParam.setKind(DirectionKind.IN);
            varParam.setEType(type);
            varParam.setName("arg" + index);
            ++index;
            helper.getEParameters().add((Object)varParam);
            ++n2;
        }
        if (qvtLibOp.getContextType() != opModule) {
            VarParameter varParam = ExpressionsFactory.eINSTANCE.createVarParameter();
            varParam.setKind(DirectionKind.IN);
            varParam.setEType(qvtLibOp.getContextType());
            varParam.setName("self");
            helper.setContext(varParam);
        }
        Class returnClass = helper.getEType() != null ? helper.getEType().getInstanceClass() : null;
        CallHandlerAdapter.attach((EOperation)helper, (CallHandler)new Handler(libOp, returnClass));
        return helper;
    }

    private static LegacyNativeLibSupport createInstance() {
        LegacyNativeLibSupport lib = new LegacyNativeLibSupport();
        return lib;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    extends CallHandler {
        private LibraryOperation fOperation;
        private Class<?> fReturnClass;

        private Handler(LibraryOperation operation, Class<?> returnClass) {
            assert (operation != null);
            this.fOperation = operation;
            this.fReturnClass = returnClass;
        }

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            return LegacyNativeLibSupport.callOperation(evalEnv, this.fOperation, source, args, this.fReturnClass);
        }
    }
}

