/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.core.internal.defaultengine;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.workflow.core.WorkflowExecution;
import org.eclipse.modisco.workflow.core.WorkflowModel;
import org.eclipse.modisco.workflow.core.internal.Activator;
import org.eclipse.modisco.workflow.core.internal.Messages;
import org.eclipse.modisco.workflow.core.internal.defaultengine.Utils;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowControllerImpl;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowModelImpl;
import org.eclipse.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.osgi.util.NLS;

public class WorkflowExecutionImpl
implements WorkflowExecution {
    public void launchWorkflow(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        WorkflowModelImpl workflowModel = new WorkflowModelImpl();
        workflowModel.initialize(configuration);
        monitor.worked(1);
        WorkflowControllerImpl workflowController = new WorkflowControllerImpl();
        String errorMessage = workflowController.validate(workflowModel);
        if (errorMessage != null) {
            Status status = new Status(4, "org.eclipse.modisco.workflow.core", errorMessage);
            throw new CoreException((IStatus)status);
        }
        monitor.worked(1);
        WorkflowExecutionImpl.launchWorkflow(workflowModel, mode, launch, monitor);
    }

    public static void launchWorkflow(WorkflowModel workflowModel, String mode, ILaunch launch, IProgressMonitor monitor) {
        ArrayList launchResults = new ArrayList();
        for (Element element : workflowModel.getAllElements()) {
            if (monitor.isCanceled() && launch.canTerminate()) {
                try {
                    launch.terminate();
                    for (ILaunch subLaunch : launchResults) {
                        if (!subLaunch.canTerminate()) continue;
                        subLaunch.terminate();
                    }
                }
                catch (DebugException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            ILaunchConfiguration conf = Utils.getLaunchConfigurationFromName(element.getName());
            ILaunchConfigurationWorkingCopy config = null;
            try {
                IProcess[] processes;
                config = conf.getWorkingCopy();
                monitor.subTask(NLS.bind((String)Messages.WorkflowExecutionImpl_elementOfType, (Object)element.getName(), (Object)element.getType()));
                ILaunch launchChild = config.launch(mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IProcess[] iProcessArray = processes = launchChild.getProcesses();
                int n = processes.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    while (!process.isTerminated()) {
                        Thread.yield();
                        Thread.sleep(10L);
                    }
                    ++n2;
                }
                monitor.worked(1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

