/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.LabelsAttributeEditor;

public class OptionsProposalProvider
implements IContentProposalProvider {
    private static final String VALUE_SEPARATOR = ",";
    private final Set<String> proposals;
    private final boolean isMultiSelect;

    public OptionsProposalProvider(Map<String, String> proposals, boolean isMultiSelect) {
        this.proposals = proposals.keySet();
        this.isMultiSelect = isMultiSelect;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        HashSet<String> filteredProposals = new HashSet<String>(this.proposals);
        filteredProposals.remove("");
        String lastValue = "";
        if (this.isMultiSelect) {
            String[] contentsArray = contents.split(VALUE_SEPARATOR, -1);
            if (contentsArray.length > 0) {
                List<String> trimmedContents = LabelsAttributeEditor.getTrimmedValues(contentsArray);
                filteredProposals.removeAll(trimmedContents);
                lastValue = contentsArray[contentsArray.length - 1].trim();
            }
        } else {
            lastValue = contents;
        }
        if (!lastValue.isEmpty()) {
            Iterator iterator = filteredProposals.iterator();
            while (iterator.hasNext()) {
                String proposal = (String)iterator.next();
                if (proposal.toLowerCase().contains(lastValue.toLowerCase())) continue;
                iterator.remove();
            }
        }
        final String existingValues = contents.substring(0, contents.length() - lastValue.length());
        ImmutableList sortedProposals = FluentIterable.from(filteredProposals).toSortedList((Comparator)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER));
        return (IContentProposal[])FluentIterable.from((Iterable)sortedProposals).transform((Function)new Function<String, IContentProposal>(){

            public IContentProposal apply(String proposal) {
                return new ContentProposal(String.valueOf(existingValues) + proposal, proposal, null);
            }
        }).toArray(IContentProposal.class);
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }
}

