/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.sasheditor;

import com.google.common.base.Objects;
import com.google.common.io.Resources;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelProviderManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;

public class SashModel
extends EMFLogicalModel
implements IModel {
    public static final String PROPERTY_PRIVATE_RESOURCE_URI = "privateResourceURI";
    public static final String PROPERTY_SHARED_RESOURCE_URI = "sharedResourceURI";
    public static final String PROPERTY_LEGACY_MODE = "legacyMode";
    private final PropertyChangeSupport bean = new PropertyChangeSupport(this);
    private SashModelProviderManager providerManager;
    private Adapter sashModelStorageAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (SashModel.this.getResources().contains(msg.getNotifier())) {
                switch (msg.getFeatureID(Resource.class)) {
                    case 2: {
                        SashModel.this.invalidateLegacyMode();
                    }
                }
            }
        }
    };
    private volatile Boolean legacyMode;
    @Deprecated
    public static final String MODEL_FILE_EXTENSION = "di";
    public static final String SASH_MODEL_FILE_EXTENSION = "sash";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel";

    @Override
    protected String getModelFileExtension() {
        if (this.isLegacy(this.resourceURI == null ? this.resourceURI : this.resourceURI.trimFileExtension())) {
            return MODEL_FILE_EXTENSION;
        }
        return SASH_MODEL_FILE_EXTENSION;
    }

    @Override
    public void init(ModelSet modelSet) {
        super.init(modelSet);
        this.providerManager = new SashModelProviderManager(modelSet);
    }

    @Override
    public void unload() {
        if (this.providerManager != null) {
            this.providerManager.dispose();
            this.providerManager = null;
        }
        this.getResources().forEach(res -> {
            boolean bl = res.eAdapters().remove((Object)this.sashModelStorageAdapter);
        });
        super.unload();
    }

    @Override
    protected boolean isRelatedResource(Resource resource) {
        boolean result = false;
        if (resource != null) {
            result = resource == this.getResource() ? true : resource.getURI().equals(this.getPrivateResourceURI()) || resource.getURI().equals(this.getSharedResourceURI());
        }
        return result;
    }

    @Override
    protected void configureResource(Resource resourceToConfigure) {
        super.configureResource(resourceToConfigure);
        if (resourceToConfigure != null) {
            resourceToConfigure.eAdapters().add((Object)this.sashModelStorageAdapter);
        }
    }

    @Override
    public String getIdentifier() {
        return MODEL_ID;
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        URI sashModelURI;
        this.resourceURI = sashModelURI = this.getSashModelURI(uriWithoutExtension);
        try {
            super.loadModel(sashModelURI.trimFileExtension());
        }
        catch (Exception ex) {
            Resource resource = this.getModelManager().getResource(sashModelURI, false);
            if (resource != null) {
                resource.unload();
                resource.getResourceSet().getResources().remove((Object)resource);
            }
            this.createModel(uriWithoutExtension);
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
    }

    @Override
    public void createModel(URI uriWithoutExtension) {
        if (!this.isLegacy(uriWithoutExtension)) {
            URI sashURI = this.getSashModelStoreURI(uriWithoutExtension);
            try {
                this.intantiateTemplate(sashURI);
                this.loadModel(uriWithoutExtension);
            }
            catch (IOException e) {
                Activator.log.error("Failed to initialize workspace private sash model", (Throwable)e);
                super.createModel(sashURI.trimFileExtension());
            }
        } else {
            super.createModel(uriWithoutExtension);
        }
    }

    void intantiateTemplate(URI sashResourceURI) throws IOException {
        block10: {
            Throwable throwable = null;
            Object var3_4 = null;
            try (OutputStream output = this.getModelManager().getURIConverter().createOutputStream(sashResourceURI);){
                String path = "templates/model.sash";
                URL template = Activator.getDefault().getBundle().getEntry(path);
                if (template != null) {
                    Resources.copy((URL)template, (OutputStream)output);
                    break block10;
                }
                throw new IOException("Sash template URL is null for: " + path);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        URI oldPrivateURI = this.getPrivateResourceURI();
        URI oldSharedURI = this.getSharedResourceURI();
        URI newURI = this.resourceURI != null && this.isLegacy(this.resourceURI.trimFileExtension()) ? this.getLegacyURI(uriWithoutExtension) : this.getSashModelStoreURI(uriWithoutExtension);
        super.setModelURI(newURI.trimFileExtension());
        this.bean.firePropertyChange(PROPERTY_PRIVATE_RESOURCE_URI, oldPrivateURI, this.getPrivateResourceURI());
        this.bean.firePropertyChange(PROPERTY_SHARED_RESOURCE_URI, oldSharedURI, this.getSharedResourceURI());
    }

    protected boolean isLegacy(URI uriWithoutExtension) {
        if (uriWithoutExtension == null) {
            return false;
        }
        URI legacy = this.getLegacyURI(uriWithoutExtension);
        URI sash = this.getSashModelURI(uriWithoutExtension);
        return Objects.equal((Object)legacy, (Object)sash);
    }

    protected URI getSashModelURI(URI uriWithoutExtension) {
        URI legacyURI;
        URIConverter converter = this.getModelManager().getURIConverter();
        if (converter.exists(legacyURI = this.getLegacyURI(uriWithoutExtension), Collections.emptyMap())) {
            try {
                Resource diResource = this.getModelManager().getResource(legacyURI, true);
                if (DiUtils.lookupSashWindowsMngr((Resource)diResource) != null) {
                    return legacyURI;
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        URI preferenceStoreURI = this.getSashModelStoreURI(uriWithoutExtension);
        return preferenceStoreURI;
    }

    protected URI getLegacyURI(URI uriWithoutExtension) {
        return uriWithoutExtension.appendFileExtension(MODEL_FILE_EXTENSION);
    }

    protected URI getSashModelStoreURI(URI uriWithoutExtension) {
        URI fullURI = uriWithoutExtension.appendFileExtension(SASH_MODEL_FILE_EXTENSION);
        return this.providerManager.getSashModelProvider(fullURI).getSashModelURI(fullURI);
    }

    @Override
    protected Map<Object, Object> getSaveOptions() {
        Map<Object, Object> saveOptions = super.getSaveOptions();
        saveOptions.put("USE_XMI_TYPE", Boolean.FALSE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public boolean isLegacyMode() {
        if (this.legacyMode == null) {
            this.legacyMode = false;
            URI sharedURI = this.getSharedResourceURI();
            if (sharedURI != null) {
                for (Resource next : this.getResources()) {
                    if (!sharedURI.equals(next.getURI())) continue;
                    this.legacyMode = DiUtils.lookupSashWindowsMngr((Resource)next) != null;
                    break;
                }
            }
        }
        return this.legacyMode;
    }

    void invalidateLegacyMode() {
        boolean oldValue = this.isLegacyMode();
        this.legacyMode = null;
        boolean newValue = this.isLegacyMode();
        if (oldValue != newValue) {
            this.bean.firePropertyChange(PROPERTY_LEGACY_MODE, oldValue, newValue);
        }
    }

    public URI getPrivateResourceURI() {
        URI modelURI = this.getModelManager() == null ? null : this.getModelManager().getURIWithoutExtension();
        return modelURI == null ? null : this.getSashModelStoreURI(modelURI);
    }

    public URI getSharedResourceURI() {
        URI modelURI = this.getModelManager() == null ? null : this.getModelManager().getURIWithoutExtension();
        return modelURI == null ? null : modelURI.appendFileExtension(MODEL_FILE_EXTENSION);
    }

    @Override
    protected boolean isRootElement(EObject object) {
        return super.isRootElement(object) && (object instanceof SashWindowsMngr || object instanceof ArchitectureDescriptionPreferences);
    }

    @Override
    protected boolean isSupportedRoot(EObject object) {
        return DiPackage.Literals.SASH_WINDOWS_MNGR.isInstance((Object)object) || ArchitecturePackage.Literals.ARCHITECTURE_DESCRIPTION_PREFERENCES.isInstance((Object)object);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.bean.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.bean.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bean.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bean.removePropertyChangeListener(propertyName, listener);
    }
}

