/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.infra.tools.spi.IExecutorServiceFactory;
import org.eclipse.papyrus.infra.tools.util.IExecutorService;
import org.eclipse.papyrus.infra.tools.util.IProgressCallable;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class DelegatingUIExecutorService
implements IExecutorService,
ServiceTrackerCustomizer<IExecutorServiceFactory, IExecutorService> {
    private final BundleContext context;
    private final ServiceTracker<IExecutorServiceFactory, IExecutorService> tracker;
    private ExecutorService delegate;

    DelegatingUIExecutorService(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, IExecutorServiceFactory.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
        this.delegate = (ExecutorService)this.tracker.getService();
        if (this.delegate == null) {
            this.delegate = Executors.newSingleThreadExecutor();
        }
    }

    synchronized void shutdown(BundleContext context) {
        if (context == this.context) {
            if (this.delegate != null) {
                this.delegate.shutdown();
                this.delegate = null;
            }
            this.tracker.close();
        }
    }

    public synchronized IExecutorService addingService(ServiceReference<IExecutorServiceFactory> reference) {
        IExecutorService result = ((IExecutorServiceFactory)this.context.getService(reference)).createExecutor();
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
        this.delegate = result;
        return result;
    }

    public synchronized void removedService(ServiceReference<IExecutorServiceFactory> reference, IExecutorService service) {
        this.context.ungetService(reference);
        if (service == this.delegate) {
            this.delegate.shutdown();
            this.delegate = Executors.newSingleThreadExecutor();
        }
    }

    public void modifiedService(ServiceReference<IExecutorServiceFactory> reference, IExecutorService service) {
    }

    @Override
    public void shutdown() {
        throw new IllegalStateException("Executor is shared");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException("Executor is shared");
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void syncExec(Runnable task) throws InterruptedException, ExecutionException {
        if (this.delegate instanceof IExecutorService) {
            ((IExecutorService)this.delegate).syncExec(task);
        } else {
            Future<?> future = this.delegate.submit(task);
            future.get();
        }
    }

    @Override
    public <V> V syncCall(Callable<V> callable) throws InterruptedException, ExecutionException {
        if (this.delegate instanceof IExecutorService) {
            return ((IExecutorService)this.delegate).syncCall(callable);
        }
        Future<V> future = this.delegate.submit(callable);
        return future.get();
    }

    @Override
    public Future<?> submit(IProgressRunnable task) {
        if (this.delegate instanceof IExecutorService) {
            return ((IExecutorService)this.delegate).submit(task);
        }
        return this.delegate.submit(() -> task.run((IProgressMonitor)new NullProgressMonitor()));
    }

    @Override
    public <V> Future<V> submit(IProgressCallable<V> callable) {
        if (this.delegate instanceof IExecutorService) {
            return ((IExecutorService)this.delegate).submit(callable);
        }
        return this.delegate.submit(() -> callable.call((IProgressMonitor)new NullProgressMonitor()));
    }

    @Override
    public void syncExec(IProgressRunnable task) throws InterruptedException, ExecutionException {
        if (this.delegate instanceof IExecutorService) {
            ((IExecutorService)this.delegate).syncExec(task);
        } else {
            Future<?> future = this.delegate.submit(() -> task.run((IProgressMonitor)new NullProgressMonitor()));
            future.get();
        }
    }

    @Override
    public <V> V syncCall(IProgressCallable<V> callable) throws InterruptedException, ExecutionException {
        if (this.delegate instanceof IExecutorService) {
            return ((IExecutorService)this.delegate).syncCall(callable);
        }
        Future<Object> future = this.delegate.submit(() -> callable.call((IProgressMonitor)new NullProgressMonitor()));
        return (V)future.get();
    }
}

