/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class NameResolutionHelper
implements INameResolutionHelper {
    protected Namespace scope;
    protected EClass filter;
    protected Map<String, List<NamedElement>> allNames;
    private static final String EMPTY_STRING = "";

    public NameResolutionHelper(Element element, EClass filter) {
        Object space = null;
        space = element instanceof Namespace ? (Namespace)element : (element instanceof NamedElement ? ((NamedElement)element).getNamespace() : element.getNearestPackage());
        this.init((Namespace)space, filter);
    }

    public NameResolutionHelper(Namespace scope, EClass filter) {
        this.init(scope, filter);
    }

    protected void init(Namespace scope, EClass filter) {
        Assert.isNotNull((Object)scope);
        if (filter == null) {
            filter = UMLPackage.eINSTANCE.getNamedElement();
        }
        this.scope = scope;
        this.filter = filter;
    }

    @Deprecated
    public List<NamedElement> getNamedElements(String name) {
        ArrayList<NamedElement> returnedValues = new ArrayList<NamedElement>();
        List<Object> obj = this.getElementsByName(name);
        for (Object current : obj) {
            if (!(current instanceof NamedElement)) continue;
            returnedValues.add((NamedElement)current);
        }
        return returnedValues;
    }

    protected void computeAllNames() {
        List<NamedElement> l;
        this.computeNames(EMPTY_STRING, this.scope, true);
        Namespace enclosingNamespace = this.scope.getNamespace();
        String prefix = EMPTY_STRING;
        while (enclosingNamespace != null) {
            prefix = EMPTY_STRING;
            this.computeNames(prefix, enclosingNamespace, false);
            enclosingNamespace = enclosingNamespace.getNamespace();
        }
        Model model = this.scope.getModel();
        if (model == null) {
            model = this.scope;
        }
        if (this.filter.isSuperTypeOf(model.eClass()) && (l = this.allNames.get(model.getName())) == null) {
            l = new ArrayList<NamedElement>();
            l.add((NamedElement)model);
            this.allNames.put(model.getName(), l);
        }
        StringBuilder builder = new StringBuilder(model.getName());
        builder.append("::");
        this.computeNames(builder.toString(), (Namespace)model, false);
        ArrayList resources = new ArrayList(this.scope.eResource().getResourceSet().getResources());
        for (Resource resource : resources) {
            List<NamedElement> l2;
            if (resource == this.scope.eResource() || !(resource instanceof UMLResource)) continue;
            UMLResource umlResource = (UMLResource)resource;
            Model root = null;
            TreeIterator i = umlResource.getAllContents();
            while (i.hasNext() && root == null) {
                EObject next = (EObject)i.next();
                if (!(next instanceof Model)) continue;
                root = (Model)next;
            }
            if (root == null) continue;
            if (this.filter.isSuperTypeOf(root.eClass()) && (l2 = this.allNames.get(root.getName())) == null) {
                l2 = new ArrayList<NamedElement>();
                l2.add((NamedElement)root);
                this.allNames.put(root.getName(), l2);
            }
            StringBuilder builder2 = new StringBuilder(root.getName());
            builder2.append("::");
            this.computeNames(builder2.toString(), (Namespace)root, false);
        }
    }

    protected void computeNames(String prefix, Namespace scope, boolean ignoreAlreadyFoundNames) {
        this.computeNames(prefix, scope, ignoreAlreadyFoundNames, new HashSet<Namespace>());
    }

    protected void computeNames(String prefix, Namespace scope, boolean ignoreAlreadyFoundNames, Set<Namespace> alreadyComputedNamespace) {
        alreadyComputedNamespace.add(scope);
        Set<Object> preExistingKeys = ignoreAlreadyFoundNames ? new HashSet() : this.allNames.keySet();
        for (NamedElement member : scope.getMembers()) {
            EList memberNames = scope.getNamesOfMember(member);
            for (String memberName : memberNames) {
                if (!(preExistingKeys.contains(String.valueOf(prefix) + memberName) && this.allNames.get(String.valueOf(prefix) + memberName).contains(member) || !this.filter.isSuperTypeOf(member.eClass()))) {
                    List<NamedElement> l = this.getNamedElements(String.valueOf(prefix) + memberName);
                    l.add(member);
                    this.allNames.put(String.valueOf(prefix) + memberName, l);
                }
                if (!(member instanceof Namespace) || alreadyComputedNamespace.contains(member)) continue;
                StringBuilder newPrefix = new StringBuilder(prefix);
                newPrefix.append(memberName);
                newPrefix.append("::");
                this.computeNames(newPrefix.toString(), (Namespace)member, false, alreadyComputedNamespace);
            }
        }
    }

    @Deprecated
    public List<String> getShortestQualifiedNames(NamedElement namedElement) {
        return this.getShortestQualifiedNames(namedElement, true);
    }

    public List<String> getShortestQualifiedNames(NamedElement namedElement, boolean manageDusplicate) {
        return NameResolutionUtils.getShortestQualifiedNames(namedElement, this.scope, manageDusplicate);
    }

    public List<Object> getMatchingElements(String aString) {
        if (this.allNames == null) {
            this.allNames = new HashMap<String, List<NamedElement>>();
            this.computeAllNames();
        }
        HashSet elements = new HashSet();
        for (Map.Entry<String, List<NamedElement>> current : this.allNames.entrySet()) {
            if (aString != null && !aString.isEmpty() && !current.getKey().startsWith(aString)) continue;
            elements.addAll(current.getValue());
        }
        return new ArrayList<Object>(elements);
    }

    public List<Object> getElementsByName(String aString) {
        if (this.allNames == null) {
            this.allNames = new HashMap<String, List<NamedElement>>();
            this.computeAllNames();
        }
        List<NamedElement> namedElements = this.allNames.get(aString);
        List<Object> returnedValues = null;
        if (namedElements != null && namedElements.size() > 0) {
            returnedValues = new ArrayList<NamedElement>(namedElements);
        }
        return returnedValues != null ? returnedValues : Collections.emptyList();
    }

    public List<String> getShortestQualifiedNames(Object element) {
        return this.getShortestQualifiedNames(element, true);
    }

    public List<String> getShortestQualifiedNames(Object element, boolean manageDuplicate) {
        if (element instanceof NamedElement) {
            return this.getShortestQualifiedNames((NamedElement)element, manageDuplicate);
        }
        return null;
    }
}

