/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.Collection;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class NamedElementUtil {
    public static final String COPY_OF = "CopyOf";
    public static final String QUALIFIED_NAME_SEPARATOR = "::";
    private static final String PUBLIC_STRING = "+";
    private static final String PROTECTED_STRING = "#";
    private static final String PRIVATE_STRING = "-";
    private static final String PACKAGE_STRING = "~";
    private static final UMLSwitch<Boolean> IS_AUTONAMED = NamedElementUtil.getIsAutoNamedSwitch();

    public static int getQualifiedNameMaxDepth(NamedElement namedElement) {
        int d = 0;
        String s = namedElement.getQualifiedName();
        if (s == null) {
            return 0;
        }
        int n = 0;
        while ((n = s.indexOf(QUALIFIED_NAME_SEPARATOR, n)) != -1) {
            n += 2;
            ++d;
        }
        return d;
    }

    public static String getDefaultNameWithIncrement(EObject newElement) {
        if (newElement.eContainer() != null) {
            return NamedElementUtil.getDefaultNameWithIncrement(newElement, newElement.eContainer().eContents());
        }
        return null;
    }

    public static String getDefaultNameWithIncrement(EObject newElement, Collection<?> contents) {
        return NamedElementUtil.getDefaultNameWithIncrement("", newElement, contents);
    }

    public static String getDefaultCopyNameWithIncrement(NamedElement namedElement, Collection<?> contents) {
        String rootName = Strings.emptyToNull((String)namedElement.getName());
        if (rootName != null) {
            for (Object o : contents) {
                String name;
                if (!(o instanceof EObject) || !rootName.equals(name = EMFCoreUtil.getName((EObject)((EObject)o)))) continue;
                String newName = NLS.bind((String)"CopyOf_{0}_", (Object)rootName);
                return NamedElementUtil.getDefaultNameWithIncrementFromBase(newName, contents);
            }
        }
        return rootName;
    }

    public static String getDefaultNameWithIncrement(String prefix, EObject newElement, Collection<?> contents) {
        if (prefix == null) {
            prefix = "";
        }
        return NamedElementUtil.getDefaultNameWithIncrementFromBase(String.valueOf(prefix) + newElement.eClass().getName(), contents, newElement, "");
    }

    public static String getDefaultNameWithIncrementFromBase(String base, Collection<?> contents) {
        return NamedElementUtil.getDefaultNameWithIncrementFromBase(base, contents, null, "");
    }

    public static String getDefaultNameWithIncrementFromBase(String base, Collection<?> contents, EObject elementToRename, String separator) {
        return elementToRename != null ? (String)((Optional)NamedElementUtil.getDefaultNameSwitch(base, contents, separator).doSwitch(elementToRename)).orNull() : NamedElementUtil.computeDefaultNameWithIncrementFromBase(base, contents, elementToRename, separator);
    }

    private static UMLSwitch<Optional<String>> getDefaultNameSwitch(final String base, final Collection<?> contents, final String separator) {
        return new UMLSwitch<Optional<String>>(){

            public Optional<String> defaultCase(EObject object) {
                return Optional.fromNullable((Object)NamedElementUtil.computeDefaultNameWithIncrementFromBase(base, contents, object, separator));
            }

            public Optional<String> casePseudostate(Pseudostate object) {
                String base2 = object.getKind().getLiteral();
                base2 = String.valueOf(base2.substring(0, 1).toUpperCase()) + base2.substring(1);
                return Optional.fromNullable((Object)NamedElementUtil.computeDefaultNameWithIncrementFromBase(base2, contents, (EObject)object, separator));
            }

            public Optional<String> caseRelationship(Relationship object) {
                return Optional.absent();
            }

            public Optional<String> caseAssociation(Association object) {
                return Optional.absent();
            }

            public Optional<String> caseAssociationClass(AssociationClass object) {
                return this.defaultCase((EObject)object);
            }

            public Optional<String> caseActivityEdge(ActivityEdge object) {
                return Optional.absent();
            }

            public Optional<String> caseTransition(Transition object) {
                return Optional.absent();
            }

            public Optional<String> caseGeneralOrdering(GeneralOrdering object) {
                return Optional.absent();
            }
        };
    }

    private static UMLSwitch<Boolean> getIsAutoNamedSwitch() {
        return new UMLSwitch<Boolean>(){

            public Boolean defaultCase(EObject object) {
                return Boolean.TRUE;
            }

            public Boolean caseRelationship(Relationship object) {
                return Boolean.FALSE;
            }

            public Boolean caseAssociation(Association object) {
                return Boolean.FALSE;
            }

            public Boolean caseAssociationClass(AssociationClass object) {
                return Boolean.TRUE;
            }

            public Boolean caseActivityEdge(ActivityEdge object) {
                return Boolean.FALSE;
            }

            public Boolean caseTransition(Transition object) {
                return Boolean.FALSE;
            }

            public Boolean caseGeneralOrdering(GeneralOrdering object) {
                return Boolean.FALSE;
            }
        };
    }

    public static boolean isAutoNamed(EObject element) {
        return (Boolean)IS_AUTONAMED.doSwitch(element);
    }

    static String computeDefaultNameWithIncrementFromBase(String base, Collection<?> contents, EObject elementToRename, String separator) {
        if (elementToRename != null) {
            if (!NamedElementUtil.isAutoNamed(elementToRename)) {
                return null;
            }
            if (contents.contains(elementToRename)) {
                NamedElement namedElement;
                ENamedElement eNamedElement;
                if (elementToRename instanceof ENamedElement && (eNamedElement = (ENamedElement)elementToRename).getName() != null) {
                    return eNamedElement.getName();
                }
                if (elementToRename instanceof NamedElement && (namedElement = (NamedElement)elementToRename).getName() != null) {
                    return namedElement.getName();
                }
            }
        }
        int nextNumber = 1;
        if ("property".equalsIgnoreCase(base)) {
            base = "Attribute";
        }
        for (Object o : contents) {
            String name;
            if (!(o instanceof EObject) || o == elementToRename || (name = EMFCoreUtil.getName((EObject)((EObject)o))) == null || !name.startsWith(base)) continue;
            String end = name.substring(base.length());
            int nextNumberTmp = 1;
            try {
                nextNumberTmp = Integer.parseInt(end) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (nextNumberTmp <= nextNumber) continue;
            nextNumber = nextNumberTmp;
        }
        return String.valueOf(base) + separator + nextNumber;
    }

    public static String getVisibilityAsSign(NamedElement element) {
        String vKindValue = "";
        switch (element.getVisibility().getValue()) {
            case 0: {
                vKindValue = PUBLIC_STRING;
                break;
            }
            case 1: {
                vKindValue = PRIVATE_STRING;
                break;
            }
            case 3: {
                vKindValue = PACKAGE_STRING;
                break;
            }
            case 2: {
                vKindValue = PROTECTED_STRING;
            }
        }
        return vKindValue;
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(QUALIFIED_NAME_SEPARATOR) + QUALIFIED_NAME_SEPARATOR.length());
        return name != null ? name : "";
    }

    public static String getParentQualifiedName(String childQualifiedName) {
        String childName = NamedElementUtil.getNameFromQualifiedName(childQualifiedName);
        String parentQualifiedName = childQualifiedName.substring(0, childQualifiedName.length() - (QUALIFIED_NAME_SEPARATOR.length() + childName.length()));
        return parentQualifiedName != null ? parentQualifiedName : "";
    }

    public static String getName(NamedElement element) {
        if (element.getName() != null) {
            return element.getName();
        }
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)element);
    }
}

