/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.JarArchiver;
import org.eclipse.persistence.tools.dbws.Util;

public class WarArchiver
extends JarArchiver {
    static final String DEFAULT_WAR_FILENAME = "dbws.war";

    public WarArchiver() {
    }

    public WarArchiver(DBWSPackager packager) {
        super(packager);
    }

    @Override
    public void setFilename(String jarFilename) {
        if (!jarFilename.endsWith(".war")) {
            jarFilename = jarFilename + ".war";
        }
        this.jarFilename = jarFilename;
    }

    @Override
    protected JarEntry getOrJarEntry() {
        return new JarEntry("WEB-INF/classes" + org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1] + "eclipselink-dbws-or.xml");
    }

    @Override
    protected JarEntry getOxJarEntry() {
        return new JarEntry("WEB-INF/classes" + org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1] + "eclipselink-dbws-ox.xml");
    }

    @Override
    protected JarEntry getSchemaJarEntry() {
        return new JarEntry("WEB-INF/wsdl/eclipselink-dbws-schema.xsd");
    }

    @Override
    protected JarEntry getServiceJarEntry() {
        return new JarEntry("WEB-INF/classes" + org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1] + "eclipselink-dbws.xml");
    }

    @Override
    protected JarEntry getSessionsJarEntry() {
        return new JarEntry("WEB-INF/classes" + org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1] + this.packager.getSessionsFileName());
    }

    @Override
    protected JarEntry getSWARefJarEntry() {
        return new JarEntry("WEB-INF/wsdl/" + Util.SWAREF_FILENAME);
    }

    @Override
    public String getOrProjectPathPrefix() {
        return org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1];
    }

    @Override
    public String getOxProjectPathPrefix() {
        return org.eclipse.persistence.internal.xr.Util.META_INF_PATHS[1];
    }

    protected ZipEntry getWebXmlJarEntry() {
        return new JarEntry("WEB-INF/web.xml");
    }

    protected ZipEntry getDBWSProviderClassJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/DBWSProvider.class");
    }

    protected ZipEntry getDBWSProviderSourceJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/DBWSProvider.java");
    }

    protected ZipEntry getProviderListenerSourceJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/ProviderListener.java");
    }

    protected ZipEntry getProviderListenerClassJarEntry() {
        return new JarEntry("WEB-INF/classes/_dbws/ProviderListener.class");
    }

    protected ZipEntry getWSDLJarEntry() {
        return new JarEntry("WEB-INF/wsdl/eclipselink-dbws.wsdl");
    }

    protected ZipEntry getDeploymentDescriptorJarEntry(String descriptorFileName) {
        return new JarEntry("WEB-INF/" + descriptorFileName);
    }

    @Override
    protected JarOutputStream buildJarOutputStream() {
        JarOutputStream jarOutputStream = null;
        try {
            if (this.jarFilename == null || this.jarFilename.length() == 0) {
                this.jarFilename = DEFAULT_WAR_FILENAME;
            }
            jarOutputStream = new JarOutputStream(new FileOutputStream(new File(this.packager.getStageDir(), this.jarFilename)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jarOutputStream;
    }

    @Override
    protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
        super.addFilesToJarOutputStream(jarOutputStream);
        try {
            int read;
            jarOutputStream.putNextEntry(this.getWebXmlJarEntry());
            this.f = new File(this.packager.getStageDir(), "web.xml");
            this.fis = new FileInputStream(this.f);
            int read2 = 0;
            while (read2 != -1) {
                jarOutputStream.write(this.buffer, 0, read2);
                read2 = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            String deploymentDescriptorFileName = this.packager.getDeploymentDescriptorFileName();
            if (deploymentDescriptorFileName != null) {
                this.f = new File(this.packager.getStageDir(), deploymentDescriptorFileName);
                jarOutputStream.putNextEntry(this.getDeploymentDescriptorJarEntry(deploymentDescriptorFileName));
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
            }
            jarOutputStream.putNextEntry(this.getDBWSProviderClassJarEntry());
            this.f = new File(this.packager.getStageDir(), "DBWSProvider.class");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            this.f = new File(this.packager.getStageDir(), "DBWSProvider.java");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getDBWSProviderSourceJarEntry());
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            this.f = new File(this.packager.getStageDir(), "ProviderListener.java");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getProviderListenerSourceJarEntry());
                this.fis = new FileInputStream(this.f);
                read = 0;
                while (read != -1) {
                    jarOutputStream.write(this.buffer, 0, read);
                    read = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getProviderListenerClassJarEntry());
            this.f = new File(this.packager.getStageDir(), "ProviderListener.class");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getWSDLJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.wsdl");
            this.fis = new FileInputStream(this.f);
            read = 0;
            while (read != -1) {
                jarOutputStream.write(this.buffer, 0, read);
                read = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

