/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPResourceMarkerAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.IModelProvider;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IExtendedStorageEditorInput;

public class LocalStorageModelProvider
extends StorageDocumentProvider
implements IModelProvider {
    private static LocalStorageModelProvider fInstance = null;
    private IElementStateListener fInternalListener;
    private Map<IEditorInput, ModelInfo> fModelInfoMap = new HashMap<IEditorInput, ModelInfo>();
    private boolean fReuseModelDocument = true;

    public static synchronized LocalStorageModelProvider getInstance() {
        if (fInstance == null) {
            fInstance = new LocalStorageModelProvider();
        }
        return fInstance;
    }

    private LocalStorageModelProvider() {
        this.fInternalListener = new InternalElementStateListener();
    }

    String calculateBaseLocation(IStorageEditorInput input) {
        String location = null;
        try {
            try {
                IStorage storage = input.getStorage();
                if (storage != null) {
                    IPath storagePath = storage.getFullPath();
                    String name = storage.getName();
                    if (storagePath != null) {
                        if (!storagePath.lastSegment().equals(name)) {
                            IPath workingPath = storagePath.addTrailingSeparator();
                            location = workingPath.append(name).toString();
                        } else {
                            location = storagePath.makeAbsolute().toString();
                        }
                    }
                    if (location == null) {
                        location = name;
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (location == null) {
                    location = input.getName();
                }
            }
        }
        finally {
            if (location == null) {
                location = input.getName();
            }
        }
        return location;
    }

    String calculateID(IStorageEditorInput input) {
        boolean addHash;
        String path;
        block14: {
            path = null;
            addHash = false;
            try {
                try {
                    IStorage storage = input.getStorage();
                    if (storage != null) {
                        IPath storagePath = storage.getFullPath();
                        String name = storage.getName();
                        boolean bl = addHash = storagePath == null || storagePath.toString().equals(name);
                        if (storagePath != null) {
                            if (!storagePath.lastSegment().equals(name)) {
                                IPath workingPath = storagePath.addTrailingSeparator();
                                path = workingPath.append(name).toString();
                            } else {
                                path = storagePath.makeAbsolute().toString();
                            }
                        }
                        if (path == null) {
                            path = name;
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    if (path == null) {
                        path = "";
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (path == null) {
                    path = "";
                }
                throw throwable;
            }
            if (path == null) {
                path = "";
            }
        }
        if (addHash) {
            path = String.valueOf(input.hashCode()) + path;
        }
        return path;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        Object model = null;
        if (element instanceof IStorageEditorInput) {
            IStorageEditorInput input = (IStorageEditorInput)element;
            String contentType = this.getModel((IEditorInput)input) != null ? this.getModel((IEditorInput)input).getContentTypeIdentifier() : null;
            String ext = BreakpointRulerAction.getFileExtension((IEditorInput)((IEditorInput)element));
            IResource res = BreakpointProviderBuilder.getInstance().getResource((IEditorInput)input, contentType, ext);
            String id = input.getName();
            if (input.getStorage() != null && input.getStorage().getFullPath() != null) {
                id = input.getStorage().getFullPath().toString();
            }
            model = res != null ? new PHPResourceMarkerAnnotationModel(res, id) : new AnnotationModel();
        }
        if (model == null) {
            model = super.createAnnotationModel(element);
        }
        return model;
    }

    protected IDocument createDocument(Object element) {
        IStructuredDocument document = null;
        if (element instanceof IEditorInput) {
            ModelInfo info = this.getModelInfoFor((IEditorInput)element);
            if (info == null) {
                throw new IllegalArgumentException("no corresponding model info found");
            }
            IStructuredModel model = info.fStructuredModel;
            if (model != null) {
                block24: {
                    if (!this.fReuseModelDocument && element instanceof IStorageEditorInput) {
                        Reader reader = null;
                        IStructuredDocument innerdocument = null;
                        try {
                            CodedReaderCreator codedReaderCreator = new CodedReaderCreator(this.calculateID((IStorageEditorInput)element), Utilities.getMarkSupportedStream((InputStream)((IStorageEditorInput)element).getStorage().getContents()));
                            reader = codedReaderCreator.getCodedReader();
                            innerdocument = model.getStructuredDocument();
                            int originalLengthToReplace = innerdocument.getLength();
                            StringBuilder stringBuffer = new StringBuilder();
                            int bufferSize = 2048;
                            char[] buffer = new char[bufferSize];
                            int nRead = 0;
                            boolean eof = false;
                            while (!eof) {
                                nRead = reader.read(buffer, 0, bufferSize);
                                if (nRead == -1) {
                                    eof = true;
                                    continue;
                                }
                                stringBuffer.append(buffer, 0, nRead);
                            }
                            innerdocument.replaceText((Object)this, 0, originalLengthToReplace, stringBuffer.toString(), true);
                            model.setDirtyState(false);
                        }
                        catch (CoreException e) {
                            Logger.logException(e);
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e1) {
                                    Logger.logException(e1);
                                }
                            }
                            break block24;
                        }
                        catch (IOException e) {
                            try {
                                Logger.logException(e);
                                break block24;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException e1) {
                                        Logger.logException(e1);
                                    }
                                }
                            }
                        }
                        if (reader == null) break block24;
                        try {
                            reader.close();
                        }
                        catch (IOException e1) {
                            Logger.logException(e1);
                        }
                    }
                }
                if (document == null) {
                    document = model.getStructuredDocument();
                }
            }
        }
        return document;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (this.getModelInfoFor((IEditorInput)element) == null) {
            this.createModelInfo((IEditorInput)element);
        }
        AbstractDocumentProvider.ElementInfo info = super.createElementInfo(element);
        return info;
    }

    public void createModelInfo(IEditorInput input) {
        IStructuredModel structuredModel;
        if (this.getModelInfoFor(input) == null && (structuredModel = this.selfCreateModel(input)) != null) {
            this.createModelInfo(input, structuredModel, true);
        }
    }

    public void createModelInfo(IEditorInput input, IStructuredModel structuredModel, boolean releaseModelOnDisconnect) {
        if (this.getModelInfoFor(input) != null || this.getModelInfoFor(structuredModel) != null) {
            return;
        }
        if (input instanceof IExtendedStorageEditorInput) {
            ((IExtendedStorageEditorInput)input).addElementStateListener(this.fInternalListener);
        }
        EditorModelUtil.addFactoriesTo((IStructuredModel)structuredModel);
        ModelInfo modelInfo = new ModelInfo(structuredModel, input, releaseModelOnDisconnect);
        this.fModelInfoMap.put(input, modelInfo);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (element instanceof IEditorInput) {
            IEditorInput input = (IEditorInput)element;
            ModelInfo modelInfo = this.getModelInfoFor(input);
            this.disposeModelInfo(modelInfo);
        }
        super.disposeElementInfo(element, info);
    }

    public void disposeModelInfo(ModelInfo info) {
        if (info.fElement instanceof IStorageEditorInput) {
            if (info.fElement instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)info.fElement).removeElementStateListener(this.fInternalListener);
            }
            if (info.fShouldReleaseOnInfoDispose) {
                info.fStructuredModel.releaseFromEdit();
            }
        }
        this.fModelInfoMap.remove(info.fElement);
    }

    protected void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        this.fReuseModelDocument = false;
        super.doResetDocument(element, monitor);
        this.fReuseModelDocument = true;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        IDocumentProvider provider = null;
        if (element instanceof IEditorInput) {
            provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)element);
        }
        if (provider == null) {
            provider = new FileDocumentProvider();
        }
        provider.saveDocument(monitor, element, document, overwrite);
    }

    public IStructuredModel getModel(IEditorInput element) {
        IStructuredModel result = null;
        ModelInfo info = this.getModelInfoFor(element);
        if (info != null) {
            result = info.fStructuredModel;
        }
        return result;
    }

    public IStructuredModel getModel(Object element) {
        if (element instanceof IEditorInput) {
            return this.getModel((IEditorInput)element);
        }
        return null;
    }

    private ModelInfo getModelInfoFor(IEditorInput element) {
        ModelInfo result = this.fModelInfoMap.get(element);
        return result;
    }

    private ModelInfo getModelInfoFor(IStructuredModel structuredModel) {
        ModelInfo result = null;
        if (structuredModel != null) {
            ModelInfo[] modelInfos = this.fModelInfoMap.values().toArray(new ModelInfo[0]);
            int i = 0;
            while (i < modelInfos.length) {
                ModelInfo info = modelInfos[i];
                if (structuredModel.equals(info.fStructuredModel)) {
                    result = info;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IStructuredModel loadModel(IStorageEditorInput input) {
        return this.loadModel(input, false);
    }

    public IStructuredModel loadModel(IStorageEditorInput input, boolean logExceptions) {
        IStructuredModel model;
        block19: {
            InputStream contents;
            String id;
            block18: {
                id = this.calculateID(input);
                contents = null;
                try {
                    contents = input.getStorage().getContents();
                }
                catch (CoreException noStorageExc) {
                    if (!logExceptions) break block18;
                    Logger.logException(noStorageExc);
                }
            }
            model = null;
            try {
                try {
                    model = StructuredModelManager.getModelManager().getModelForEdit(id, contents, null);
                    model.setBaseLocation(this.calculateBaseLocation(input));
                }
                catch (IOException e) {
                    if (logExceptions) {
                        Logger.logException(e);
                    }
                    if (contents == null) break block19;
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception e2) {
                        Logger.logException(e2);
                    }
                }
            }
            finally {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException e) {
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            }
        }
        return model;
    }

    private IStructuredModel selfCreateModel(IEditorInput input) {
        return this.loadModel((IStorageEditorInput)input);
    }

    private class InternalElementStateListener
    implements IElementStateListener {
        private InternalElementStateListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
            LocalStorageModelProvider.this.fireElementContentAboutToBeReplaced(element);
        }

        public void elementContentReplaced(Object element) {
            StorageDocumentProvider.StorageInfo info;
            block23: {
                info = (StorageDocumentProvider.StorageInfo)LocalStorageModelProvider.this.getElementInfo(element);
                if (info == null) {
                    LocalStorageModelProvider.this.fireElementContentReplaced(element);
                    LocalStorageModelProvider.this.fireElementDirtyStateChanged(element, false);
                    return;
                }
                if (info.fModel != null) {
                    info.fModel.disconnect(info.fDocument);
                }
                Reader reader = null;
                IStructuredDocument innerdocument = null;
                try {
                    CodedReaderCreator codedReaderCreator = new CodedReaderCreator(LocalStorageModelProvider.this.calculateID((IStorageEditorInput)element), Utilities.getMarkSupportedStream((InputStream)((IStorageEditorInput)element).getStorage().getContents()));
                    reader = codedReaderCreator.getCodedReader();
                    innerdocument = (IStructuredDocument)info.fDocument;
                    int originalLengthToReplace = innerdocument.getLength();
                    StringBuilder stringBuffer = new StringBuilder();
                    int bufferSize = 2048;
                    char[] buffer = new char[bufferSize];
                    int nRead = 0;
                    boolean eof = false;
                    while (!eof) {
                        nRead = reader.read(buffer, 0, bufferSize);
                        if (nRead == -1) {
                            eof = true;
                            continue;
                        }
                        stringBuffer.append(buffer, 0, nRead);
                    }
                    innerdocument.replaceText((Object)this, 0, originalLengthToReplace, stringBuffer.toString(), true);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e1) {
                            Logger.logException(e1);
                        }
                    }
                    break block23;
                }
                catch (IOException e) {
                    try {
                        Logger.logException(e);
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e1) {
                                Logger.logException(e1);
                            }
                        }
                    }
                }
                if (reader == null) break block23;
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    Logger.logException(e1);
                }
            }
            if (info.fCanBeSaved) {
                info.fCanBeSaved = false;
                LocalStorageModelProvider.this.addUnchangedElementListeners(element, (AbstractDocumentProvider.ElementInfo)info);
            }
            LocalStorageModelProvider.this.fireElementContentReplaced(element);
            LocalStorageModelProvider.this.fireElementDirtyStateChanged(element, false);
            if (info.fModel != null) {
                info.fModel.connect(info.fDocument);
            }
        }

        public void elementDeleted(Object element) {
            LocalStorageModelProvider.this.fireElementDeleted(element);
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            LocalStorageModelProvider.this.fireElementDirtyStateChanged(element, isDirty);
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            LocalStorageModelProvider.this.fireElementMoved(originalElement, movedElement);
        }
    }

    private class ModelInfo {
        public IEditorInput fElement;
        public boolean fShouldReleaseOnInfoDispose;
        public IStructuredModel fStructuredModel;

        public ModelInfo(IStructuredModel structuredModel, IEditorInput element, boolean selfCreated) {
            this.fElement = element;
            this.fStructuredModel = structuredModel;
            this.fShouldReleaseOnInfoDispose = selfCreated;
        }
    }
}

