/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.php.core.ast.nodes.Bindings;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.IPHPScriptReconcilingListener;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

class OverrideIndicatorManager
implements IPHPScriptReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.php.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;

    public OverrideIndicatorManager(IAnnotationModel annotationModel) {
        Assert.isNotNull((Object)annotationModel);
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(Program ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        final HashMap annotationMap = new HashMap(50);
        if (ast.getSourceModule().isReadOnly()) {
            return;
        }
        if (!ast.getSourceModule().getScriptProject().isOnBuildpath((IModelElement)ast.getSourceModule())) {
            return;
        }
        ast.accept((Visitor)new AbstractVisitor(){

            public boolean visit(MethodDeclaration node) {
                IMethodBinding definingMethod;
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null && (definingMethod = Bindings.findOverriddenMethod((IMethodBinding)binding, (boolean)true)) != null) {
                    ITypeBinding definingType = definingMethod.getDeclaringClass();
                    String qualifiedMethodName = String.valueOf(definingType.getName()) + "." + binding.getName();
                    boolean isImplements = (1 & definingMethod.getModifiers()) != 0;
                    String text = isImplements ? Messages.format(PHPUIMessages.OverrideIndicatorManager_implements, qualifiedMethodName) : Messages.format(PHPUIMessages.OverrideIndicatorManager_overrides, qualifiedMethodName);
                    Identifier name = node.getFunction().getFunctionName();
                    Position position = new Position(name.getStart(), name.getLength());
                    OverrideIndicator indicator = new OverrideIndicator(isImplements, text, definingMethod.getKey());
                    annotationMap.put(indicator, position);
                }
                return true;
            }
        });
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void aboutToBeReconciled() {
    }

    public void reconciled(ISourceModule sourceModule, boolean forced, IProgressMonitor progressMonitor) {
        try {
            Program ast = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_YES, null);
            if (ast != null) {
                this.updateAnnotations(ast, progressMonitor);
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    @Override
    public void reconciled(Program ast, boolean forced, IProgressMonitor progressMonitor) {
        if (ast != null) {
            this.updateAnnotations(ast, progressMonitor);
        }
    }

    class OverrideIndicator
    extends Annotation {
        private boolean fIsOverwriteIndicator;
        private String fAstNodeKey;

        OverrideIndicator(boolean isOverwriteIndicator, String text, String key) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fIsOverwriteIndicator = isOverwriteIndicator;
            this.fAstNodeKey = key;
        }

        public boolean isOverwriteIndicator() {
            return this.fIsOverwriteIndicator;
        }

        public void open() {
            try {
                IModelElement modelElement = DLTKCore.create((String)this.fAstNodeKey);
                if (modelElement instanceof IMethod) {
                    IMethod method = (IMethod)modelElement;
                    int offset = method.getNameRange().getOffset();
                    int length = method.getNameRange().getLength();
                    IEditorPart editor = EditorUtility.openInEditor((Object)method, (boolean)true);
                    EditorUtility.revealInEditor((IEditorPart)editor, (int)offset, (int)length);
                } else {
                    String title = PHPUIMessages.OverrideIndicatorManager_open_error_title;
                    String message = PHPUIMessages.OverrideIndicatorManager_open_error_message;
                    MessageDialog.openError((Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Exception occurred", (Throwable)e)), PHPUIMessages.OverrideIndicatorManager_open_error_title, PHPUIMessages.OverrideIndicatorManager_open_error_messageHasLogEntry);
            }
        }
    }
}

