/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.io.IOException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.text.correction.IInvocationContext;
import org.eclipse.ui.IEditorPart;

public class AssistContext
extends TextInvocationContext
implements IInvocationContext {
    private final ISourceModule fProgram;
    private final IEditorPart fEditor;
    private Program fASTRoot;
    private final SharedASTProvider.WAIT_FLAG fWaitFlag;

    public AssistContext(ISourceModule cu, ISourceViewer sourceViewer, IEditorPart editor, int offset, int length, SharedASTProvider.WAIT_FLAG waitFlag) {
        super(sourceViewer, offset, length);
        this.fProgram = cu;
        this.fEditor = editor;
        this.fASTRoot = null;
        this.fWaitFlag = waitFlag;
    }

    public AssistContext(ISourceModule cu, ISourceViewer sourceViewer, int offset, int length, SharedASTProvider.WAIT_FLAG waitFlag) {
        this(cu, sourceViewer, null, offset, length, waitFlag);
    }

    public AssistContext(ISourceModule cu, ISourceViewer sourceViewer, IEditorPart editor, int offset, int length) {
        this(cu, sourceViewer, editor, offset, length, SharedASTProvider.WAIT_YES);
    }

    public AssistContext(ISourceModule cu, ISourceViewer sourceViewer, int offset, int length) {
        this(cu, sourceViewer, null, offset, length);
    }

    public AssistContext(ISourceModule cu, int offset, int length) {
        this(cu, null, offset, length);
    }

    @Override
    public ISourceModule getCompilationUnit() {
        return this.fProgram;
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    @Override
    public int getSelectionLength() {
        return Math.max(this.getLength(), 0);
    }

    @Override
    public int getSelectionOffset() {
        return this.getOffset();
    }

    @Override
    public Program getASTRoot() {
        if (this.fASTRoot == null) {
            try {
                this.fASTRoot = SharedASTProvider.getAST(this.fProgram, this.fWaitFlag, null);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            catch (IOException e) {
                PHPUiPlugin.log(e);
            }
            if (this.fASTRoot == null) {
                ASTParser parser = ASTParser.newParser((ISourceModule)this.fProgram);
                try {
                    this.fASTRoot = parser.createAST(null);
                }
                catch (Exception e) {
                    PHPUiPlugin.log(e);
                }
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(Program root) {
        this.fASTRoot = root;
    }

    @Override
    public ASTNode getCoveringNode() {
        NodeFinder finder = new NodeFinder(this.getOffset(), this.getLength());
        this.getASTRoot().accept((Visitor)finder);
        return finder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        NodeFinder finder = new NodeFinder(this.getOffset(), this.getLength());
        this.getASTRoot().accept((Visitor)finder);
        return finder.getCoveredNode();
    }
}

