/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.proxy.core.Activator;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.ProxyFileSystem;
import org.eclipse.remote.internal.proxy.core.commands.ChildInfosCommand;
import org.eclipse.remote.internal.proxy.core.commands.DeleteCommand;
import org.eclipse.remote.internal.proxy.core.commands.FetchInfoCommand;
import org.eclipse.remote.internal.proxy.core.commands.GetInputStreamCommand;
import org.eclipse.remote.internal.proxy.core.commands.GetOutputStreamCommand;
import org.eclipse.remote.internal.proxy.core.commands.MkdirCommand;
import org.eclipse.remote.internal.proxy.core.commands.PutInfoCommand;
import org.eclipse.remote.internal.proxy.core.messages.Messages;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ProxyFileStore
extends FileStore {
    private static Map<String, ProxyFileStore> instanceMap = new HashMap<String, ProxyFileStore>();
    private final IPath fRemotePath;
    private final URI fURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyFileStore getInstance(URI uri) {
        Map<String, ProxyFileStore> map = instanceMap;
        synchronized (map) {
            ProxyFileStore store = instanceMap.get(uri.toString());
            if (store == null) {
                store = new ProxyFileStore(uri);
                instanceMap.put(uri.toString(), store);
            }
            return store;
        }
    }

    private ProxyFileStore(URI uri) {
        this.fURI = uri;
        this.fRemotePath = RemoteServicesUtils.posixPath((String)uri.getPath());
    }

    private ProxyConnection checkConnection(IProgressMonitor monitor) throws RemoteConnectionException {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = manager.getConnectionType(this.fURI);
        if (connectionType == null) {
            throw new RemoteConnectionException(NLS.bind((String)Messages.ProxyFileStore_0, (Object)this.fURI));
        }
        try {
            IRemoteConnection connection = connectionType.getConnection(this.fURI);
            if (connection == null) {
                throw new RemoteConnectionException(NLS.bind((String)Messages.ProxyFileStore_1, (Object)this.fURI));
            }
            if (!connection.isOpen()) {
                connection.open(monitor);
                if (!connection.isOpen()) {
                    throw new RemoteConnectionException(Messages.ProxyFileStore_2);
                }
            }
            return (ProxyConnection)connection.getService(ProxyConnection.class);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException((Throwable)e);
        }
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        ChildInfosCommand command = new ChildInfosCommand(connection, this.fRemotePath.toString());
        try {
            return (IFileInfo[])command.getResult((IProgressMonitor)subMon.newChild(9));
        }
        catch (ProxyException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
        }
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IFileInfo[] infos = this.childInfos(options, (IProgressMonitor)subMon.newChild(10));
        String[] names = new String[infos.length];
        int i = 0;
        while (i < infos.length) {
            names[i] = infos[i].getName();
            ++i;
        }
        return names;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled() && info.exists()) {
            DeleteCommand command = new DeleteCommand(connection, options, this.fRemotePath.toString());
            try {
                command.getResult((IProgressMonitor)subMon.newChild(10));
            }
            catch (ProxyException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
        }
        subMon.setWorkRemaining(0);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        FetchInfoCommand command = new FetchInfoCommand(connection, this.fRemotePath.toString());
        try {
            return (IFileInfo)command.getResult((IProgressMonitor)subMon.newChild(9));
        }
        catch (ProxyException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
        }
    }

    public IFileStore getChild(String name) {
        URI uri = ProxyFileSystem.getURIFor(ProxyFileSystem.getConnectionNameFor(this.fURI), this.fRemotePath.append(name).toString());
        return ProxyFileStore.getInstance(uri);
    }

    public String getName() {
        return this.getNameFromPath(this.fRemotePath);
    }

    private String getNameFromPath(IPath path) {
        if (path.isRoot()) {
            return path.toString();
        }
        return path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.fRemotePath.isRoot()) {
            return null;
        }
        String parentPath = this.fRemotePath.toString();
        if (this.fRemotePath.segmentCount() > 0) {
            parentPath = this.fRemotePath.removeLastSegments(1).toString();
        }
        return ProxyFileStore.getInstance(ProxyFileSystem.getURIFor(ProxyFileSystem.getConnectionNameFor(this.fURI), parentPath));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)16);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        if ((options & 4) == 4) {
            IFileStore parent = this.getParent();
            if (parent != null && !parent.fetchInfo(0, (IProgressMonitor)subMon.newChild(5)).exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 272, NLS.bind((String)Messages.ProxyFileStore_3, (Object)this.fRemotePath.toString()), null));
            }
            if (subMon.isCanceled()) {
                return this;
            }
        }
        subMon.setWorkRemaining(10);
        try {
            MkdirCommand command = new MkdirCommand(connection, options, this.fRemotePath.toString());
            command.getResult((IProgressMonitor)subMon.newChild(5));
        }
        catch (Exception exception) {}
        if (!subMon.isCanceled()) {
            IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(5));
            if (!subMon.isCanceled()) {
                if (!info.exists()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 272, NLS.bind((String)Messages.ProxyFileStore_4, (Object)this.fRemotePath.toString()), null));
                }
                if (!info.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.ProxyFileStore_5, (Object)this.fRemotePath.toString()), null));
                }
            }
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled()) {
            if (!info.exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 271, NLS.bind((String)Messages.ProxyFileStore_6, (Object)this.fRemotePath.toString()), null));
            }
            if (info.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.ProxyFileStore_7, (Object)this.fRemotePath.toString()), null));
            }
            GetInputStreamCommand command = new GetInputStreamCommand(connection, options, this.fRemotePath.toString());
            try {
                return (InputStream)command.getResult((IProgressMonitor)subMon.newChild(10));
            }
            catch (ProxyException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
        }
        return null;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        IFileInfo info = this.fetchInfo(0, (IProgressMonitor)subMon.newChild(9));
        if (!subMon.isCanceled()) {
            if (info.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 276, NLS.bind((String)Messages.ProxyFileStore_7, (Object)this.fRemotePath.toString()), null));
            }
            GetOutputStreamCommand command = new GetOutputStreamCommand(connection, options, this.fRemotePath.toString());
            try {
                return (OutputStream)command.getResult((IProgressMonitor)subMon.newChild(10));
            }
            catch (ProxyException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
        }
        return null;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ProxyConnection connection = this.checkConnection((IProgressMonitor)subMon.newChild(1));
        PutInfoCommand command = new PutInfoCommand(connection, info, options, this.fRemotePath.toString());
        try {
            command.getResult((IProgressMonitor)subMon.newChild(9));
        }
        catch (ProxyException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
        }
    }

    public URI toURI() {
        return this.fURI;
    }
}

