/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.util.Map;
import org.eclipse.sphinx.emf.check.CheckValidationType;

public enum CheckValidationMode {
    FAST_ONLY{

        @Override
        public boolean shouldCheck(CheckValidationType type) {
            return type == CheckValidationType.FAST;
        }

        public String toString() {
            return CheckValidationType.FAST.toString();
        }
    }
    ,
    NORMAL_ONLY{

        @Override
        public boolean shouldCheck(CheckValidationType type) {
            return type == CheckValidationType.NORMAL;
        }

        public String toString() {
            return CheckValidationType.NORMAL.toString();
        }
    }
    ,
    EXPENSIVE_ONLY{

        @Override
        public boolean shouldCheck(CheckValidationType type) {
            return type == CheckValidationType.EXPENSIVE;
        }

        public String toString() {
            return CheckValidationType.EXPENSIVE.toString();
        }
    }
    ,
    NORMAL_AND_FAST{

        @Override
        public boolean shouldCheck(CheckValidationType type) {
            return type == CheckValidationType.NORMAL || type == CheckValidationType.FAST;
        }

        public String toString() {
            return (Object)((Object)CheckValidationType.NORMAL) + "|" + (Object)((Object)CheckValidationType.FAST);
        }
    }
    ,
    ALL{

        @Override
        public boolean shouldCheck(CheckValidationType type) {
            return true;
        }

        public String toString() {
            return "ALL";
        }
    };

    public static final String KEY = "check.mode";

    private CheckValidationMode() {
    }

    public static CheckValidationMode getFromContext(Map<Object, Object> context) {
        CheckValidationMode mode = ALL;
        if (context != null) {
            Object object2 = context.get(KEY);
            if (object2 instanceof CheckValidationMode) {
                mode = (CheckValidationMode)((Object)object2);
            } else if (object2 != null) {
                throw new IllegalArgumentException("Context object for key check.mode should be of Type " + CheckValidationMode.class.getName() + " but was " + object2.getClass().getName());
            }
        }
        return mode;
    }

    public abstract boolean shouldCheck(CheckValidationType var1);

    /* synthetic */ CheckValidationMode(String string, int n, CheckValidationMode checkValidationMode) {
        this();
    }
}

