/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.IWorkflowLaunchConfigurationConstants;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.BasicWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.util.WorkflowRunnerHelper;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class WorkflowLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected WorkflowRunnerHelper helper = new WorkflowRunnerHelper();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            String workflowAttrValue = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_WORKFLOW, IWorkflowLaunchConfigurationConstants.ATTR_WORKFLOW);
            String modelAttrValue = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_MODEL, "");
            boolean autoSaveAttrValue = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_AUTO_SAVE, true);
            Map argumentsAttrValue = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS, IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS_DEFAULT);
            Object workflow = this.helper.toWorkflowObject(workflowAttrValue);
            BasicWorkflowRunnerOperation operation = this.createWorkflowRunnerOperation(workflow);
            URI modelURI = this.helper.toModelURIObject(modelAttrValue);
            if (modelURI != null) {
                operation.getModelURIs().add(modelURI);
            }
            operation.setAutoSave(autoSaveAttrValue);
            operation.getArguments().putAll(argumentsAttrValue);
            operation.run(monitor);
        }
        catch (OperationCanceledException ex) {
            return;
        }
        catch (Throwable th) {
            System.err.println(th.getMessage());
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)th);
        }
    }

    protected BasicWorkflowRunnerOperation createWorkflowRunnerOperation(Object workflow) {
        return new BasicWorkflowRunnerOperation(Messages.operation_runWorkflow_label, workflow);
    }
}

