/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class NaiveOptimizationAlgorithm
implements Function<Collection<ILinkEvent>, Map<Integer, Long>> {
    @Override
    public Map<Integer, Long> apply(Collection<ILinkEvent> arrows) {
        HashMultiset transitions = HashMultiset.create();
        for (ILinkEvent arrow : arrows) {
            int toTid;
            int fromTid;
            ITimeGraphEntry from = arrow.getEntry();
            ITimeGraphEntry to = arrow.getDestinationEntry();
            if (!(from instanceof ControlFlowEntry) || !(to instanceof ControlFlowEntry) || (fromTid = ((ControlFlowEntry)from).getThreadId()) == (toTid = ((ControlFlowEntry)to).getThreadId())) continue;
            Pair key = new Pair((Object)Math.min(fromTid, toTid), (Object)Math.max(fromTid, toTid));
            transitions.add((Object)key);
        }
        ImmutableList sortedTransitionsByCount = Multisets.copyHighestCountFirst((Multiset)transitions).asList();
        LinkedHashMap<Integer, Long> orderedTidMap = new LinkedHashMap<Integer, Long>();
        long pos = 0L;
        for (Pair threadPair : sortedTransitionsByCount) {
            if (orderedTidMap.get(threadPair.getFirst()) == null) {
                orderedTidMap.put((Integer)threadPair.getFirst(), pos);
                ++pos;
            }
            if (orderedTidMap.get(threadPair.getSecond()) != null) continue;
            orderedTidMap.put((Integer)threadPair.getSecond(), pos);
            ++pos;
        }
        return orderedTidMap;
    }
}

