/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.SoftIrqLabelProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesEntry
extends TimeGraphEntry
implements Comparable<ITimeGraphEntry> {
    private static final Comparator<ResourcesEntry> COMPARATOR = Comparator.comparing(ResourcesEntry::getType).thenComparingInt(ResourcesEntry::getId);
    private final int fId;
    private final @NonNull ITmfTrace fTrace;
    private final Type fType;
    private final int fQuark;

    public ResourcesEntry(int quark, @NonNull ITmfTrace trace, String name, long startTime, long endTime, Type type, int id) {
        super(name, startTime, endTime);
        this.fId = id;
        this.fTrace = trace;
        this.fType = type;
        this.fQuark = quark;
    }

    public ResourcesEntry(@NonNull ITmfTrace trace, String name, long startTime, long endTime, int id) {
        this(-1, trace, name, startTime, endTime, Type.NULL, id);
    }

    public ResourcesEntry(int quark, @NonNull ITmfTrace trace, long startTime, long endTime, Type type, int id) {
        this(quark, trace, ResourcesEntry.computeEntryName(type, id), startTime, endTime, type, id);
    }

    private static String computeEntryName(Type type, int id) {
        if (Type.SOFT_IRQ.equals((Object)type)) {
            return String.valueOf(type.toString()) + ' ' + id + ' ' + SoftIrqLabelProvider.getSoftIrq(id);
        }
        return String.valueOf(type.toString()) + ' ' + id;
    }

    public int getId() {
        return this.fId;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public Type getType() {
        return this.fType;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public boolean hasTimeEvents() {
        return this.fType != Type.NULL;
    }

    @Override
    public int compareTo(ITimeGraphEntry other) {
        if (!(other instanceof ResourcesEntry)) {
            return -1;
        }
        return COMPARATOR.compare(this, (ResourcesEntry)other);
    }

    public static enum Type {
        NULL,
        CPU,
        IRQ,
        SOFT_IRQ;

    }
}

