/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternSegmentBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.w3c.dom.Element;

public class TmfXmlAction
implements ITmfXmlAction {
    private final IXmlStateSystemContainer fParent;
    private final String fId;
    private final List<ITmfXmlAction> fActionList = new ArrayList<ITmfXmlAction>();

    public TmfXmlAction(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        this.fParent = container;
        this.fId = (String)NonNullUtils.checkNotNull((Object)node.getAttribute("id"));
        List<@Nullable Element> childElements = XmlUtils.getChildElements(node);
        for (Element child : childElements) {
            @NonNull Element nonNullChild = (Element)NonNullUtils.checkNotNull((Object)child);
            switch (nonNullChild.getNodeName()) {
                case "stateChange": {
                    this.fActionList.add(new StateChange(modelFactory, nonNullChild, this.fParent));
                    break;
                }
                case "fsmScheduleAction": {
                    this.fActionList.add(new ScheduleNewScenario(modelFactory, nonNullChild, this.fParent));
                    break;
                }
                case "segment": {
                    this.fActionList.add(new GeneratePatternSegment(modelFactory, nonNullChild, this.fParent));
                    break;
                }
                case "action": {
                    this.fActionList.add(new TmfXmlAction(modelFactory, nonNullChild, this.fParent));
                    break;
                }
                default: {
                    Activator.logError("Invalid action type : " + nonNullChild.getNodeName());
                }
            }
        }
    }

    public String getId() {
        return this.fId;
    }

    @Override
    public void execute(@NonNull ITmfEvent event, TmfXmlScenarioInfo scenarioInfo) {
        for (ITmfXmlAction action : this.fActionList) {
            action.execute(event, scenarioInfo);
        }
    }

    private static class GeneratePatternSegment
    implements ITmfXmlAction {
        private final TmfXmlPatternSegmentBuilder fSegmentBuilder;
        private final XmlPatternStateProvider fProvider;

        public GeneratePatternSegment(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
            this.fProvider = (XmlPatternStateProvider)parent;
            this.fSegmentBuilder = modelFactory.createPatternSegmentBuilder(node, parent);
        }

        @Override
        public void execute(ITmfEvent event, TmfXmlScenarioInfo scenarioInfo) {
            long ts = this.fProvider.getHistoryBuilder().getStartTime(this.fProvider, scenarioInfo, event);
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)ts);
            ITmfTimestamp end = event.getTimestamp();
            this.fSegmentBuilder.generatePatternSegment(event, start, end, scenarioInfo);
        }
    }

    private static class ScheduleNewScenario
    implements ITmfXmlAction {
        public ScheduleNewScenario(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        }

        @Override
        public void execute(ITmfEvent event, TmfXmlScenarioInfo scenarioInfo) {
            throw new UnsupportedOperationException("Schedule an FSM is not yet supported");
        }
    }

    private class StateChange
    implements ITmfXmlAction {
        private final TmfXmlStateChange fStateChange;

        public StateChange(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
            this.fStateChange = modelFactory.createStateChange(node, parent);
        }

        @Override
        public void execute(@NonNull ITmfEvent event, TmfXmlScenarioInfo scenarioInfo) {
            try {
                this.fStateChange.handleEvent(event, scenarioInfo);
            }
            catch (AttributeNotFoundException | StateValueTypeException e) {
                Activator.logError("Exception when executing action state change", e);
            }
        }
    }
}

