/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.signal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalTracer;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;

public class TmfSignalManager {
    private static Map<Object, Method[]> fListeners = new HashMap<Object, Method[]>();
    private static Map<Object, Method[]> fVIPListeners = new HashMap<Object, Method[]>();
    private static Map<Object, Throwable> fContexts = new HashMap<Object, Throwable>();
    private static Multimap<@NonNull Object, @NonNull Class<? extends TmfSignal>> fOutboundSignalBlacklist = HashMultimap.create();
    private static Multimap<@NonNull Object, @NonNull Class<? extends TmfSignal>> fInboundSignalBlacklist = HashMultimap.create();
    private static final ExecutorService fExecutor = Executors.newSingleThreadExecutor();
    private static boolean fTraceIsActive = false;
    private static TmfSignalTracer fSignalTracer;
    static int fSignalId;

    static {
        if (fTraceIsActive) {
            fSignalTracer = TmfSignalTracer.getInstance();
            TmfSignalManager.register(fSignalTracer);
        }
        fSignalId = 0;
    }

    public static synchronized void register(Object listener) {
        TmfSignalManager.deregister(listener);
        Method[] methods = TmfSignalManager.getSignalHandlerMethods(listener);
        if (methods.length > 0) {
            fContexts.put(listener, new Throwable());
            fListeners.put(listener, methods);
        }
    }

    @NonNullByDefault
    public static synchronized void addIgnoredOutboundSignal(Object source, Class<? extends TmfSignal> signal) {
        fOutboundSignalBlacklist.put(source, signal);
    }

    @NonNullByDefault
    public static synchronized void addIgnoredInboundSignal(Object listener, Class<? extends TmfSignal> signal) {
        fInboundSignalBlacklist.put(listener, signal);
    }

    public static synchronized void removeIgnoredOutboundSignal(Object source, Class<? extends TmfSignal> signal) {
        fOutboundSignalBlacklist.remove(source, signal);
    }

    public static synchronized void removeIgnoredInboundSignal(Object listener, Class<? extends TmfSignal> signal) {
        fInboundSignalBlacklist.remove(listener, signal);
    }

    public static synchronized void clearIgnoredOutboundSignalList(Object source) {
        fOutboundSignalBlacklist.removeAll(source);
    }

    public static synchronized void clearIgnoredInboundSignalList(Object listener) {
        fInboundSignalBlacklist.removeAll(listener);
    }

    public static synchronized void registerVIP(Object listener) {
        TmfSignalManager.deregister(listener);
        Method[] methods = TmfSignalManager.getSignalHandlerMethods(listener);
        if (methods.length > 0) {
            fContexts.put(listener, new Throwable());
            fVIPListeners.put(listener, methods);
        }
    }

    public static synchronized void deregister(Object listener) {
        fVIPListeners.remove(listener);
        fListeners.remove(listener);
        fContexts.remove(listener);
        fInboundSignalBlacklist.removeAll(listener);
        fOutboundSignalBlacklist.removeAll(listener);
    }

    private static Method[] getSignalHandlerMethods(Object listener) {
        Method[] methods;
        ArrayList<Method> handlers = new ArrayList<Method>();
        Method[] methodArray = methods = listener.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(TmfSignalHandler.class)) {
                handlers.add(method);
            }
            ++n2;
        }
        return handlers.toArray(new Method[handlers.size()]);
    }

    public static synchronized void dispatchSignal(TmfSignal signal) {
        boolean isBlackListed;
        Object source = signal.getSource();
        if (source != null && (isBlackListed = fOutboundSignalBlacklist.get(source).stream().anyMatch(x -> x.isAssignableFrom(signal.getClass())))) {
            return;
        }
        int signalId = fSignalId++;
        TmfSignalManager.sendSignal(new TmfStartSynchSignal(signalId));
        signal.setReference(signalId);
        TmfSignalManager.sendSignal(signal);
        TmfSignalManager.sendSignal(new TmfEndSynchSignal(signalId));
    }

    public static void dispatchSignalAsync(final TmfSignal signal) {
        if (!fExecutor.isShutdown()) {
            fExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    TmfSignalManager.dispatchSignal(signal);
                }
            });
        }
    }

    public static synchronized void dispose() {
        for (Map.Entry<Object, Throwable> entry : fContexts.entrySet()) {
            StackTraceElement[] stackTrace;
            System.err.println(TmfSignalManager.getWarningMessage(entry.getKey()));
            StackTraceElement[] stackTraceElementArray = stackTrace = entry.getValue().getStackTrace();
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement elem = stackTraceElementArray[n2];
                System.err.println("\t" + elem);
                ++n2;
            }
        }
        fExecutor.shutdown();
    }

    private static String getWarningMessage(Object listener) {
        return "Resource leak: " + listener + " was not deregistered.";
    }

    private static void sendSignal(TmfSignal signal) {
        TmfSignalManager.sendSignal(fVIPListeners, signal);
        TmfSignalManager.sendSignal(fListeners, signal);
    }

    private static void sendSignal(Map<Object, Method[]> listeners, TmfSignal signal) {
        if (TmfCoreTracer.isSignalTraced()) {
            TmfCoreTracer.traceSignal(signal, "(start)");
        }
        Class<?> signalClass = signal.getClass();
        HashMap targets = new HashMap();
        targets.clear();
        for (Map.Entry<Object, Method[]> entry : listeners.entrySet()) {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            Method[] methodArray = entry.getValue();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isBlackListed;
                Method method = methodArray[n2];
                Class<?> classParam = method.getParameterTypes()[0];
                if (!(!classParam.isAssignableFrom(signalClass) || fInboundSignalBlacklist.containsKey(entry.getKey()) && (isBlackListed = fInboundSignalBlacklist.get(NonNullUtils.checkNotNull((Object)entry.getKey())).stream().anyMatch(x -> x.isAssignableFrom(classParam))))) {
                    matchingMethods.add(method);
                }
                ++n2;
            }
            if (matchingMethods.isEmpty()) continue;
            targets.put(entry.getKey(), matchingMethods);
        }
        for (Map.Entry<Object, Object> entry : targets.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                try {
                    method.invoke(entry.getKey(), signal);
                    if (!TmfCoreTracer.isSignalTraced()) continue;
                    Object key = entry.getKey();
                    String hash = String.format("%1$08X", entry.getKey().hashCode());
                    String target = "[" + hash + "] " + key.getClass().getSimpleName() + ":" + method.getName();
                    TmfCoreTracer.traceSignal(signal, target);
                }
                catch (IllegalArgumentException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
                catch (IllegalAccessException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
                catch (InvocationTargetException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
            }
        }
        if (TmfCoreTracer.isSignalTraced()) {
            TmfCoreTracer.traceSignal(signal, "(end)");
        }
    }
}

