/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.TransitiveClosureHelper;
import org.eclipse.viatra.query.runtime.base.core.EMFDataSource;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;

public class TransitiveClosureHelperImpl
extends EContentAdapter
implements TransitiveClosureHelper,
ITcObserver<EObject>,
FeatureListener,
InstanceListener {
    private IncSCCAlg<EObject> sccAlg;
    private Set<EStructuralFeature> features;
    private Set<EClass> classes;
    private EMFDataSource dataSource;
    private List<ITcObserver<EObject>> tcObservers = new ArrayList<ITcObserver<EObject>>();
    private NavigationHelper navigationHelper;
    private boolean disposeBaseIndexWhenDisposed;

    public TransitiveClosureHelperImpl(NavigationHelper navigationHelper, boolean disposeBaseIndexWhenDisposed, Set<EReference> references) {
        this.navigationHelper = navigationHelper;
        this.disposeBaseIndexWhenDisposed = disposeBaseIndexWhenDisposed;
        this.features = new HashSet<EReference>(references);
        this.classes = this.collectEClasses();
        if (!navigationHelper.isInWildcardMode()) {
            navigationHelper.registerObservedTypes(this.classes, null, this.features);
        }
        this.navigationHelper.addFeatureListener(this.features, this);
        this.navigationHelper.addInstanceListener(this.classes, this);
        this.dataSource = new EMFDataSource(navigationHelper, references, this.classes);
        this.sccAlg = new IncSCCAlg((IGraphDataSource)this.dataSource);
        this.sccAlg.attachObserver((ITcObserver)this);
    }

    private Set<EClass> collectEClasses() {
        HashSet<EClass> classes = new HashSet<EClass>();
        for (EStructuralFeature ref : this.features) {
            classes.add(ref.getEContainingClass());
            classes.add(((EReference)ref).getEReferenceType());
        }
        return classes;
    }

    public void attachObserver(ITcObserver<EObject> to) {
        this.tcObservers.add(to);
    }

    public void detachObserver(ITcObserver<EObject> to) {
        this.tcObservers.remove(to);
    }

    public Set<EObject> getAllReachableTargets(EObject source) {
        return this.sccAlg.getAllReachableTargets((Object)source);
    }

    public Set<EObject> getAllReachableSources(EObject target) {
        return this.sccAlg.getAllReachableSources((Object)target);
    }

    public boolean isReachable(EObject source, EObject target) {
        return this.sccAlg.isReachable((Object)source, (Object)target);
    }

    public void tupleInserted(EObject source, EObject target) {
        for (ITcObserver<EObject> to : this.tcObservers) {
            to.tupleInserted((Object)source, (Object)target);
        }
    }

    public void tupleDeleted(EObject source, EObject target) {
        for (ITcObserver<EObject> to : this.tcObservers) {
            to.tupleDeleted((Object)source, (Object)target);
        }
    }

    public void dispose() {
        this.sccAlg.dispose();
        this.navigationHelper.removeInstanceListener(this.classes, this);
        this.navigationHelper.removeFeatureListener(this.features, this);
        if (this.disposeBaseIndexWhenDisposed) {
            this.navigationHelper.dispose();
        }
    }

    @Override
    public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
        this.dataSource.notifyEdgeInserted(host, (EObject)value);
    }

    @Override
    public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
        this.dataSource.notifyEdgeDeleted(host, (EObject)value);
    }

    @Override
    public void instanceInserted(EClass clazz, EObject instance) {
        this.dataSource.notifyNodeInserted(instance);
    }

    @Override
    public void instanceDeleted(EClass clazz, EObject instance) {
        this.dataSource.notifyNodeDeleted(instance);
    }

    public IGraphPathFinder<EObject> getPathFinder() {
        return this.sccAlg.getPathFinder();
    }
}

