/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.highlighting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.ide.highlighting.XbaseHighlightingStyles;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class XbaseHighlightingCalculator
extends DefaultSemanticHighlightingCalculator
implements XbaseHighlightingStyles {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    protected AnnotationLookup annotationLookup;
    @Inject
    protected OperationCanceledManager operationCanceledManager;
    private Map<String, String> highlightedIdentifiers;
    private BitSet idLengthsToHighlight;
    protected static final List<String> SPECIAL_FEATURE_NAMES = Lists.newArrayList((Object[])new String[]{IFeatureNames.THIS.getFirstSegment(), IFeatureNames.SUPER.getFirstSegment(), IFeatureNames.IT.getFirstSegment(), IFeatureNames.SELF.getFirstSegment()});

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null) {
            return;
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null || parseResult.getRootASTElement() == null) {
            return;
        }
        if (this.highlightedIdentifiers == null) {
            this.highlightedIdentifiers = this.initializeHighlightedIdentifiers();
            this.idLengthsToHighlight = new BitSet();
            for (String s : this.highlightedIdentifiers.keySet()) {
                this.idLengthsToHighlight.set(s.length());
            }
        }
        if (resource.isValidationDisabled()) {
            this.highlightSpecialIdentifiers(acceptor, parseResult.getRootNode());
            return;
        }
        this.doProvideHighlightingFor(resource, acceptor, cancelIndicator);
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            throw new IllegalStateException("resource#parseResult may not be null");
        }
        ICompositeNode node = parseResult.getRootNode();
        this.highlightSpecialIdentifiers(acceptor, node);
        super.doProvideHighlightingFor(resource, acceptor, cancelIndicator);
    }

    protected boolean highlightElement(EObject object, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (object instanceof XAbstractFeatureCall) {
            if (((XAbstractFeatureCall)object).isPackageFragment()) {
                return true;
            }
            if (SPECIAL_FEATURE_NAMES.contains(((XAbstractFeatureCall)object).getConcreteSyntaxFeatureName())) {
                return false;
            }
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            this.computeFeatureCallHighlighting((XAbstractFeatureCall)object, acceptor);
        } else if (object instanceof JvmTypeParameter) {
            this.highlightTypeParameter((JvmTypeParameter)object, acceptor);
        } else if (object instanceof JvmFormalParameter) {
            this.highlightFormalParameter((JvmFormalParameter)object, acceptor);
        } else if (object instanceof XVariableDeclaration) {
            this.highlightVariableDeclaration((XVariableDeclaration)object, acceptor);
        } else if (object instanceof XNumberLiteral) {
            this.highlightNumberLiterals((XNumberLiteral)object, acceptor);
        } else if (object instanceof XConstructorCall) {
            this.highlightConstructorCall((XConstructorCall)object, acceptor);
        } else if (object instanceof XAnnotation) {
            this.highlightAnnotation((XAnnotation)object, acceptor);
        } else {
            this.computeReferencedJvmTypeHighlighting(acceptor, object, cancelIndicator);
        }
        return false;
    }

    protected void computeReferencedJvmTypeHighlighting(IHighlightedPositionAcceptor acceptor, EObject referencer, CancelIndicator cancelIndicator) {
        for (EReference reference : referencer.eClass().getEAllReferences()) {
            EClass referencedType = reference.getEReferenceType();
            if (!EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)referencedType)) continue;
            List referencedObjects = EcoreUtil2.getAllReferencedObjects((EObject)referencer, (EReference)reference);
            if (referencedObjects.size() > 0) {
                this.operationCanceledManager.checkCanceled(cancelIndicator);
            }
            for (EObject referencedObject : referencedObjects) {
                EObject resolvedReferencedObject = EcoreUtil.resolve((EObject)referencedObject, (EObject)referencer);
                if (resolvedReferencedObject == null || resolvedReferencedObject.eIsProxy()) continue;
                this.highlightReferenceJvmType(acceptor, referencer, reference, resolvedReferencedObject);
            }
        }
    }

    protected void highlightReferenceJvmType(IHighlightedPositionAcceptor acceptor, EObject referencer, EReference reference, EObject resolvedReferencedObject) {
        this.highlightReferenceJvmType(acceptor, referencer, reference, resolvedReferencedObject, "xbase.annotation");
    }

    @Deprecated
    protected void highlightReferenceJvmType(IHighlightedPositionAcceptor acceptor, EObject referencer, EReference reference, EObject resolvedReferencedObject, String highlightingConfiguration) {
        this.highlightDeprecation(acceptor, referencer, reference, resolvedReferencedObject);
        EStructuralFeature referencersContainingFeature = referencer.eContainingFeature();
        if (resolvedReferencedObject instanceof JvmTypeParameter) {
            this.highlightFeature(acceptor, referencer, (EStructuralFeature)reference, new String[]{"xbase.type.variable"});
        } else if (referencer instanceof JvmParameterizedTypeReference && (referencersContainingFeature == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__ARGUMENTS || referencersContainingFeature == TypesPackage.Literals.JVM_TYPE_CONSTRAINT__TYPE_REFERENCE || referencersContainingFeature == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__TYPE_ARGUMENTS || referencersContainingFeature == XbasePackage.Literals.XCONSTRUCTOR_CALL__TYPE_ARGUMENTS)) {
            if (resolvedReferencedObject instanceof JvmEnumerationType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, new String[]{"xbase.enum"});
            } else if (resolvedReferencedObject instanceof JvmGenericType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, new String[]{this.getStyle((JvmGenericType)resolvedReferencedObject)});
            } else if (resolvedReferencedObject instanceof JvmAnnotationType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, new String[]{highlightingConfiguration});
            }
            this.highlightFeature(acceptor, referencer, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, new String[]{"xbase.type.argument"});
        } else if (resolvedReferencedObject instanceof JvmDeclaredType) {
            if (referencer instanceof XImportDeclaration) {
                return;
            }
            if (resolvedReferencedObject instanceof JvmEnumerationType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)reference, new String[]{"xbase.enum"});
            } else if (resolvedReferencedObject instanceof JvmGenericType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)reference, new String[]{this.getStyle((JvmGenericType)resolvedReferencedObject)});
            } else if (resolvedReferencedObject instanceof JvmAnnotationType) {
                this.highlightFeature(acceptor, referencer, (EStructuralFeature)reference, new String[]{highlightingConfiguration});
            }
        }
    }

    protected void highlightDeprecation(IHighlightedPositionAcceptor acceptor, EObject referencer, EReference reference, EObject resolvedReferencedObject) {
        JvmAnnotationTarget annoTarget;
        if (resolvedReferencedObject instanceof JvmAnnotationTarget && DeprecationUtil.isDeprecated((JvmAnnotationTarget)(annoTarget = (JvmAnnotationTarget)resolvedReferencedObject))) {
            this.highlightFeature(acceptor, referencer, (EStructuralFeature)reference, new String[]{"xbase.deprecated.members"});
        }
    }

    protected void computeFeatureCallHighlighting(XAbstractFeatureCall featureCall, IHighlightedPositionAcceptor acceptor) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy()) {
            if (feature instanceof XVariableDeclaration) {
                if (!SPECIAL_FEATURE_NAMES.contains(((XVariableDeclaration)feature).getName())) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.local.variable");
                    if (!((XVariableDeclaration)feature).isWriteable()) {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.local.final.variable");
                    }
                }
            } else if (feature instanceof JvmFormalParameter) {
                if (!SPECIAL_FEATURE_NAMES.contains(((JvmFormalParameter)feature).getName())) {
                    EStructuralFeature eContainingFeature = feature.eContainingFeature();
                    if (eContainingFeature == TypesPackage.Literals.JVM_EXECUTABLE__PARAMETERS || eContainingFeature == XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS) {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.parameter.variable");
                    } else {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.local.variable");
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.local.final.variable");
                    }
                }
            } else if (feature instanceof JvmTypeParameter) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.type.variable");
            } else if (feature instanceof JvmField) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.field");
                if (((JvmField)feature).isStatic()) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.static.field");
                    if (((JvmField)feature).isFinal()) {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.static.final.field");
                    }
                }
            } else if (feature instanceof JvmOperation && !featureCall.isOperation()) {
                JvmOperation jvmOperation = (JvmOperation)feature;
                this.highlightFeatureCall(featureCall, acceptor, "xbase.method");
                if (jvmOperation.isAbstract()) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.abstract.method.invocation");
                }
                if (jvmOperation.isStatic()) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.static.method.invocation");
                }
                if (featureCall.isExtension() || this.isExtensionWithImplicitFirstArgument(featureCall)) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
                }
            } else if (feature instanceof JvmDeclaredType) {
                this.highlightReferenceJvmType(acceptor, (EObject)featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, (EObject)feature);
            }
            if (feature instanceof JvmAnnotationTarget && DeprecationUtil.isDeprecated((JvmAnnotationTarget)((JvmAnnotationTarget)feature))) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.deprecated.members");
            }
        }
    }

    protected boolean isExtensionWithImplicitFirstArgument(XAbstractFeatureCall featureCall) {
        XExpression implicitReceiver = featureCall.getImplicitReceiver();
        return implicitReceiver instanceof XAbstractFeatureCall && this.isExtension(((XAbstractFeatureCall)implicitReceiver).getFeature());
    }

    protected boolean isExtension(JvmIdentifiableElement jvmIdentifiableElement) {
        if (jvmIdentifiableElement instanceof JvmAnnotationTarget) {
            return this.annotationLookup.findAnnotation((JvmAnnotationTarget)jvmIdentifiableElement, Extension.class) != null;
        }
        return false;
    }

    protected void highlightFeatureCall(XAbstractFeatureCall featureCall, IHighlightedPositionAcceptor acceptor, String id) {
        if (featureCall.isTypeLiteral()) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)featureCall);
            this.highlightNode(acceptor, (INode)node, new String[]{id});
        } else {
            this.highlightFeature(acceptor, (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, new String[]{id});
        }
    }

    protected void highlightAnnotation(XAnnotation annotation, IHighlightedPositionAcceptor acceptor) {
        this.highlightAnnotation(annotation, acceptor, "xbase.annotation");
    }

    protected void highlightAnnotation(XAnnotation annotation, IHighlightedPositionAcceptor acceptor, String highlightingConfiguration) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType != null && !annotationType.eIsProxy() && annotationType instanceof JvmAnnotationType) {
            ILeafNode firstLeafNode;
            ICompositeNode xannotationNode = NodeModelUtils.findActualNodeFor((EObject)annotation);
            if (xannotationNode != null && (firstLeafNode = NodeModelUtils.findLeafNodeAtOffset((INode)xannotationNode, (int)xannotationNode.getOffset())) != null) {
                this.highlightNode(acceptor, (INode)firstLeafNode, new String[]{highlightingConfiguration});
            }
            this.highlightReferenceJvmType(acceptor, (EObject)annotation, XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, (EObject)annotationType, highlightingConfiguration);
        }
    }

    protected void highlightFormalParameter(JvmFormalParameter parameterDecl, IHighlightedPositionAcceptor acceptor) {
        if (!SPECIAL_FEATURE_NAMES.contains(parameterDecl.getName())) {
            if (parameterDecl.eContainingFeature() == XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS) {
                this.highlightFeature(acceptor, (EObject)parameterDecl, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, new String[]{"xbase.parameter.variable"});
            } else {
                this.highlightFeature(acceptor, (EObject)parameterDecl, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, new String[]{"xbase.local.variable.declaration"});
                this.highlightFeature(acceptor, (EObject)parameterDecl, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, new String[]{"xbase.local.final.variable.declaration"});
            }
        }
    }

    protected void highlightVariableDeclaration(XVariableDeclaration varDecl, IHighlightedPositionAcceptor acceptor) {
        if (!SPECIAL_FEATURE_NAMES.contains(varDecl.getName())) {
            this.highlightFeature(acceptor, (EObject)varDecl, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, new String[]{"xbase.local.variable.declaration"});
            if (!varDecl.isWriteable()) {
                this.highlightFeature(acceptor, (EObject)varDecl, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, new String[]{"xbase.local.final.variable.declaration"});
            }
        }
    }

    protected void highlightNumberLiterals(XNumberLiteral literal, IHighlightedPositionAcceptor acceptor) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)literal);
        ITextRegion textRegion = node.getTextRegion();
        acceptor.addPosition(textRegion.getOffset(), textRegion.getLength(), new String[]{"number"});
    }

    protected void highlightConstructorCall(XConstructorCall constructorCall, IHighlightedPositionAcceptor acceptor) {
        JvmDeclaredType declaringType;
        if (constructorCall.getConstructor() != null && !constructorCall.getConstructor().eIsProxy() && (declaringType = constructorCall.getConstructor().getDeclaringType()) instanceof JvmGenericType) {
            this.highlightFeature(acceptor, (EObject)constructorCall, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, new String[]{this.getStyle((JvmGenericType)declaringType)});
        }
    }

    protected String getStyle(JvmGenericType type) {
        if (type.isInterface()) {
            return "xbase.interface";
        }
        if (type.isAbstract()) {
            return "xbase.abstract.class";
        }
        return "xbase.class";
    }

    protected void highlightTypeParameter(JvmTypeParameter typeParameter, IHighlightedPositionAcceptor acceptor) {
        this.highlightFeature(acceptor, (EObject)typeParameter, (EStructuralFeature)TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME, new String[]{"xbase.type.variable"});
    }

    protected void highlightSpecialIdentifiers(IHighlightedPositionAcceptor acceptor, ICompositeNode root) {
        TerminalRule idRule = this.getIDRule();
        for (ILeafNode leaf : root.getLeafNodes()) {
            if (leaf.isHidden()) continue;
            this.highlightSpecialIdentifiers(leaf, acceptor, idRule);
        }
    }

    protected TerminalRule getIDRule() {
        return this.grammarAccess.getIDRule();
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        String text;
        String highlightingID;
        EObject element;
        ITextRegion leafRegion = leafNode.getTextRegion();
        if (this.idLengthsToHighlight.get(leafRegion.getLength()) && ((element = leafNode.getGrammarElement()) == idRule || element instanceof RuleCall && ((RuleCall)element).getRule() == idRule) && (highlightingID = this.highlightedIdentifiers.get(text = leafNode.getText())) != null) {
            acceptor.addPosition(leafRegion.getOffset(), leafRegion.getLength(), new String[]{highlightingID});
        }
    }

    protected Map<String, String> initializeHighlightedIdentifiers() {
        HashMap result = Maps.newHashMap();
        for (Primitives.Primitive p : Primitives.Primitive.values()) {
            result.put(p.name().toLowerCase(), "keyword");
        }
        for (String name : SPECIAL_FEATURE_NAMES) {
            result.put(name, "keyword");
        }
        return result;
    }
}

