/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.swarm.GlobalService;
import com.spotify.docker.client.messages.swarm.ReplicatedService;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ServiceMode {
    @JsonProperty(value="Replicated")
    private ReplicatedService replicated;
    @JsonProperty(value="Global")
    private GlobalService global;

    public ReplicatedService replicated() {
        return this.replicated;
    }

    public GlobalService global() {
        return this.global;
    }

    public static ServiceMode withReplicas(long replicas) {
        return ServiceMode.builder().withReplicatedService(ReplicatedService.builder().withReplicas(replicas).build()).build();
    }

    public static ServiceMode withGlobal() {
        return ServiceMode.builder().withGlobalService(new GlobalService()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMode that = (ServiceMode)o;
        return Objects.equals(this.replicated, that.replicated) && Objects.equals(this.global, that.global);
    }

    public int hashCode() {
        return Objects.hash(this.replicated, this.global);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("replicated", (Object)this.replicated).add("global", (Object)this.global).toString();
    }

    public static class Builder {
        private ServiceMode mode = new ServiceMode();

        public Builder withReplicatedService(ReplicatedService replicated) {
            this.mode.replicated = replicated;
            return this;
        }

        public Builder withGlobalService(GlobalService global) {
            this.mode.global = global;
            return this;
        }

        public ServiceMode build() {
            return this.mode;
        }
    }
}

