/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ImagePainter;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image uncheckedImg;

    public CheckBoxPainter() {
        this.checkedImg = GUIHelper.getImage("checked");
        this.uncheckedImg = GUIHelper.getImage("unchecked");
    }

    public CheckBoxPainter(Image checkedImg, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.uncheckedImg = uncheckedImg;
    }

    public int getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public int getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    public void paintIconImage(GC gc, Rectangle rectangle, int yOffset, boolean checked) {
        Image checkBoxImage = checked ? this.checkedImg : this.uncheckedImg;
        int x = rectangle.x + rectangle.width / 2 - checkBoxImage.getBounds().width / 2;
        gc.drawImage(checkBoxImage, x, rectangle.y + yOffset);
    }

    protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
        return this.isChecked(cell, configRegistry) ? this.checkedImg : this.uncheckedImg;
    }

    protected boolean isChecked(LayerCell cell, IConfigRegistry configRegistry) {
        return (Boolean)cell.getDataValue();
    }
}

