/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.summaryrow;

import net.sourceforge.nattable.config.AbstractRegistryConfiguration;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.style.BorderStyle;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.Style;
import net.sourceforge.nattable.summaryrow.ISummaryProvider;
import net.sourceforge.nattable.summaryrow.SummaryRowConfigAttributes;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultSummaryRowConfiguration
extends AbstractRegistryConfiguration {
    public BorderStyle summaryRowBorderStyle = new BorderStyle(0, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DOTTED);
    public Color summaryRowFgColor = GUIHelper.COLOR_BLACK;
    public Color summaryRowBgColor = GUIHelper.COLOR_WHITE;
    public Font summaryRowFont = GUIHelper.getFont(new FontData("Verdana", 8, 1));

    public void configureRegistry(IConfigRegistry configRegistry) {
        this.addSummaryRowStyleConfig(configRegistry);
        this.addSummaryProviderConfig(configRegistry);
    }

    protected void addSummaryRowStyleConfig(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.summaryRowFont);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.summaryRowBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.summaryRowFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.summaryRowBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "NORMAL", "SummaryRow");
    }

    protected void addSummaryProviderConfig(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, ISummaryProvider.DEFAULT, "NORMAL", "SummaryRow");
    }
}

