/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import java.util.HashSet;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.IStyle;
import org.eclipse.actf.model.dom.dombycom.impl.AttrImpl;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NamedNodeMapImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLTerms;
import org.eclipse.actf.model.dom.dombycom.impl.html.ImageElementImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements IElementEx {
    boolean isHighlighted = false;
    private static final Integer getSetAttributeFlag = 2;
    private NamedNodeMapImpl cachedAttributes;
    private String originalBorder;
    private static final InputType[] HTMLINPUTCLASSES = new InputType[]{new InputType("edit", "text", InputType.InputClass.EDIT), new InputType("password edit", "password", InputType.InputClass.PASSWORD), new InputType("radio button", "radio", InputType.InputClass.RADIO), new InputType("checkbox", "checkbox", InputType.InputClass.CHECKBOX), new InputType("file upload edit", "file", InputType.InputClass.FILE), new InputType("", "hidden", InputType.InputClass.HIDDEN), new InputType("button", "submit", InputType.InputClass.BUTTON), new InputType("reset button", "reset", InputType.InputClass.BUTTON), new InputType("button", "button", InputType.InputClass.BUTTON), new InputType("button", "image", InputType.InputClass.BUTTON)};

    protected ElementImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        super(nodeImpl, iDispatch, (short)1);
    }

    protected ElementImpl(DocumentImpl documentImpl, IDispatch iDispatch) {
        super(documentImpl, iDispatch, (short)1);
    }

    public String getTagName() {
        return (String)Helper.get(this.inode, "tagName");
    }

    public String getAttribute(String string) {
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("getAttributeNode", (Object)string);
        if (iDispatch == null) {
            return null;
        }
        Boolean bl = (Boolean)Helper.get(iDispatch, "specified");
        if (!bl.booleanValue()) {
            return null;
        }
        return (String)Helper.get(iDispatch, "value");
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.inode.invoke("setAttribute", new Object[]{string, string2, getSetAttributeFlag});
    }

    public void removeAttribute(String string) throws DOMException {
        this.inode.invoke1("removeAttribute", (Object)string);
    }

    public String getCurrentAttribute(String string) {
        String string2 = (String)this.inode.invoke("getAttribute", new Object[]{string, getSetAttributeFlag});
        return string2;
    }

    public Attr getAttributeNode(String string) {
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("getAttributeNode", (Object)string);
        if (iDispatch == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(iDispatch, (short)2));
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl;
        IDispatch iDispatch;
        if (!(attr instanceof AttrImpl)) {
            Helper.notSupported();
        }
        if ((iDispatch = (IDispatch)this.inode.invoke1("setAttributeNode", (Object)(attrImpl = (AttrImpl)attr).getINode())) == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(iDispatch, (short)2));
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl;
        IDispatch iDispatch;
        if (!(attr instanceof AttrImpl)) {
            Helper.notSupported();
        }
        if ((iDispatch = (IDispatch)this.inode.invoke1("removeAttributeNode", (Object)(attrImpl = (AttrImpl)attr).getINode())) == null) {
            return null;
        }
        return (Attr)((Object)this.newNode(iDispatch, (short)2));
    }

    public NodeList getElementsByTagName(String string) {
        IDispatch iDispatch = (IDispatch)this.inode.invoke1("getElementsByTagName", (Object)string);
        if (iDispatch == null) {
            return null;
        }
        return new NodeListImpl(this, iDispatch);
    }

    private void initCache() {
        if (this.cachedAttributes != null) {
            return;
        }
        this.cachedAttributes = (NamedNodeMapImpl)this.getAttributes();
    }

    public String getAttributeNS(String string, String string2) {
        this.initCache();
        Attr attr = (Attr)this.cachedAttributes.getNamedItemNS(string, string2);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.initCache();
        Attr attr = (Attr)this.cachedAttributes.getNamedItemNS(string, string2);
        if (attr == null) {
            return;
        }
        this.removeAttributeNode(attr);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        this.initCache();
        Attr attr = (Attr)this.cachedAttributes.getNamedItemNS(string, string2);
        if (attr == null) {
            return null;
        }
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAttribute(String string) {
        String string2 = this.getAttribute(string);
        return string2 != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        String string3 = this.getAttributeNS(string, string2);
        return string3 != null;
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean doClick() {
        block5: {
            block4: {
                try {
                    if (!"OPTION".equals(this.getLocalName())) break block4;
                    Helper.put(this.inode, "selected", true);
                    return true;
                }
                catch (DispatchException dispatchException) {
                    dispatchException.printStackTrace();
                    return false;
                }
            }
            if (!"SELECT".equals(this.getLocalName())) break block5;
            return false;
        }
        this.inode.invoke0("click");
        return true;
    }

    public boolean highlight() {
        if (!this.isHighlighted) {
            switch (2) {
                case 0: {
                    String string = (String)Helper.get(this.inode, "className");
                    if (string == null) {
                        return false;
                    }
                    string = String.valueOf(string) + " CSStoHighlight";
                    Helper.put(this.inode, "className", string);
                    this.isHighlighted = true;
                    break;
                }
                case 1: {
                    Element element = this.getOwnerDocument().getElementById("__org_eclipse_actf_highlight_div__");
                    IStyle iStyle = ((IElementEx)element).getStyle();
                    Rectangle rectangle = Helper.getLocation(this.inode);
                    String string = ((IDocumentEx)this.getOwnerDocument()).getCompatMode();
                    int n = 0;
                    if (string.equals("CSS1Compat")) {
                        n = 0;
                    } else if (string.equals("BackCompat")) {
                        n = 6;
                    }
                    iStyle.put("left", String.valueOf(rectangle.x - 3) + "px");
                    iStyle.put("top", String.valueOf(rectangle.y - 3) + "px");
                    iStyle.put("width", String.valueOf(rectangle.width + n) + "px");
                    iStyle.put("height", String.valueOf(rectangle.height + n) + "px");
                    this.isHighlighted = true;
                    break;
                }
                case 2: {
                    IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "style");
                    if (iDispatch == null) {
                        return false;
                    }
                    this.originalBorder = ((String)Helper.get(iDispatch, "cssText")).trim();
                    String string = this.originalBorder.length() > 0 && !this.originalBorder.endsWith(";") ? String.valueOf(this.originalBorder) + ";" + "border: 4px inset yellow;" : String.valueOf(this.originalBorder) + "border: 4px inset yellow;";
                    Helper.put(iDispatch, "cssText", string);
                    this.isHighlighted = true;
                }
            }
        }
        try {
            this.inode.invoke0("scrollIntoView");
            this.inode.invoke0("onmouseover");
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    public boolean unhighlight() {
        if (this.isHighlighted) {
            switch (2) {
                case 0: {
                    String string = (String)Helper.get(this.inode, "className");
                    if (string == null) {
                        return false;
                    }
                    String string2 = string.replaceAll(" CSStoHighlight", "");
                    Helper.put(this.inode, "className", string2);
                    break;
                }
                case 1: {
                    Element element = this.getOwnerDocument().getElementById("__org_eclipse_actf_highlight_div__");
                    IStyle iStyle = ((IElementEx)element).getStyle();
                    iStyle.put("left", "-1000px");
                    iStyle.put("top", "-1000px");
                    iStyle.put("width", "100px");
                    iStyle.put("height", "100px");
                    break;
                }
                case 2: {
                    IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "style");
                    if (iDispatch == null) {
                        return false;
                    }
                    Helper.put(iDispatch, "cssText", this.originalBorder);
                }
            }
        }
        this.isHighlighted = false;
        try {
            this.inode.invoke0("onmouseout");
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    InputType getInputType() {
        Object object = Helper.get(this.inode, "type");
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        int n = 0;
        while (n < HTMLINPUTCLASSES.length) {
            if (string.equals(ElementImpl.HTMLINPUTCLASSES[n].htmlType)) {
                return HTMLINPUTCLASSES[n];
            }
            ++n;
        }
        return null;
    }

    private String getInputValue() {
        return (String)Helper.get(this.inode, "value");
    }

    private String modifySrcStr(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(63);
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n < 0) {
            if (n2 < 0) {
                return string;
            }
            n = 0;
        } else {
            ++n;
        }
        if (n2 <= n) {
            return string.substring(n);
        }
        return string.substring(n, n2);
    }

    public String extractString() {
        String string = this.getLocalName();
        if ("IMG".equals(string)) {
            String string2;
            String string3;
            String string4 = this.getAttribute("alt");
            if (string4 != null) {
                string4 = Helper.trimHTMLStr(string4);
            }
            if ((string3 = this.getAttribute("title")) != null) {
                string3 = Helper.trimHTMLStr(string3);
                if (string4 == null || string4.length() == 0) {
                    string4 = string3;
                }
            }
            if ((string2 = this.getAttribute("src")) != null) {
                string2 = this.modifySrcStr(string2);
            }
            boolean bl = string4 == null;
            boolean bl2 = string4 != null && string4.length() == 0;
            boolean bl3 = Vocabulary.isLink().eval((IEvalTarget)this);
            if (bl3) {
                if (bl) {
                    if (Vocabulary.isReadNoAltImageLink()) {
                        return string2;
                    }
                    return "";
                }
                if (bl2 && Vocabulary.isReadNullAltImageLink()) {
                    return string2;
                }
                return string4;
            }
            if (bl) {
                if (Vocabulary.isReadNoAltImage()) {
                    return string2;
                }
                return "";
            }
            if (bl2 && Vocabulary.isReadNullAltImage()) {
                return string2;
            }
            return string4;
        }
        if (Vocabulary.isEmbeddedObject().eval((IEvalTarget)this)) {
            return "(Embedded Object)";
        }
        if ("INPUT".equals(string)) {
            InputType inputType = this.getInputType();
            if (inputType != null) {
                if (inputType.isHidden()) {
                    return "";
                }
                String string5 = this.getAttribute("alt");
                if (string5 != null && (string5 = Helper.trimHTMLStr(string5)).length() > 0) {
                    return string5;
                }
                String string6 = this.getInputValue();
                if (inputType.isPassword()) {
                    string6 = string6.replaceAll(".", "*");
                }
                if (string6 != null && string6.length() > 0) {
                    return string6;
                }
                String string7 = this.getAttribute("title");
                if (string7 != null) {
                    return string7;
                }
            }
        } else {
            String string8;
            if ("SELECT".equals(string)) {
                return "Select";
            }
            if ("AREA".equals(string) && (string8 = this.getAttribute("alt")) != null && (string8 = Helper.trimHTMLStr(string8)).length() > 0) {
                return string8;
            }
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private boolean anyTextInParentLink() {
        var1_1 = this.getParentNode();
        if (var1_1 != null) ** GOTO lbl6
        return false;
        while (!"A".equals(var1_1.getNodeName())) {
            var1_1 = var1_1.getParentNode();
lbl6:
            // 2 sources

            if (var1_1 != null) continue;
        }
        if (var1_1 == null) {
            return false;
        }
        return this.anyTextInSiblings(var1_1.getFirstChild());
    }

    private boolean anyTextInSiblings(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node2 = node;
        while (node2 != null) {
            if (node2 instanceof ImageElementImpl) {
                node2 = node2.getNextSibling();
                continue;
            }
            if (node2 instanceof Element && this.anyTextInSiblings(node2.getFirstChild())) {
                return true;
            }
            if (node2 instanceof INodeEx) {
                INodeEx iNodeEx = (INodeEx)node2;
                stringBuffer.append(iNodeEx.extractString());
            }
            node2 = node2.getNextSibling();
        }
        return Helper.trimHTMLStr(stringBuffer.toString()).length() > 0;
    }

    public short getHeadingLevel() {
        String string = this.getLocalName();
        if (string.length() != 2) {
            return super.getHeadingLevel();
        }
        if (string.charAt(0) != 'H') {
            return super.getHeadingLevel();
        }
        switch (string.charAt(1)) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
        }
        return super.getHeadingLevel();
    }

    public boolean setFocus() {
        try {
            this.inode.invoke0("focus");
            return true;
        }
        catch (DispatchException dispatchException) {
            dispatchException.printStackTrace();
            return false;
        }
    }

    public void setTextContent(String string) {
        try {
            Helper.put(this.inode, "innerText", string);
        }
        catch (DispatchException dispatchException) {
            dispatchException.printStackTrace();
        }
    }

    public IStyle getStyle() {
        IDispatch iDispatch = (IDispatch)Helper.get(this.inode, "currentStyle");
        return new StyleImpl(iDispatch);
    }

    public AbstractTerms getTerms() {
        return HTMLTerms.getInstance();
    }

    public Rectangle getLocation() {
        try {
            return Helper.getLocation(this.inode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IElementEx.Position getRadioPosition() {
        if (this.getInputType() == null) {
            return null;
        }
        if (!this.getInputType().isRadio()) {
            return null;
        }
        Element element = this.getParentElement(new String[]{"FORM"});
        if (element == null) {
            return null;
        }
        String string = (String)Helper.get(this.inode, "name");
        IElementEx.Position position = new IElementEx.Position();
        this.searchRadioPosition(element, string, position, false);
        return position;
    }

    private void searchRadioPosition(Element element, String string, IElementEx.Position position, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof ElementImpl) {
                ElementImpl elementImpl = (ElementImpl)node;
                if (elementImpl.hasChildNodes()) {
                    this.searchRadioPosition(elementImpl, string, position, bl);
                }
                if (elementImpl.getInputType() != null && elementImpl.getInputType().isRadio()) {
                    String string2 = (String)Helper.get(elementImpl.getINode(), "name");
                    if (string.equals(string2)) {
                        if (!bl) {
                            ++position.index;
                        }
                        ++position.total;
                    }
                    if (elementImpl.isSameNode(this)) {
                        bl = true;
                    }
                }
            }
            ++n2;
        }
    }

    public IElementEx.Position getListPosition() {
        Element element = this.getParentElement(new String[]{"UL", "OL", "DL"});
        Element element2 = this.getParentElement(new String[]{"LI", "DT"});
        if (element == null) {
            return null;
        }
        IElementEx.Position position = new IElementEx.Position();
        this.searchListPosition(element, element2, position, false);
        return position;
    }

    private void searchListPosition(Element element, Element element2, IElementEx.Position position, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof ElementImpl) {
                ElementImpl elementImpl = (ElementImpl)node;
                String string = elementImpl.getNodeName();
                if (elementImpl.hasChildNodes() && !"UL".equals(string) && !"OL".equals(string) && !"DL".equals(string)) {
                    this.searchListPosition(elementImpl, element2, position, bl);
                }
                if ("LI".equals(elementImpl.getNodeName()) || "DT".equals(elementImpl.getNodeName())) {
                    if (!bl) {
                        ++position.index;
                    }
                    ++position.total;
                    if (elementImpl.isSameNode(element2)) {
                        bl = true;
                    }
                }
            }
            ++n2;
        }
    }

    private Element getParentElement(String[] stringArray) {
        Element element = this;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n].intern());
            ++n;
        }
        String string = element.getNodeName();
        while (!hashSet.contains(string.intern())) {
            Node node = element.getParentNode();
            if (node == null || !(node instanceof Element)) {
                return null;
            }
            element = (Element)node;
            string = element.getNodeName();
        }
        return element;
    }

    public Element getFormLabel() {
        NodeList nodeList = this.getOwnerDocument().getElementsByTagName("LABEL");
        Object object = Helper.get(this.inode, "id");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof ElementImpl) {
                ElementImpl elementImpl = (ElementImpl)node;
                String string = (String)Helper.get(elementImpl.inode, "htmlFor");
                if (string != null && string.equals(object)) {
                    return elementImpl;
                }
            }
            ++n;
        }
        return null;
    }

    public char getAccessKey() {
        String string = null;
        String string2 = this.getNodeName();
        if ("LABEL".equals(string2)) {
            return '\u0000';
        }
        Element element = this.getFormLabel();
        string = element != null && element instanceof ElementImpl ? (String)Helper.get(((ElementImpl)element).inode, "accessKey") : (String)Helper.get(this.inode, "accessKey");
        if (string != null && string.length() == 1) {
            return string.toUpperCase().charAt(0);
        }
        return '\u0000';
    }

    public AnalyzedResult analyze(AnalyzedResult analyzedResult) {
        char c = this.getAccessKey();
        if (c != '\u0000') {
            analyzedResult.addAccessKey(this);
        }
        return super.analyze(analyzedResult);
    }

    static class InputType {
        private final InputClass inputClass;
        private final String uiString;
        final String htmlType;

        String getUIString() {
            return this.uiString;
        }

        boolean isEdit() {
            return this.inputClass == InputClass.EDIT;
        }

        boolean isFileEdit() {
            return this.inputClass == InputClass.FILE;
        }

        boolean isButton() {
            return this.inputClass == InputClass.BUTTON;
        }

        boolean isRadio() {
            return this.inputClass == InputClass.RADIO;
        }

        boolean isCheckBox() {
            return this.inputClass == InputClass.CHECKBOX;
        }

        boolean isComboBox() {
            return this.inputClass == InputClass.COMBOBOX;
        }

        boolean isHidden() {
            return this.inputClass == InputClass.HIDDEN;
        }

        boolean isPassword() {
            return this.inputClass == InputClass.PASSWORD;
        }

        boolean isClickable() {
            return this.isButton() || this.isRadio() || this.isCheckBox() || this.isComboBox();
        }

        InputType(String string, String string2, InputClass inputClass) {
            this.uiString = string;
            this.htmlType = string2;
            this.inputClass = inputClass;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InputClass {
            EDIT,
            BUTTON,
            RADIO,
            CHECKBOX,
            COMBOBOX,
            HIDDEN,
            PASSWORD,
            FILE;

        }
    }
}

