/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.guideline;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.eval.ICheckerInfoProvider;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineSelectionChangedEvent;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineSlectionChangedListener;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.eval.problem.ReportUtil;
import org.eclipse.actf.visualization.internal.eval.CheckerExtension;
import org.eclipse.actf.visualization.internal.eval.EvaluationItemImpl;
import org.eclipse.actf.visualization.internal.eval.EvaluationPlugin;
import org.eclipse.actf.visualization.internal.eval.Messages;
import org.eclipse.actf.visualization.internal.eval.guideline.CheckItemReader;
import org.eclipse.actf.visualization.internal.eval.guideline.GuidelineData;
import org.eclipse.actf.visualization.internal.eval.guideline.GuidelineDataComparator;
import org.eclipse.actf.visualization.internal.eval.guideline.GuidelineItemReader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidelineHolder {
    private static final String UNDERSCORE = "_";
    private static GuidelineHolder INSTANCE = null;
    private IPreferenceStore preferenceStore;
    private ICheckerInfoProvider[] checkerInfos;
    private Map<String, GuidelineData> guidelineMaps;
    private Set<GuidelineData> guidelineSet;
    private GuidelineData[] guidelineArray;
    private GuidelineData[] leafGuidelineArray;
    private String[] guidelineNamesWithLevels;
    private String[] guidelineNames;
    private Map<String, IEvaluationItem> checkitemMap;
    private String[] metricsNames;
    private String[] localizedMetricsNames;
    private boolean[][] correspondingMetricsOfLeafGuideline;
    private boolean[] enabledMetrics;
    private Set<IEvaluationItem> enabledCheckitemSet;
    private Set<IGuidelineItem> enabledGuidelineitemSet;
    private boolean[] matchedMetrics;
    private Set<IEvaluationItem> matchedCheckitemSet;
    private Set<IGuidelineItem> matchedGuidelineitemSet;
    private Set<IGuidelineSlectionChangedListener> guidelineSelectionChangedListenerSet;
    private String currentMimeType;
    private SortedSet<ITechniquesItem> techniquesItemSet;
    private Map<String, Set<IProblemItem>> techniquesProblemMap;

    public static GuidelineHolder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GuidelineHolder();
        }
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private GuidelineHolder() {
        block28: {
            void iOException;
            InputStream[] inputStreamArray;
            Object object;
            Object object2;
            this.preferenceStore = EvaluationPlugin.getDefault().getPreferenceStore();
            this.checkerInfos = CheckerExtension.getCheckerInfoProviders();
            this.guidelineMaps = new HashMap<String, GuidelineData>();
            this.guidelineSet = new TreeSet<GuidelineData>(new GuidelineDataComparator());
            this.checkitemMap = new HashMap<String, IEvaluationItem>();
            this.metricsNames = new String[0];
            this.localizedMetricsNames = new String[0];
            this.enabledCheckitemSet = new HashSet<IEvaluationItem>();
            this.enabledGuidelineitemSet = new HashSet<IGuidelineItem>();
            this.matchedCheckitemSet = new HashSet<IEvaluationItem>();
            this.matchedGuidelineitemSet = new HashSet<IGuidelineItem>();
            this.guidelineSelectionChangedListenerSet = new HashSet<IGuidelineSlectionChangedListener>();
            this.currentMimeType = "text/html";
            Bundle bundle = EvaluationPlugin.getDefault().getBundle();
            Enumeration enumeration = bundle.findEntries("resources/guidelines", "*.xml", false);
            while (enumeration.hasMoreElements()) {
                try {
                    this.readGuidelines(((URL)enumeration.nextElement()).openStream());
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
            Object object3 = this.checkerInfos;
            int n = this.checkerInfos.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = object3[n2];
                object = object2.getGuidelineInputStreams();
                if (object != null) {
                    DebugPrintUtil.devOrDebugPrintln((Object)(String.valueOf(object2.getClass().getName()) + ":" + ((InputStream[])object).length));
                    inputStreamArray = object;
                    int n3 = ((InputStream[])object).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InputStream inputStream = inputStreamArray[n4];
                        this.readGuidelines(inputStream);
                        ++n4;
                    }
                }
                ++n2;
            }
            this.guidelineNames = new String[this.guidelineSet.size()];
            this.guidelineArray = new GuidelineData[this.guidelineSet.size()];
            this.guidelineSet.toArray(this.guidelineArray);
            object2 = new Vector();
            Vector<String> vector = new Vector<String>();
            boolean object4 = false;
            while (iOException < this.guidelineArray.length) {
                object3 = this.guidelineArray[iOException];
                this.guidelineNames[iOException] = ((GuidelineData)object3).getGuidelineName();
                object = ((GuidelineData)object3).getLevels();
                if (((Object[])object).length > 0) {
                    int n5 = 0;
                    while (n5 < ((Object[])object).length) {
                        GuidelineData guidelineData = ((GuidelineData)object3).getSubLevelData((String)object[n5]);
                        ((Vector)object2).add(guidelineData);
                        String string = String.valueOf(guidelineData.getGuidelineName()) + " (" + guidelineData.getLevelStr() + ")";
                        vector.add(string);
                        ++n5;
                    }
                } else {
                    ((Vector)object2).add(object3);
                    vector.add(((GuidelineData)object3).getGuidelineName());
                }
                ++iOException;
            }
            this.leafGuidelineArray = new GuidelineData[((Vector)object2).size()];
            ((Vector)object2).toArray(this.leafGuidelineArray);
            this.guidelineNamesWithLevels = new String[vector.size()];
            vector.toArray(this.guidelineNamesWithLevels);
            try {
                InputStream inputStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("resources/checkitem.xml"), (boolean)false);
                CheckItemReader checkItemReader = CheckItemReader.parse(inputStream, this);
                object3 = new HashSet();
                if (!checkItemReader.isSucceed()) break block28;
                this.checkitemMap = checkItemReader.getCheckItemMap();
                object3 = checkItemReader.getMetricsSet();
                ICheckerInfoProvider[] iCheckerInfoProviderArray = this.checkerInfos;
                int n6 = this.checkerInfos.length;
                int n7 = 0;
                while (n7 < n6) {
                    object = iCheckerInfoProviderArray[n7];
                    inputStreamArray = object.getCheckItemInputStreams();
                    if (inputStreamArray != null) {
                        DebugPrintUtil.devOrDebugPrintln((Object)(String.valueOf(object.getClass().getName()) + ":" + inputStreamArray.length));
                        InputStream[] inputStreamArray2 = inputStreamArray;
                        int n8 = inputStreamArray.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            void var6_10;
                            InputStream inputStream2 = inputStreamArray2[n9];
                            try {
                                CheckItemReader checkItemReader2 = CheckItemReader.parse(inputStream2, this);
                            }
                            catch (Exception exception) {
                                DebugPrintUtil.devOrDebugPrintln((Object)("can't parse: " + object.getClass().getName()));
                            }
                            if (var6_10.isSucceed()) {
                                this.checkitemMap.putAll(var6_10.getCheckItemMap());
                                object3.addAll(var6_10.getMetricsSet());
                            }
                            ++n9;
                        }
                    }
                    ++n7;
                }
                this.metricsNames = new String[object3.size()];
                this.localizedMetricsNames = new String[object3.size()];
                object3.toArray(this.metricsNames);
                object3.toArray(this.localizedMetricsNames);
                int n10 = 0;
                while (n10 < this.localizedMetricsNames.length) {
                    if (this.localizedMetricsNames[n10].equalsIgnoreCase("perceivable")) {
                        this.localizedMetricsNames[n10] = Messages.Perceivable;
                    } else if (this.localizedMetricsNames[n10].equalsIgnoreCase("operable")) {
                        this.localizedMetricsNames[n10] = Messages.Operable;
                    } else if (this.localizedMetricsNames[n10].equalsIgnoreCase("understandable")) {
                        this.localizedMetricsNames[n10] = Messages.Understandable;
                    } else if (this.localizedMetricsNames[n10].equalsIgnoreCase("robust")) {
                        this.localizedMetricsNames[n10] = Messages.Robust;
                    }
                    ++n10;
                }
                this.enabledMetrics = new boolean[object3.size()];
                Arrays.fill(this.enabledMetrics, true);
            }
            catch (IOException iOException3) {
                iOException3.printStackTrace();
            }
        }
        for (IEvaluationItem iEvaluationItem : this.checkitemMap.values()) {
            if (iEvaluationItem instanceof EvaluationItemImpl) {
                ((EvaluationItemImpl)iEvaluationItem).initMetrics(this.metricsNames);
            }
            this.addGuidelineSelectionChangedListener(iEvaluationItem);
        }
        this.initGuidelineNameLevel2checkItem();
        this.initDisabledGuideline();
        this.initDisabledMetrics();
        this.initCorrespondingMetrics();
        this.resetMatchedItems();
        this.notifyGuidelineSelectionChange();
    }

    public IGuidelineData[] getLeafGuidelineData() {
        return this.leafGuidelineArray;
    }

    public IGuidelineData[] getGuidelineData() {
        return this.guidelineArray;
    }

    public String[] getGuidelineNamesWithLevels() {
        return this.guidelineNamesWithLevels;
    }

    public IGuidelineItem getGuidelineItem(String string, String string2) {
        if (this.guidelineMaps.containsKey(string)) {
            IGuidelineData iGuidelineData = this.guidelineMaps.get(string);
            return iGuidelineData.getGuidelineItem(string2);
        }
        return null;
    }

    public IEvaluationItem getEvaluationItem(String string) {
        if (this.checkitemMap.containsKey(string)) {
            return this.checkitemMap.get(string);
        }
        return null;
    }

    public boolean setEnabledGuidelineWithLevels(boolean[] blArray) {
        if (blArray.length != this.leafGuidelineArray.length) {
            return false;
        }
        this.enabledCheckitemSet.clear();
        this.enabledGuidelineitemSet.clear();
        int n = 0;
        while (n < blArray.length) {
            GuidelineData guidelineData = this.leafGuidelineArray[n];
            guidelineData.setEnabled(blArray[n]);
            if (blArray[n]) {
                this.addEnabledItems(guidelineData);
            }
            ++n;
        }
        this.storeDisabledGuideline();
        this.resetMatchedItems();
        this.notifyGuidelineSelectionChange();
        return true;
    }

    public void setEnabledGuidelines(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < this.leafGuidelineArray.length) {
            this.leafGuidelineArray[n].setEnabled(false);
            ++n;
        }
        if (stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
            this.enabledCheckitemSet.clear();
            this.enabledGuidelineitemSet.clear();
            n = 0;
            while (n < stringArray.length) {
                if (this.guidelineMaps.containsKey(stringArray[n])) {
                    GuidelineData guidelineData = this.guidelineMaps.get(stringArray[n]);
                    if (stringArray2[n] == null) {
                        guidelineData.setEnabled(true);
                        this.addEnabledItems(guidelineData);
                    } else if ((guidelineData = guidelineData.getSubLevelData(stringArray2[n])) != null) {
                        guidelineData.setEnabled(true);
                        this.addEnabledItems(guidelineData);
                    }
                }
                ++n;
            }
            this.storeDisabledGuideline();
            this.resetMatchedItems();
            this.notifyGuidelineSelectionChange();
        }
    }

    private void addEnabledItems(GuidelineData guidelineData) {
        if (guidelineData.isEnabled()) {
            this.enabledCheckitemSet.addAll(guidelineData.getEvaluationItemSet());
            this.enabledGuidelineitemSet.addAll(guidelineData.getGuidelineItemMap().values());
        }
    }

    private void resetMatchedItems() {
        this.matchedCheckitemSet.clear();
        this.matchedGuidelineitemSet.clear();
        this.matchedMetrics = new boolean[this.metricsNames.length];
        Arrays.fill(this.matchedMetrics, false);
        int n = 0;
        while (n < this.leafGuidelineArray.length) {
            GuidelineData guidelineData = this.leafGuidelineArray[n];
            guidelineData.setCurrentMIMEtype(this.currentMimeType);
            if (guidelineData.isMatched()) {
                this.matchedCheckitemSet.addAll(guidelineData.getEvaluationItemSet());
                this.matchedGuidelineitemSet.addAll(guidelineData.getGuidelineItemMap().values());
                int n2 = 0;
                while (n2 < this.metricsNames.length) {
                    this.matchedMetrics[n2] = this.enabledMetrics[n2] && this.matchedMetrics[n2] | this.correspondingMetricsOfLeafGuideline[n][n2];
                    ++n2;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.guidelineArray.length) {
            this.guidelineArray[n].setCurrentMIMEtype(this.currentMimeType);
            ++n;
        }
    }

    public boolean setEnabledMetrics(boolean[] blArray) {
        if (blArray == null || blArray.length != this.enabledMetrics.length) {
            return false;
        }
        this.enabledMetrics = blArray;
        this.storeDisabledMetrics();
        this.resetMatchedItems();
        this.notifyGuidelineSelectionChange();
        return true;
    }

    public void setEnabledMetrics(String[] stringArray) {
        if (stringArray != null) {
            Arrays.fill(this.enabledMetrics, false);
            int n = 0;
            while (n < this.metricsNames.length) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (this.metricsNames[n].equalsIgnoreCase(stringArray[n2])) {
                        this.enabledMetrics[n] = true;
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            this.storeDisabledMetrics();
            this.resetMatchedItems();
            this.notifyGuidelineSelectionChange();
        }
    }

    public Set<IEvaluationItem> getMatchedCheckitemSet() {
        return this.matchedCheckitemSet;
    }

    public String[] getMetricsNames() {
        return this.metricsNames;
    }

    public String[] getLocalizedMetricsNames() {
        return this.localizedMetricsNames;
    }

    private void initGuidelineNameLevel2checkItem() {
        for (GuidelineData guidelineData : this.guidelineMaps.values()) {
            guidelineData.setEvaluationItems(this.checkitemMap.values(), this.metricsNames);
        }
    }

    private void initDisabledGuideline() {
        try {
            int n = 0;
            while (n < this.guidelineArray.length) {
                GuidelineData guidelineData = this.guidelineArray[n];
                String[] stringArray = guidelineData.getLevels();
                if (stringArray.length == 0) {
                    String string = "GUIDELINE_" + guidelineData.getGuidelineName() + UNDERSCORE;
                    if (this.preferenceStore.contains(string) && this.preferenceStore.getBoolean(string)) {
                        guidelineData.setEnabled(false);
                    } else {
                        guidelineData.setEnabled(true);
                    }
                } else {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        GuidelineData guidelineData2 = guidelineData.getSubLevelData(stringArray[n2]);
                        String string = "GUIDELINE_" + guidelineData2.getGuidelineName() + UNDERSCORE + n2;
                        if (this.preferenceStore.contains(string) || this.preferenceStore.getBoolean(string)) {
                            guidelineData2.setEnabled(false);
                        } else {
                            guidelineData2.setEnabled(true);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    private void storeDisabledGuideline() {
        try {
            int n = 0;
            while (n < this.guidelineArray.length) {
                GuidelineData guidelineData = this.guidelineArray[n];
                String[] stringArray = guidelineData.getLevels();
                if (stringArray.length == 0) {
                    this.preferenceStore.setValue("GUIDELINE_" + guidelineData.getGuidelineName() + UNDERSCORE, !guidelineData.isEnabled());
                } else {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        IGuidelineData iGuidelineData = guidelineData.getSubLevelData(stringArray[n2]);
                        this.preferenceStore.setValue("GUIDELINE_" + iGuidelineData.getGuidelineName() + UNDERSCORE + n2, !iGuidelineData.isEnabled());
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initDisabledMetrics() {
        try {
            int n = 0;
            while (n < this.metricsNames.length) {
                String string = "METRICS_" + this.metricsNames[n];
                if (this.preferenceStore.contains(string) && this.preferenceStore.getBoolean(string)) {
                    this.enabledMetrics[n] = false;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    private void initCorrespondingMetrics() {
        this.correspondingMetricsOfLeafGuideline = new boolean[this.leafGuidelineArray.length][this.metricsNames.length];
        int n = 0;
        while (n < this.leafGuidelineArray.length) {
            this.correspondingMetricsOfLeafGuideline[n] = this.leafGuidelineArray[n].getCorrespondingMetrics();
            ++n;
        }
    }

    private void storeDisabledMetrics() {
        try {
            int n = 0;
            while (n < this.enabledMetrics.length) {
                if (!this.enabledMetrics[n]) {
                    this.preferenceStore.setValue("METRICS_" + this.metricsNames[n], true);
                } else {
                    this.preferenceStore.setValue("METRICS_" + this.metricsNames[n], false);
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isMatchedCheckItem(IEvaluationItem iEvaluationItem) {
        return this.matchedCheckitemSet.contains(iEvaluationItem);
    }

    public boolean isMatchedGuidelineItem(IGuidelineItem iGuidelineItem) {
        return this.matchedGuidelineitemSet.contains(iGuidelineItem);
    }

    public boolean isMatchedInTopLevel(IGuidelineItem iGuidelineItem) {
        if (this.guidelineMaps.containsKey(iGuidelineItem.getGuidelineName())) {
            IGuidelineData iGuidelineData = this.guidelineMaps.get(iGuidelineItem.getGuidelineName());
            return iGuidelineData.isEnabled() && iGuidelineData.isTargetMIMEtype(this.currentMimeType);
        }
        return false;
    }

    public boolean isEnabledMetric(String string) {
        int n = 0;
        while (n < this.metricsNames.length) {
            if (this.metricsNames[n].equalsIgnoreCase(string)) {
                return this.enabledMetrics[n];
            }
            ++n;
        }
        return false;
    }

    public boolean isMatchedMetric(String string) {
        int n = 0;
        while (n < this.metricsNames.length) {
            if (this.metricsNames[n].equalsIgnoreCase(string)) {
                return this.matchedMetrics[n];
            }
            ++n;
        }
        return false;
    }

    private void readGuidelines(InputStream inputStream) {
        GuidelineData guidelineData = GuidelineItemReader.getGuidelineData(inputStream);
        if (guidelineData != null) {
            this.guidelineMaps.put(guidelineData.getGuidelineName(), guidelineData);
            if (!this.guidelineSet.add(guidelineData)) {
                this.guidelineSet.remove(guidelineData);
                this.guidelineSet.add(guidelineData);
            }
        }
    }

    public boolean[] getEnabledMetrics() {
        return this.enabledMetrics;
    }

    public boolean[] getMatchedMetrics() {
        return this.matchedMetrics;
    }

    public void addGuidelineSelectionChangedListener(IGuidelineSlectionChangedListener iGuidelineSlectionChangedListener) {
        this.guidelineSelectionChangedListenerSet.add(iGuidelineSlectionChangedListener);
    }

    public void removeGuidelineSelectionChangedListener(IGuidelineSlectionChangedListener iGuidelineSlectionChangedListener) {
        this.guidelineSelectionChangedListenerSet.remove(iGuidelineSlectionChangedListener);
    }

    private void notifyGuidelineSelectionChange() {
        GuidelineSelectionChangedEvent guidelineSelectionChangedEvent = new GuidelineSelectionChangedEvent(this);
        for (IGuidelineSlectionChangedListener iGuidelineSlectionChangedListener : this.guidelineSelectionChangedListenerSet) {
            iGuidelineSlectionChangedListener.selectionChanged(guidelineSelectionChangedEvent);
        }
    }

    public String getTargetMimeType() {
        return this.currentMimeType;
    }

    public void setTargetMimeType(String string) {
        if (string != null && !string.equals(this.currentMimeType)) {
            this.currentMimeType = string;
            this.resetMatchedItems();
            this.notifyGuidelineSelectionChange();
        }
    }

    public boolean[][] getCorrespondingMetricsOfLeafGuideline() {
        return this.correspondingMetricsOfLeafGuideline;
    }

    public String[] getGuidelineNames() {
        return this.guidelineNames;
    }

    public String toString() {
        Set<IEvaluationItem> set = this.getMatchedCheckitemSet();
        ArrayList<ProblemItemImpl> arrayList = new ArrayList<ProblemItemImpl>();
        for (IEvaluationItem object22 : set) {
            arrayList.add(new ProblemItemImpl(object22.getId()));
        }
        HashMap<String, ItemType> hashMap = new HashMap<String, ItemType>();
        ReportUtil reportUtil = new ReportUtil();
        reportUtil.setMode(1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ACTF id\t" + reportUtil.getFirstLine() + FileUtils.LINE_SEP);
        for (IProblemItem iProblemItem : arrayList) {
            String[] stringArray;
            stringBuffer.append(String.valueOf(iProblemItem.getId()) + "\t" + reportUtil.toString(iProblemItem) + FileUtils.LINE_SEP);
            String[] stringArray2 = stringArray = iProblemItem.getEvaluationItem().getTableDataTechniques().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                String string2 = string.trim();
                ItemType itemType = (ItemType)hashMap.get(string2);
                if (itemType == null) {
                    itemType = new ItemType(iProblemItem.getSeverity());
                    hashMap.put(string2, itemType);
                } else {
                    itemType.setSeverity(iProblemItem.getSeverity());
                }
                ++n2;
            }
        }
        stringBuffer.append(FileUtils.LINE_SEP);
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Pattern pattern = Pattern.compile("(\\p{Alpha}+)(\\d+)");
                Matcher matcher = pattern.matcher(string);
                matcher.matches();
                String string3 = matcher.group(1);
                int n = Integer.parseInt(matcher.group(2));
                Matcher matcher2 = pattern.matcher(string2);
                matcher2.matches();
                String string4 = matcher2.group(1);
                int n2 = Integer.parseInt(matcher2.group(2));
                int n3 = string3.compareTo(string4);
                if (n3 == 0) {
                    n3 = new Integer(n).compareTo(new Integer(n2));
                }
                return n3;
            }
        });
        treeSet.addAll(hashMap.keySet());
        for (Object object : treeSet) {
            stringBuffer.append(String.valueOf(object) + "\t" + hashMap.get(object) + FileUtils.LINE_SEP);
        }
        return stringBuffer.toString();
    }

    public SortedSet<ITechniquesItem> getTechniquesItemSet() {
        if (this.techniquesItemSet == null) {
            this.createTechSet();
        }
        return this.techniquesItemSet;
    }

    private void createTechSet() {
        this.techniquesItemSet = new TreeSet<ITechniquesItem>();
        for (IEvaluationItem iEvaluationItem : this.matchedCheckitemSet) {
            ProblemItemImpl problemItemImpl = new ProblemItemImpl(iEvaluationItem.getId());
            ITechniquesItem[][] iTechniquesItemArray = problemItemImpl.getEvaluationItem().getTechniques();
            int n = 0;
            while (n < iTechniquesItemArray.length) {
                int n2 = 0;
                while (n2 < iTechniquesItemArray[n].length) {
                    this.techniquesItemSet.add(iTechniquesItemArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public Map<String, Set<IProblemItem>> getTechProbMap() {
        if (this.techniquesProblemMap == null) {
            this.createTechProbMap();
        }
        return this.techniquesProblemMap;
    }

    private void createTechProbMap() {
        this.techniquesProblemMap = new HashMap<String, Set<IProblemItem>>();
        for (IEvaluationItem iEvaluationItem : this.matchedCheckitemSet) {
            ProblemItemImpl problemItemImpl = new ProblemItemImpl(iEvaluationItem.getId());
            ITechniquesItem[][] iTechniquesItemArray = problemItemImpl.getEvaluationItem().getTechniques();
            int n = 0;
            while (n < iTechniquesItemArray.length) {
                int n2 = 0;
                while (n2 < iTechniquesItemArray[n].length) {
                    ITechniquesItem iTechniquesItem = iTechniquesItemArray[n][n2];
                    this.techniquesItemSet.add(iTechniquesItem);
                    if (!this.techniquesProblemMap.containsKey(iTechniquesItem.getId())) {
                        this.techniquesProblemMap.put(iTechniquesItem.getId(), new HashSet());
                    }
                    this.techniquesProblemMap.get(iTechniquesItem.getId()).add(problemItemImpl);
                    ++n2;
                }
                ++n;
            }
        }
    }

    private class ItemType {
        boolean error = false;
        boolean warning = false;
        boolean user = false;
        boolean info = false;

        public ItemType(int n) {
            this.setSeverity(n);
        }

        public void setSeverity(int n) {
            switch (n) {
                case 1: {
                    this.error = true;
                    break;
                }
                case 2: {
                    this.warning = true;
                    break;
                }
                case 4: {
                    this.user = true;
                    break;
                }
                case 8: {
                    this.info = true;
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.error) {
                stringBuffer.append(String.valueOf(Messages.ProblemConst_Essential_2) + " / ");
            }
            if (this.warning) {
                stringBuffer.append(String.valueOf(Messages.ProblemConst_Warning) + " / ");
            }
            if (this.user) {
                stringBuffer.append(String.valueOf(Messages.ProblemConst_User_Check_5) + " / ");
            }
            if (this.info) {
                stringBuffer.append(String.valueOf(Messages.ProblemConst_Info) + " / ");
            }
            if (stringBuffer.length() > 3) {
                stringBuffer.setLength(stringBuffer.length() - 3);
            }
            return stringBuffer.toString();
        }
    }
}

