/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.actions.runnable;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class OpenRepresentationsRunnable
implements IRunnableWithProgress {
    private List<DRepresentation> _representations;
    private boolean _arrangeAll;

    public OpenRepresentationsRunnable(List<DRepresentation> representations_p, boolean arrangeAll_p) {
        this._representations = representations_p;
        this._arrangeAll = arrangeAll_p;
    }

    public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (int)1);
        SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(this._representations.size());
        for (DRepresentation representation : this._representations) {
            IEditorPart part;
            EObject semantic;
            Session session;
            if (representation instanceof DSemanticDecorator && (session = SessionManager.INSTANCE.getSession(semantic = ((DSemanticDecorator)representation).getTarget())) != null && (part = DialectUIManager.INSTANCE.openEditor(session, representation, monitor_p)) != null && this._arrangeAll && part instanceof DiagramEditor) {
                DiagramEditor editor = (DiagramEditor)part;
                final DiagramEditPart diagramEditPart = editor.getDiagramEditPart();
                ArrayList editParts = new ArrayList();
                editParts.addAll(diagramEditPart.getChildren());
                ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
                arrangeRequest.setViewAdaptersToArrange(editParts);
                diagramEditPart.deactivate();
                diagramEditPart.performRequest((Request)arrangeRequest);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        diagramEditPart.activate();
                    }
                });
            }
            loopProgress.worked(1);
        }
    }
}

