/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.MementoUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PersistentSettingsManager {
    private final String m_category;
    private final String m_instance;

    public PersistentSettingsManager(String category, String instance) {
        this.m_category = category != null ? category : "";
        this.m_instance = instance != null ? instance : "";
    }

    public PersistentSettingsManager(String instance) {
        this(null, instance);
    }

    public PersistentSettingsManager() {
        this(null, null);
    }

    public <T> PersistentParameter<T> getNewParameter(Class<T> clazz, String label, boolean perInstance, T defaultValue) {
        PersistentParameter<T> setting = new PersistentParameter<T>(clazz, perInstance, String.valueOf(this.getStorageKey(perInstance)) + "." + label);
        if (setting.isTypeSupported(clazz)) {
            setting.setDefault(defaultValue);
            return setting;
        }
        throw new InvalidParameterException("Unsupported class type: " + clazz.toString());
    }

    public <T> PersistentListParameter<T> getNewListParameter(Class<T> clazz, String label, boolean perInstance, List<T> defaultValue) {
        PersistentListParameter<T> setting = new PersistentListParameter<T>(clazz, perInstance, String.valueOf(this.getStorageKey(perInstance)) + "." + label);
        if (setting.isTypeSupported(clazz)) {
            setting.setDefault(defaultValue);
            return setting;
        }
        throw new InvalidParameterException("Unsupported class type: " + clazz.toString());
    }

    public <T> PersistentMapParameter<T> getNewMapParameter(Class<T> clazz, String label, boolean perInstance, Map<String, T> defaultValue) {
        PersistentMapParameter<T> setting = new PersistentMapParameter<T>(clazz, perInstance, String.valueOf(this.getStorageKey(perInstance)) + "." + label);
        if (setting.isTypeSupported(clazz)) {
            setting.setDefault(defaultValue);
            return setting;
        }
        throw new InvalidParameterException("Unsupported class type: " + clazz.toString());
    }

    private String getStorageKey(boolean perInstance) {
        return String.valueOf(perInstance ? this.m_instance : "") + (!this.m_category.isEmpty() ? "." + this.m_category : "");
    }

    private abstract class AbstractPersistentParameter<T> {
        protected final Class<T> myClazz;
        protected final boolean m_perInstance;
        protected final String m_storeKey;

        public AbstractPersistentParameter(Class<T> clazz, boolean perInstance, String storeKey) {
            this.myClazz = clazz;
            this.m_perInstance = perInstance;
            this.m_storeKey = storeKey;
        }

        public boolean isPerInstance() {
            return this.m_perInstance;
        }

        public Class<T> getClazz() {
            return this.myClazz;
        }

        protected String getStoreKey() {
            return this.m_storeKey;
        }

        protected T convertToT(String val) {
            if (String.class.isAssignableFrom(this.getClazz())) {
                return (T)val;
            }
            if (Integer.class.isAssignableFrom(this.getClazz())) {
                return (T)Integer.valueOf(val);
            }
            if (Boolean.class.isAssignableFrom(this.getClazz())) {
                return (T)Boolean.valueOf(val);
            }
            return null;
        }

        protected boolean isTypeSupported(Class<T> clazz) {
            return String.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz);
        }
    }

    public class PersistentListParameter<T>
    extends AbstractPersistentParameter<T> {
        private List<T> m_value;
        private List<T> m_defaultValue;

        public PersistentListParameter(Class<T> clazz, boolean perInstance, String storeKey) {
            super(clazz, perInstance, storeKey);
        }

        public void setDefault(List<T> defaultValues) {
            this.m_defaultValue = defaultValues;
        }

        public void set(List<T> values) {
            this.m_value = values;
            this.persistParameter(values);
        }

        public List<T> value() {
            if (this.m_value == null) {
                this.m_value = this.restoreParameter();
            } else if (!this.isPerInstance()) {
                this.m_value = this.restoreParameter();
            }
            return this.m_value == null ? this.m_defaultValue : this.m_value;
        }

        public List<T> value(boolean forceRefresh) {
            if (forceRefresh) {
                this.m_value = null;
            }
            return this.value();
        }

        private List<T> restoreParameter() {
            IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
            String memento = store.get(this.getStoreKey(), null);
            if (memento == null) {
                return null;
            }
            List<String> vals = MementoUtils.decodeListFromMemento(memento);
            List<T> convertedVal = this.convertToT(vals);
            return convertedVal;
        }

        private void persistParameter(List<T> values) {
            List<String> strList = this.convertTListToStringList(values);
            String memento = MementoUtils.encodeListIntoMemento(strList);
            if (memento != null) {
                IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
                store.put(this.getStoreKey(), memento);
                try {
                    store.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private List<T> convertToT(List<String> vals) {
            ArrayList convertedList = new ArrayList();
            for (String val : vals) {
                convertedList.add(this.convertToT(val));
            }
            return convertedList;
        }

        private List<String> convertTListToStringList(List<T> tList) {
            ArrayList<String> strList = new ArrayList<String>();
            for (T elem : tList) {
                strList.add(elem.toString());
            }
            return strList;
        }
    }

    public class PersistentMapParameter<T>
    extends AbstractPersistentParameter<T> {
        private Map<String, T> m_value;
        private Map<String, T> m_defaultValue;

        public PersistentMapParameter(Class<T> clazz, boolean perInstance, String storeKey) {
            super(clazz, perInstance, storeKey);
        }

        public void setDefault(Map<String, T> defaultValues) {
            this.m_defaultValue = defaultValues;
        }

        public void set(Map<String, T> values) {
            this.m_value = values;
            this.persistParameter(values);
        }

        public Map<String, T> value() {
            if (this.m_value == null) {
                this.m_value = this.restoreParameter();
            } else if (!this.isPerInstance()) {
                this.m_value = this.restoreParameter();
            }
            return this.m_value == null ? this.m_defaultValue : this.m_value;
        }

        public Map<String, T> value(boolean forceRefresh) {
            if (forceRefresh) {
                this.m_value = null;
            }
            return this.value();
        }

        private Map<String, T> restoreParameter() {
            IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
            String memento = store.get(this.getStoreKey(), null);
            if (memento == null) {
                return null;
            }
            Map<String, String> vals = MementoUtils.decodeMapFromMemento(memento);
            Map<String, T> convertedVal = this.convertToT(vals);
            return convertedVal;
        }

        private void persistParameter(Map<String, T> values) {
            Map<String, String> strMap = this.convertTMapToStringMap(values);
            String memento = MementoUtils.encodeMapIntoMemento(strMap);
            if (memento != null) {
                IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
                store.put(this.getStoreKey(), memento);
                try {
                    store.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private Map<String, T> convertToT(Map<String, String> vals) {
            HashMap convertedMap = new HashMap();
            for (String key : vals.keySet()) {
                convertedMap.put(key, this.convertToT(vals.get(key)));
            }
            return convertedMap;
        }

        private Map<String, String> convertTMapToStringMap(Map<String, T> map) {
            HashMap<String, String> strMap = new HashMap<String, String>();
            for (String key : map.keySet()) {
                strMap.put(key, map.get(key).toString());
            }
            return strMap;
        }
    }

    public class PersistentParameter<T>
    extends AbstractPersistentParameter<T> {
        private T m_value;
        private T m_defaultValue;

        public PersistentParameter(Class<T> clazz, boolean perInstance, String storeKey) {
            super(clazz, perInstance, storeKey);
        }

        public void setDefault(T defaultValue) {
            this.m_defaultValue = defaultValue;
        }

        public void set(T value) {
            this.m_value = value;
            this.persistParameter(value);
        }

        public T value() {
            if (this.m_value == null) {
                this.m_value = this.restoreParameter();
            } else if (!this.isPerInstance()) {
                this.m_value = this.restoreParameter();
            }
            return this.m_value == null ? this.m_defaultValue : this.m_value;
        }

        public T value(boolean forceRefresh) {
            if (forceRefresh) {
                this.m_value = null;
            }
            return this.value();
        }

        private T restoreParameter() {
            IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
            String memento = store.get(this.getStoreKey(), null);
            if (memento == null) {
                return null;
            }
            String val = MementoUtils.decodeStringFromMemento(memento);
            Object convertedVal = this.convertToT(val);
            return convertedVal;
        }

        private void persistParameter(T value) {
            String memento = MementoUtils.encodeStringIntoMemento(value.toString());
            if (memento != null) {
                IEclipsePreferences store = MulticoreVisualizerUIPlugin.getEclipsePreferenceStore();
                store.put(this.getStoreKey(), memento);
                try {
                    store.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

