/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.SegmentList;

public final class Track
extends SegmentList {
    private final int position;

    public Track(Net net, int position) {
        super(net);
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean hasSegment(long fromTime, long toTime) {
        Segment segment = this.getLastSegment();
        while (segment != null) {
            if (segment.getLastCommitTime() < fromTime) {
                return false;
            }
            if (segment.getFirstVisualTime() < toTime) {
                return true;
            }
            segment = segment.getPreviousInTrack();
        }
        return false;
    }

    public String toString() {
        return "Track[" + this.position + "]";
    }

    protected Segment getNextSegment(Segment segment) {
        return segment.getNextInTrack();
    }

    protected void setNextSegment(Segment segment, Segment nextSegment) {
        segment.setNextInTrack(nextSegment);
    }

    protected Segment getPreviousSegment(Segment segment) {
        return segment.getPreviousInTrack();
    }

    protected void setPreviousSegment(Segment segment, Segment previousSegment) {
        segment.setPreviousInTrack(previousSegment);
    }
}

