/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetsUtils {
    private FacetsUtils() {
    }

    public static Set<FacetSet> getAllKnownFacetSets(Table table) {
        HashSet<FacetSet> result = new HashSet<FacetSet>();
        ResourceSet resourceSet = FacetsUtils.getResourceSet(table);
        Collection<FacetSet> facetSets = FacetsUtils.getRegisteredFacetSets(resourceSet);
        result.addAll(facetSets);
        result.addAll((Collection<FacetSet>)table.getFacetSets());
        return result;
    }

    private static Collection<FacetSet> getRegisteredFacetSets(ResourceSet resourceSet) {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet);
        return catalogMgr.getRegisteredFacetSets();
    }

    public static List<FacetSet> getKnownFacetSets(Table table) {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        EList tableFS = table.getFacetSets();
        ResourceSet resourceSet = FacetsUtils.getResourceSet(table);
        Collection<FacetSet> registeredFS = FacetsUtils.getRegisteredFacetSets(resourceSet);
        result.addAll((Collection<FacetSet>)tableFS);
        result.addAll(registeredFS);
        return result;
    }

    public static List<ETypedElement> getAllKnownETypedElements(Table table) {
        Set<EClassifier> classifiers = FacetsUtils.getAllKnownEClassifiers(table);
        ArrayList<ETypedElement> typedElements = new ArrayList<ETypedElement>();
        for (EClassifier eClassifier : classifiers) {
            typedElements.addAll(FacetsUtils.getContainedETypedElements((EObject)eClassifier));
        }
        return typedElements;
    }

    private static Collection<ETypedElement> getContainedETypedElements(EObject eObject) {
        ArrayList<ETypedElement> typedElements = new ArrayList<ETypedElement>();
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof ETypedElement)) continue;
            ETypedElement eTypedElement = (ETypedElement)element;
            typedElements.add(eTypedElement);
        }
        return typedElements;
    }

    private static Set<EClassifier> getAllKnownEClassifiers(Table table) {
        HashSet<EClassifier> eClassifiers = new HashSet<EClassifier>();
        ResourceSet resourceSet = FacetsUtils.getResourceSet(table);
        IFacetSetCatalogManager facetMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet);
        Collection registeredFS = facetMgr.getRegisteredFacetSets();
        for (FacetSet facetSet : registeredFS) {
            eClassifiers.addAll(FacetUtils.getAllFacet((FacetSet)facetSet));
        }
        for (FacetSet facetSet : table.getFacetSets()) {
            eClassifiers.addAll(FacetUtils.getAllFacet((FacetSet)facetSet));
        }
        for (EObject eObject : TableWidgetUtils.getElements(table)) {
            eClassifiers.add((EClassifier)eObject.eClass());
        }
        return eClassifiers;
    }

    private static ResourceSet getResourceSet(Table table) {
        Resource resource = table.eResource();
        return resource.getResourceSet();
    }

    public static boolean hasStructuralFeature(EObject eObject, ETypedElement structuralFeature, IFacetManager context) throws FacetManagerException {
        DerivedTypedElement derivedTypedElt;
        EObject eContainer;
        boolean result = false;
        EClass eClass = eObject.eClass();
        if (eClass.getEAllStructuralFeatures().contains((Object)structuralFeature)) {
            result = true;
        } else if (structuralFeature instanceof DerivedTypedElement && (eContainer = (derivedTypedElt = (DerivedTypedElement)structuralFeature).eContainer()) instanceof Facet) {
            Facet facet = (Facet)eContainer;
            result = context.isConforming(eObject, facet);
        }
        return result;
    }

    public static void loadManagedFacetSetsInTable(Table table, IFacetManager facetManager) {
        IFacetManager commonFacetMngr = FacetsUtils.getFacetManager((EObject)table);
        if (!facetManager.equals(commonFacetMngr)) {
            facetManager.getManagedFacetSets().clear();
            facetManager.getManagedFacetSets().addAll(table.getFacetSets());
        }
    }

    public static IFacetManager getFacetManager(EObject eObject) {
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        return IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(resourceSet);
    }

    public static IFacetManager getFacetManagerWithGetOrCreateResourceSet(EObject eObject) {
        ResourceSet resourceSet = ModelUtils.getOrCreateResourceSet((EObject)eObject);
        return IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(resourceSet);
    }
}

